/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import net.java.sen.StringTagger;
import net.java.sen.Token;
import net.java.sen.processor.PostProcessor;
import net.java.sen.processor.PreProcessor;

public class StreamTagger {
    private StringTagger stringTagger = null;
    private static final int BUFFER_SIZE = 256;
    private final char[] buffer = new char[256];
    private int cnt = 0;
    private Token[] token;
    private boolean complete = false;
    private Reader reader;

    public StreamTagger(Reader reader, Locale locale) throws IOException, IllegalArgumentException {
        this.stringTagger = StringTagger.getInstance(locale);
        this.reader = reader;
    }

    public StreamTagger(Reader reader) throws IOException, IllegalArgumentException {
        this.stringTagger = StringTagger.getInstance();
        this.reader = reader;
    }

    public StreamTagger(Reader reader, String senConfig) throws IOException, IllegalArgumentException {
        this.stringTagger = StringTagger.getInstance(senConfig);
        this.reader = reader;
    }

    public boolean hasNext() throws IOException {
        if (this.token == null || this.token.length == this.cnt) {
            do {
                int i;
                if ((i = this.readToBuffer()) == -1) {
                    return false;
                }
                this.token = this.stringTagger.analyze(new String(this.buffer, 0, i));
            } while (this.token == null);
            this.cnt = 0;
        }
        return this.token.length != 0;
    }

    private int readToBuffer() throws IOException {
        int pos = 0;
        int res = 0;
        block3: while (pos < 256 && !this.complete && (res = this.reader.read(this.buffer, pos, 1)) != -1) {
            switch (Character.getType(this.buffer[pos])) {
                case 24: {
                    if (pos == 0) continue block3;
                    return pos + 1;
                }
            }
            ++pos;
        }
        if (res == -1) {
            this.complete = true;
        }
        if (this.complete && pos == 0) {
            return -1;
        }
        return pos;
    }

    public Token next() throws IOException {
        if (this.token == null || this.token.length == this.cnt) {
            do {
                int i;
                if ((i = this.readToBuffer()) == -1) {
                    return null;
                }
                this.token = this.stringTagger.analyze(new String(this.buffer, 0, i));
            } while (this.token == null);
            this.cnt = 0;
        }
        return this.token[this.cnt++];
    }

    public void addPostProcessor(PostProcessor processor) {
        this.stringTagger.addPostProcessor(processor);
    }

    public void addPreProcessor(PreProcessor processor) {
        this.stringTagger.addPreProcessor(processor);
    }
}

