/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import net.java.sen.Node;

public final class Token {
    private Node node;
    private String pos = null;
    private String pronunciation = null;
    private String basic = null;
    private String cform = null;
    private String read = null;
    private String nodeStr = null;
    private String addInfo = null;
    private int cost = -1;
    private int start = -1;
    private int length = -1;

    protected Token(Node n) {
        this.node = n;
        this.pos = this.node.getPos();
    }

    public Token() {
    }

    public int start() {
        if (this.start == -1) {
            this.start = this.node.begin;
        }
        return this.start;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public int end() {
        return this.start() + this.length();
    }

    public int length() {
        if (this.length == -1) {
            this.length = this.node.length;
        }
        return this.length;
    }

    public void setLength(int l) {
        this.length = l;
        if (this.node != null) {
            this.node.length = l;
        }
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public String getBasicString() {
        if (this.basic == null) {
            this.basic = this.node.getBasicString();
        }
        return this.basic;
    }

    public void setBasicString(String basic) {
        this.basic = basic;
    }

    public String getCform() {
        if (this.cform == null) {
            this.cform = this.node.getCform();
        }
        return this.cform;
    }

    public void setCform(String cform) {
        this.cform = cform;
    }

    public String getReading() {
        if (this.read == null) {
            this.read = this.node.getReading();
        }
        return this.read;
    }

    public void setReading(String read) {
        this.read = read;
    }

    public String getPronunciation() {
        if (this.pronunciation == null) {
            this.pronunciation = this.node.getPronunciation();
        }
        return this.pronunciation;
    }

    public void setPronunciation(String pronunciation) {
        this.pronunciation = pronunciation;
    }

    public String getSurface() {
        if (this.nodeStr == null) {
            this.nodeStr = this.node.toString();
        }
        return this.nodeStr;
    }

    public void setSurface(String surface) {
        this.nodeStr = surface;
    }

    public int getCost() {
        if (this.cost == -1) {
            this.cost = this.node.getCost();
        }
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public String getAddInfo() {
        if (this.addInfo == null) {
            this.addInfo = this.node.getAddInfo();
        }
        return this.addInfo;
    }

    public void setAddInfo(String addInfo) {
        this.addInfo = addInfo;
    }

    public String getTermInfo() {
        return this.node.termInfo;
    }

    public String toString() {
        return this.getSurface();
    }
}

