/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.IOException;
import net.java.sen.Node;
import net.java.sen.Tokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Viterbi {
    private static Log log = LogFactory.getLog((Class)(class$net$java$sen$Viterbi == null ? (class$net$java$sen$Viterbi = Viterbi.class$("net.java.sen.Viterbi")) : class$net$java$sen$Viterbi));
    private Tokenizer tokenizer;
    private Node eosNode;
    private Node bosNode;
    private char[] sentence;
    private Node[] lookupCache;
    private Node[] endNodeList;
    static /* synthetic */ Class class$net$java$sen$Viterbi;

    public Viterbi() {
        this.tokenizer = null;
    }

    public Viterbi(Tokenizer t) {
        this.tokenizer = t;
        this.init();
    }

    void init() {
        this.endNodeList = null;
        this.lookupCache = null;
        this.bosNode = this.tokenizer.getBOSNode();
        this.eosNode = this.tokenizer.getEOSNode();
    }

    Node lookup(int pos) throws IOException {
        Node resultNode = null;
        if (this.lookupCache[pos] != null) {
            Node node = this.lookupCache[pos];
            while (node != null) {
                Node newNode = this.tokenizer.getNewNode();
                int id = newNode.id;
                newNode.copy(node);
                newNode.rnext = resultNode;
                newNode.id = id;
                resultNode = newNode;
                node = node.rnext;
            }
        } else {
            this.lookupCache[pos] = resultNode = this.tokenizer.lookup(this.sentence, pos);
        }
        return resultNode;
    }

    public synchronized Node analyze(char[] sentence) throws IOException {
        int pos;
        int len = sentence.length;
        log.debug((Object)("sentence = \"" + new String(sentence) + "\""));
        this.init();
        this.endNodeList = new Node[len + 1];
        this.lookupCache = new Node[len + 1];
        this.endNodeList[0] = this.bosNode;
        this.endNodeList[len] = null;
        this.lookupCache[len] = null;
        this.sentence = sentence;
        for (pos = 0; pos < len; ++pos) {
            Node rNode;
            if (this.endNodeList[pos] == null || (rNode = this.lookup(pos)) == null) continue;
            this.calcConnectCost(pos, rNode);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("rNode.token.rcAttr2=" + rNode.token.rcAttr2));
            log.trace((Object)("rNode.token.rcAttr1=" + rNode.token.rcAttr1));
            log.trace((Object)("rNode.token.lcAttr=" + rNode.token.lcAttr));
        }
        for (pos = len; pos >= 0; --pos) {
            if (this.endNodeList[pos] == null) continue;
            this.calcConnectCost(pos, this.eosNode);
            break;
        }
        Node node = this.eosNode;
        while (node.prev != null) {
            Node prevNode = node.prev;
            prevNode.next = node;
            node = prevNode;
        }
        log.debug((Object)"analized");
        Node it = this.bosNode.next;
        while (it != null && it.surface != null) {
            it.termInfo = this.tokenizer.dic.getPosInfo(it.token.posID);
            it = it.next;
        }
        return this.bosNode;
    }

    private final void calcConnectCost(int pos, Node rNode) throws IOException {
        int len = this.sentence.length;
        while (rNode != null) {
            int pos2;
            int bestCost = Integer.MAX_VALUE;
            Node bestNode = null;
            Node lNode = this.endNodeList[pos];
            while (lNode != null) {
                int cost;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("candidate morpheme = " + lNode.toString()));
                    log.trace((Object)("token id = " + lNode.token.posID));
                    log.trace((Object)("lnode.prev(" + lNode.prev.token.rcAttr2 + ") = " + this.tokenizer.dic.getPosInfo(lNode.prev.token.posID)));
                    log.trace((Object)("lnode(" + lNode.token.rcAttr1 + ") = " + this.tokenizer.dic.getPosInfo(lNode.token.posID)));
                    log.trace((Object)("rnode(" + rNode.token.lcAttr + ") = " + this.tokenizer.dic.getPosInfo(rNode.token.posID)));
                }
                if ((cost = lNode.cost + this.tokenizer.getCost(lNode.prev, lNode, rNode)) <= bestCost) {
                    bestNode = lNode;
                    bestCost = cost;
                }
                lNode = lNode.lnext;
            }
            rNode.prev = bestNode;
            rNode.cost = bestCost;
            int x = rNode.end + pos;
            rNode.lnext = this.endNodeList[x];
            this.endNodeList[x] = rNode;
            if (rNode.token.rcAttr2 != 0 && (pos2 = rNode.end + pos) != len) {
                Node rNode2 = this.lookup(pos2);
                while (rNode2 != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("rnode.prev(" + rNode.prev.token.rcAttr2 + ") = " + this.tokenizer.dic.getPosInfo(rNode.prev.token.posID)));
                        log.trace((Object)("rnode(" + rNode.token.rcAttr1 + ") = " + this.tokenizer.dic.getPosInfo(rNode.token.posID)));
                        log.trace((Object)("rnode2(" + rNode2.token.lcAttr + ") = " + this.tokenizer.dic.getPosInfo(rNode2.token.posID)));
                    }
                    rNode2.cost = rNode.cost + this.tokenizer.getCost(rNode.prev, rNode, rNode2);
                    rNode2.prev = rNode;
                    int y = rNode2.end + pos2;
                    rNode2.lnext = this.endNodeList[y];
                    this.endNodeList[y] = rNode2;
                    rNode2 = rNode2.rnext;
                }
            }
            rNode = rNode.rnext;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

