/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.AbstractStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;

class FileStructureVisitor
extends AbstractStructureVisitor {
    private boolean sendEmptyFolders;

    public FileStructureVisitor(Session session, boolean sendEmptyFolders, boolean sendModifiedContents) {
        this(session, sendEmptyFolders, sendModifiedContents, true);
    }

    public FileStructureVisitor(Session session, boolean sendEmptyFolders, boolean sendModifiedContents, boolean sendBinary) {
        super(session, true, sendModifiedContents, sendBinary);
        this.sendEmptyFolders = sendEmptyFolders;
    }

    public void visitFile(ICVSFile mFile) throws CVSException {
        this.sendFile(mFile);
    }

    public void visitFolder(ICVSFolder mFolder) throws CVSException {
        if (this.sendEmptyFolders) {
            this.sendFolder(mFolder);
        }
        boolean exists = mFolder.exists();
        boolean isCVSFolder = mFolder.isCVSFolder();
        if (!isCVSFolder) {
            return;
        }
        if (exists && this.isOrphanedSubtree(mFolder)) {
            return;
        }
        ICVSResource[] children = mFolder.members(123);
        this.sendFiles(children);
        this.sendQuestionableFolders(children);
        this.sendManagedFolders(children);
    }

    private void sendManagedFolders(ICVSResource[] children) throws CVSException {
        int i = 0;
        while (i < children.length) {
            ICVSResource resource = children[i];
            if (resource.isFolder() && resource.isManaged()) {
                resource.accept(this);
            }
            ++i;
        }
    }

    private void sendQuestionableFolders(ICVSResource[] children) throws CVSException {
        int i = 0;
        while (i < children.length) {
            ICVSResource resource = children[i];
            if (resource.isFolder() && !resource.isManaged()) {
                resource.accept(this);
            }
            ++i;
        }
    }

    private void sendFiles(ICVSResource[] children) throws CVSException {
        int i = 0;
        while (i < children.length) {
            ICVSResource resource = children[i];
            if (!resource.isFolder()) {
                resource.accept(this);
            }
            ++i;
        }
    }
}

