/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.text.ParseException;
import java.util.Date;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.CVSDateFormatter;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class ResourceSyncInfo {
    private static final String DEFAULT_PERMISSIONS = "u=rw,g=rw,o=r";
    private static final String DELETED_PREFIX = "-";
    private static final byte DELETED_PREFIX_BYTE = 45;
    public static final String ADDED_REVISION = "0";
    protected static final int TYPE_REGULAR = 1;
    protected static final int TYPE_MERGED = 2;
    protected static final int TYPE_MERGED_WITH_CONFLICTS = 3;
    protected static final String TIMESTAMP_DUMMY = "dummy timestamp";
    protected static final String TIMESTAMP_MERGED = "Result of merge";
    protected static final String TIMESTAMP_MERGED_WITH_CONFLICT = "Result of merge+";
    protected static final String TIMESTAMP_SERVER_MERGED = "+modified";
    protected static final String TIMESTAMP_SERVER_MERGED_WITH_CONFLICT = "+=";
    protected boolean isDirectory = false;
    protected boolean isDeleted = false;
    protected static final String DIRECTORY_PREFIX = "D";
    protected static final String SEPARATOR = "/";
    protected static final byte SEPARATOR_BYTE = 47;
    protected String name;
    protected String revision;
    protected Date timeStamp;
    protected Command.KSubstOption keywordMode;
    protected CVSEntryLineTag tag;
    protected String permissions;
    protected int syncType = 1;

    protected ResourceSyncInfo() {
    }

    public ResourceSyncInfo(byte[] entryLine) throws CVSException {
        this(new String(entryLine), null, null);
    }

    public ResourceSyncInfo(String entryLine, String permissions, Date timestamp) throws CVSException {
        Assert.isNotNull(entryLine);
        this.setEntryLine(entryLine);
        if (permissions != null) {
            this.permissions = permissions;
        }
        if (timestamp != null) {
            this.timeStamp = timestamp;
        }
    }

    public ResourceSyncInfo(String name) {
        Assert.isNotNull(name);
        this.name = name;
        this.isDirectory = true;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isNeedsMerge(Date otherTimestamp) {
        return this.syncType == 3 && this.timeStamp.equals(otherTimestamp);
    }

    public boolean isMergedWithConflicts() {
        return this.syncType == 3;
    }

    public boolean isMerged() {
        return this.syncType == 2 || this.isMergedWithConflicts();
    }

    public boolean isAdded() {
        if (!this.isDirectory) {
            return this.getRevision().equals(ADDED_REVISION);
        }
        return false;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public String getEntryLine() {
        return this.getEntryLine(true, null);
    }

    public String getServerEntryLine(Date fileTimestamp) {
        if (fileTimestamp != null && (this.isMerged() || this.isMergedWithConflicts())) {
            String serverTimestamp = this.isNeedsMerge(fileTimestamp) ? TIMESTAMP_SERVER_MERGED_WITH_CONFLICT : TIMESTAMP_SERVER_MERGED;
            return this.getEntryLine(true, serverTimestamp);
        }
        return this.getEntryLine(false, null);
    }

    public String getPermissionLine() {
        if (this.isDirectory) {
            return null;
        }
        String permissions = this.permissions;
        if (permissions == null) {
            permissions = DEFAULT_PERMISSIONS;
        }
        return SEPARATOR + this.name + SEPARATOR + permissions;
    }

    public String getPermissions() {
        if (this.isDirectory) {
            return null;
        }
        if (this.permissions == null) {
            return DEFAULT_PERMISSIONS;
        }
        return this.permissions;
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getName() {
        return this.name;
    }

    public Command.KSubstOption getKeywordMode() {
        return this.keywordMode;
    }

    public static String getDefaultPermissions() {
        return DEFAULT_PERMISSIONS;
    }

    public boolean equals(Object other) {
        if (other instanceof ResourceSyncInfo) {
            ResourceSyncInfo syncInfo = (ResourceSyncInfo)other;
            if (other == this) {
                return true;
            }
            if (this.getName() == syncInfo.getName()) {
                return true;
            }
            return this.getName().equals(syncInfo.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getEntryLine(true, null);
    }

    public MutableResourceSyncInfo cloneMutable() {
        MutableResourceSyncInfo newSync = new MutableResourceSyncInfo(this);
        return newSync;
    }

    protected void setTag(CVSTag tag) {
        this.tag = tag != null ? new CVSEntryLineTag(tag) : null;
    }

    protected void setSyncType(int syncType) {
        this.syncType = syncType;
    }

    protected void setRevision(String revision) {
        if (revision == null || revision.equals(ADDED_REVISION)) {
            this.revision = ADDED_REVISION;
            this.timeStamp = null;
            this.syncType = 1;
            this.isDeleted = false;
        } else if (revision.startsWith(DELETED_PREFIX)) {
            this.revision = revision.substring(DELETED_PREFIX.length());
            this.isDeleted = true;
        } else {
            this.revision = revision;
            this.isDeleted = false;
        }
    }

    protected void setEntryLine(String entryLine) throws CVSException {
        String tagEntry;
        String[] strings = Util.parseIntoSubstrings(entryLine, SEPARATOR);
        if (strings.length < 6) {
            throw new CVSException(String.valueOf(Policy.bind("Malformed_entry_line___11")) + entryLine);
        }
        this.isDirectory = strings[0].equals(DIRECTORY_PREFIX);
        this.name = strings[1];
        if (this.name.length() == 0) {
            throw new CVSException(String.valueOf(Policy.bind("Malformed_entry_line,_missing_name___12")) + entryLine);
        }
        String rev = strings[2];
        if (rev.length() == 0 && !this.isDirectory()) {
            throw new CVSException(String.valueOf(Policy.bind("Malformed_entry_line,_missing_revision___13")) + entryLine);
        }
        this.setRevision(rev);
        String date = strings[3];
        if (date.indexOf(TIMESTAMP_SERVER_MERGED) != -1) {
            this.syncType = 2;
            date = null;
        } else if (date.indexOf(TIMESTAMP_SERVER_MERGED_WITH_CONFLICT) != -1) {
            this.syncType = 3;
            date = null;
        } else if (date.indexOf(TIMESTAMP_MERGED_WITH_CONFLICT) != -1) {
            date = date.substring(date.indexOf("+") + 1);
            this.syncType = 3;
        } else if (date.indexOf(TIMESTAMP_MERGED) != -1) {
            this.syncType = 2;
            date = null;
        }
        if (date == null || "".equals(date)) {
            this.timeStamp = null;
        } else {
            try {
                this.timeStamp = CVSDateFormatter.entryLineToDate(date);
            }
            catch (ParseException parseException) {
                this.timeStamp = null;
            }
        }
        this.keywordMode = Command.KSubstOption.fromMode(strings[4]);
        if (strings.length == 6) {
            tagEntry = strings[5];
        } else {
            StringBuffer buffer = new StringBuffer();
            int i = 5;
            while (i < strings.length) {
                buffer.append(strings[i]);
                if (i < strings.length - 1) {
                    buffer.append(SEPARATOR);
                }
                ++i;
            }
            tagEntry = buffer.toString();
        }
        this.tag = tagEntry.length() > 0 ? new CVSEntryLineTag(tagEntry) : null;
    }

    private String getEntryLine(boolean includeTimeStamp, String timestampOverride) {
        StringBuffer result = new StringBuffer();
        if (this.isDirectory) {
            result.append(DIRECTORY_PREFIX);
            result.append(SEPARATOR);
            result.append(this.name);
            int i = 0;
            while (i < 4) {
                result.append(SEPARATOR);
                ++i;
            }
        } else {
            result.append(SEPARATOR);
            result.append(this.name);
            result.append(SEPARATOR);
            if (this.isDeleted) {
                result.append(DELETED_PREFIX);
            }
            result.append(this.revision);
            result.append(SEPARATOR);
            if (includeTimeStamp) {
                String entryLineTimestamp = "";
                if (timestampOverride != null) {
                    entryLineTimestamp = timestampOverride;
                } else {
                    switch (this.syncType) {
                        case 1: {
                            if (this.timeStamp == null) {
                                entryLineTimestamp = TIMESTAMP_DUMMY;
                                break;
                            }
                            entryLineTimestamp = CVSDateFormatter.dateToEntryLine(this.timeStamp);
                            break;
                        }
                        case 2: {
                            entryLineTimestamp = TIMESTAMP_MERGED;
                            break;
                        }
                        case 3: {
                            entryLineTimestamp = TIMESTAMP_MERGED_WITH_CONFLICT + CVSDateFormatter.dateToEntryLine(this.timeStamp);
                        }
                    }
                }
                result.append(entryLineTimestamp);
            }
            result.append(SEPARATOR);
            if (this.keywordMode != null) {
                result.append(this.keywordMode.toMode());
            }
            result.append(SEPARATOR);
            if (this.tag != null) {
                result.append(this.tag.toEntryLineFormat(true));
            }
        }
        return result.toString();
    }

    public boolean needsReporting() {
        return false;
    }

    public void reported() {
    }

    public byte[] getBytes() {
        return this.getEntryLine().getBytes();
    }

    public static String getName(byte[] syncBytes) throws CVSException {
        String name = Util.getSubstring(syncBytes, (byte)47, 1, false);
        if (name == null) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        return name;
    }

    public static Command.KSubstOption getKeywordMode(byte[] syncBytes) throws CVSException {
        String mode = Util.getSubstring(syncBytes, (byte)47, 4, false);
        if (mode == null) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        return Command.KSubstOption.fromMode(mode);
    }

    public static byte[] setKeywordMode(byte[] syncBytes, Command.KSubstOption mode) throws CVSException {
        return ResourceSyncInfo.setKeywordMode(syncBytes, mode.toMode().getBytes());
    }

    public static byte[] setKeywordMode(byte[] syncBytes, byte[] modeBytes) throws CVSException {
        return ResourceSyncInfo.setSlot(syncBytes, 4, modeBytes);
    }

    public static boolean isBinary(byte[] syncBytes) throws CVSException {
        if (syncBytes == null) {
            return false;
        }
        String mode = Util.getSubstring(syncBytes, (byte)47, 4, false);
        if (mode == null) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        return "-kb".equals(mode);
    }

    public static boolean isFolder(byte[] syncBytes) {
        return syncBytes.length > 0 && syncBytes[0] == 68;
    }

    public static boolean isAddition(byte[] syncBytes) throws CVSException {
        int start = ResourceSyncInfo.startOfSlot(syncBytes, 2);
        if (start == -1 || start >= syncBytes.length) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        return syncBytes[start + 1] == 48;
    }

    public static boolean isDeletion(byte[] syncBytes) throws CVSException {
        int start = ResourceSyncInfo.startOfSlot(syncBytes, 2);
        if (start == -1 || start >= syncBytes.length) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        return syncBytes[start + 1] == 45;
    }

    public static byte[] convertToDeletion(byte[] syncBytes) throws CVSException {
        int index = ResourceSyncInfo.startOfSlot(syncBytes, 2);
        if (index == -1) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        if (syncBytes.length > index && syncBytes[index + 1] != 45) {
            byte[] newSyncBytes = new byte[syncBytes.length + 1];
            System.arraycopy(syncBytes, 0, newSyncBytes, 0, index + 1);
            newSyncBytes[index + 1] = 45;
            System.arraycopy(syncBytes, index + 1, newSyncBytes, index + 2, syncBytes.length - index - 1);
            return newSyncBytes;
        }
        return syncBytes;
    }

    public static byte[] convertFromDeletion(byte[] syncBytes) throws CVSException {
        int index = ResourceSyncInfo.startOfSlot(syncBytes, 2);
        if (index == -1) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        if (syncBytes.length > index && syncBytes[index + 1] == 45) {
            byte[] newSyncBytes = new byte[syncBytes.length - 1];
            System.arraycopy(syncBytes, 0, newSyncBytes, 0, index + 1);
            System.arraycopy(syncBytes, index + 2, newSyncBytes, index + 1, newSyncBytes.length - index - 1);
            return newSyncBytes;
        }
        return syncBytes;
    }

    private static int startOfSlot(byte[] syncBytes, int slot) {
        int count = 0;
        int j = 0;
        while (j < syncBytes.length) {
            if (syncBytes[j] == 47 && ++count == slot) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private static byte[] setSlot(byte[] syncBytes, int slot, byte[] newBytes) throws CVSException {
        int start = ResourceSyncInfo.startOfSlot(syncBytes, slot);
        if (start == -1) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        int end = ResourceSyncInfo.startOfSlot(syncBytes, slot + 1);
        int totalLength = start + 1 + newBytes.length;
        if (end != -1) {
            totalLength += syncBytes.length - end;
        }
        byte[] result = new byte[totalLength];
        System.arraycopy(syncBytes, 0, result, 0, start + 1);
        System.arraycopy(newBytes, 0, result, start + 1, newBytes.length);
        if (end != -1) {
            System.arraycopy(syncBytes, end, result, start + 1 + newBytes.length, syncBytes.length - end);
        }
        return result;
    }

    public static String getTimestampToServer(byte[] syncBytes, Date fileTimestamp) throws CVSException {
        if (fileTimestamp != null) {
            String syncTimestamp = Util.getSubstring(syncBytes, (byte)47, 3, false);
            if (syncTimestamp == null) {
                throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
            }
            int syncType = ResourceSyncInfo.getSyncType(syncTimestamp);
            if (syncType != 1) {
                if (syncType == 3 && fileTimestamp.equals(ResourceSyncInfo.getTimestamp(syncTimestamp))) {
                    return TIMESTAMP_SERVER_MERGED_WITH_CONFLICT;
                }
                return TIMESTAMP_SERVER_MERGED;
            }
        }
        return null;
    }

    private static Date getTimestamp(String syncTimestamp) {
        String dateString = syncTimestamp;
        if (syncTimestamp.indexOf(TIMESTAMP_SERVER_MERGED) != -1) {
            dateString = null;
        } else if (syncTimestamp.indexOf(TIMESTAMP_SERVER_MERGED_WITH_CONFLICT) != -1) {
            dateString = null;
        } else if (syncTimestamp.indexOf(TIMESTAMP_MERGED_WITH_CONFLICT) != -1) {
            dateString = syncTimestamp.substring(syncTimestamp.indexOf("+") + 1);
        } else if (syncTimestamp.indexOf(TIMESTAMP_MERGED) != -1) {
            dateString = null;
        }
        if (dateString == null || "".equals(dateString)) {
            return null;
        }
        try {
            return CVSDateFormatter.entryLineToDate(dateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static int getSyncType(String date) {
        if (date.indexOf(TIMESTAMP_SERVER_MERGED) != -1) {
            return 2;
        }
        if (date.indexOf(TIMESTAMP_SERVER_MERGED_WITH_CONFLICT) != -1) {
            return 3;
        }
        if (date.indexOf(TIMESTAMP_MERGED_WITH_CONFLICT) != -1) {
            return 3;
        }
        if (date.indexOf(TIMESTAMP_MERGED) != -1) {
            return 2;
        }
        return 1;
    }

    public static byte[] getTagBytes(byte[] syncBytes) throws CVSException {
        byte[] tag = Util.getBytesForSlot(syncBytes, (byte)47, 5, true);
        if (tag == null) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        return tag;
    }

    public static byte[] setTag(byte[] syncBytes, byte[] tagBytes) throws CVSException {
        return ResourceSyncInfo.setSlot(syncBytes, 5, tagBytes);
    }

    public static byte[] setTag(byte[] syncBytes, CVSTag tag) throws CVSException {
        CVSEntryLineTag entryTag = tag instanceof CVSEntryLineTag ? (CVSEntryLineTag)tag : new CVSEntryLineTag(tag);
        return ResourceSyncInfo.setTag(syncBytes, entryTag.toEntryLineFormat(true).getBytes());
    }

    public static String getRevision(byte[] syncBytes) throws CVSException {
        String revision = Util.getSubstring(syncBytes, (byte)47, 2, false);
        if (revision == null) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        if (revision.startsWith(DELETED_PREFIX)) {
            revision = revision.substring(DELETED_PREFIX.length());
        }
        return revision;
    }

    public static byte[] setRevision(byte[] syncBytes, String revision) throws CVSException {
        return ResourceSyncInfo.setSlot(syncBytes, 2, revision.getBytes());
    }

    public static boolean isMerge(byte[] syncBytes) throws CVSException {
        String timestamp = Util.getSubstring(syncBytes, (byte)47, 3, false);
        if (timestamp == null) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        int syncType = ResourceSyncInfo.getSyncType(timestamp);
        return syncType == 2 || syncType == 3;
    }

    public static boolean isMergedWithConflicts(byte[] syncBytes) throws CVSException {
        String timestamp = Util.getSubstring(syncBytes, (byte)47, 3, false);
        if (timestamp == null) {
            throw new CVSException(Policy.bind("ResourceSyncInfo.malformedSyncBytes", new String(syncBytes)));
        }
        int syncType = ResourceSyncInfo.getSyncType(timestamp);
        return syncType == 3;
    }

    public static boolean isLaterRevisionOnSameBranch(byte[] remoteBytes, byte[] localBytes) throws CVSException {
        String localRevision;
        byte[] localTag;
        if (remoteBytes == localBytes) {
            return false;
        }
        byte[] remoteTag = ResourceSyncInfo.getTagBytes(remoteBytes);
        if (!Util.equals(remoteTag, localTag = ResourceSyncInfo.getTagBytes(localBytes))) {
            return false;
        }
        String remoteRevision = ResourceSyncInfo.getRevision(remoteBytes);
        if (remoteRevision.equals(localRevision = ResourceSyncInfo.getRevision(localBytes))) {
            return false;
        }
        return ResourceSyncInfo.isLaterRevision(remoteRevision, localRevision);
    }

    public static boolean isLaterRevision(String remoteRevision, String localRevision) {
        int[] localDigits = Util.convertToDigits(localRevision);
        if (localDigits.length == 0) {
            return false;
        }
        int[] remoteDigits = Util.convertToDigits(remoteRevision);
        if (remoteDigits.length == 0) {
            return false;
        }
        if (localRevision.equals(ADDED_REVISION)) {
            return remoteDigits.length >= 2;
        }
        if (localDigits.length < remoteDigits.length) {
            int i = 0;
            while (i < localDigits.length) {
                int remoteDigit = remoteDigits[i];
                int localDigit = localDigits[i];
                if (remoteDigit != localDigit) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < remoteDigits.length - 1) {
            int remoteDigit = remoteDigits[i];
            int localDigit = localDigits[i];
            if (remoteDigit != localDigit) {
                return false;
            }
            ++i;
        }
        return localDigits[remoteDigits.length - 1] < remoteDigits[remoteDigits.length - 1];
    }
}

