/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.AdaptableResourceList;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CheckoutAsProjectSelectionPage
extends CVSWizardPage {
    public static final String NAME = "CheckoutAsProjectSelectionPage";
    private TreeViewer tree;
    private Text nameField;
    private Combo filterList;
    private Button recurseCheck;
    private IResource selection;
    private ICVSRemoteFolder[] remoteFolders;
    private String folderName;
    private boolean recurse;
    private int filter;

    public CheckoutAsProjectSelectionPage(ImageDescriptor titleImage, ICVSRemoteFolder[] remoteFolders) {
        super(NAME, Policy.bind("CheckoutAsProjectSelectionPage.title"), titleImage, Policy.bind("CheckoutAsProjectSelectionPage.description"));
        this.remoteFolders = remoteFolders;
    }

    private boolean isSingleFolder() {
        return this.remoteFolders.length == 1;
    }

    private String getInputFolderName() {
        return this.remoteFolders[0].getName();
    }

    private String getRepository() throws CVSException {
        return this.remoteFolders[0].getFolderSyncInfo().getRoot();
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.checkout_into_resource_selection_page_context");
        if (this.isSingleFolder()) {
            CVSWizardPage.createLabel(composite, Policy.bind("CheckoutAsProjectSelectionPage.name"));
            this.nameField = CVSWizardPage.createTextField(composite);
            this.nameField.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    CheckoutAsProjectSelectionPage.this.folderName = CheckoutAsProjectSelectionPage.this.nameField.getText();
                    CheckoutAsProjectSelectionPage.this.updateWidgetEnablements();
                }
            });
        }
        this.createWrappingLabel(composite, Policy.bind("CheckoutAsProjectSelectionPage.treeLabel"), 0, 2);
        this.tree = this.createResourceSelectionTree(composite, 6, 2);
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CheckoutAsProjectSelectionPage.this.handleResourceSelection(event);
            }
        });
        Composite filterComposite = this.createComposite(composite, 2);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        filterComposite.setLayoutData((Object)data);
        CVSWizardPage.createLabel(filterComposite, Policy.bind("CheckoutAsProjectSelectionPage.showLabel"));
        this.filterList = this.createCombo(filterComposite);
        this.filterList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutAsProjectSelectionPage.this.handleFilterSelection();
            }
        });
        this.createWrappingLabel(composite, "", 0, 2);
        this.recurseCheck = this.createCheckBox(composite, Policy.bind("CheckoutAsProjectSelectionPage.recurse"));
        this.recurseCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckoutAsProjectSelectionPage.this.recurse = CheckoutAsProjectSelectionPage.this.recurseCheck.getSelection();
                CheckoutAsProjectSelectionPage.this.updateWidgetEnablements();
            }
        });
        this.initializeValues();
        this.updateWidgetEnablements();
        this.tree.getControl().setFocus();
        Dialog.applyDialogFont((Control)parent);
    }

    private void initializeValues() {
        if (this.isSingleFolder()) {
            this.nameField.setText(this.getInputFolderName());
        }
        this.tree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.recurse = true;
        this.recurseCheck.setSelection(this.recurse);
        this.filter = 0;
        this.updateTreeContents(this.filter);
        this.filterList.add(Policy.bind("CheckoutAsProjectSelectionPage.showAll"));
        this.filterList.add(Policy.bind("CheckoutAsProjectSelectionPage.showUnshared"));
        this.filterList.add(Policy.bind("CheckoutAsProjectSelectionPage.showSameRepo"));
        this.filterList.select(this.filter);
    }

    private void handleResourceSelection(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (sel.isEmpty()) {
            this.selection = null;
        } else if (sel instanceof IStructuredSelection) {
            this.selection = (IResource)((IStructuredSelection)sel).getFirstElement();
        }
        this.updateWidgetEnablements();
    }

    private void updateWidgetEnablements() {
        if (this.isSingleFolder() && !Path.EMPTY.isValidSegment(this.folderName)) {
            this.setPageComplete(false);
            this.setErrorMessage(Policy.bind("CheckoutAsProjectSelectionPage.invalidFolderName", this.folderName));
            return;
        }
        boolean complete = this.selection != null && this.selection.getType() != 1;
        this.setErrorMessage(null);
        this.setPageComplete(complete);
    }

    public IResource getSelection() {
        return this.selection;
    }

    public String getFolderName() {
        return this.folderName;
    }

    private void updateTreeContents(int selected) {
        try {
            if (selected == 0) {
                this.tree.setInput((Object)new AdaptableResourceList((IResource[])this.getProjects(this.getRepository(), true)));
            } else if (selected == 1) {
                this.tree.setInput((Object)new AdaptableResourceList((IResource[])this.getProjects(null, true)));
            } else if (selected == 2) {
                this.tree.setInput((Object)new AdaptableResourceList((IResource[])this.getProjects(this.getRepository(), false)));
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private IProject[] getProjects(String root, boolean unshared) throws CVSException {
        ArrayList<IProject> validTargets = new ArrayList<IProject>();
        try {
            IResource[] projects = ResourcesPlugin.getWorkspace().getRoot().members();
            int i = 0;
            while (i < projects.length) {
                IProject project;
                IResource resource = projects[i];
                if (resource instanceof IProject && (project = (IProject)resource).isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                    if (provider == null && unshared) {
                        validTargets.add(project);
                    } else if (provider != null && provider.getID().equals(CVSProviderPlugin.getTypeId())) {
                        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
                        FolderSyncInfo info = cvsFolder.getFolderSyncInfo();
                        if (root != null && info != null && root.equals(info.getRoot())) {
                            validTargets.add(project);
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
        return validTargets.toArray(new IProject[validTargets.size()]);
    }

    public IContainer getLocalFolder() {
        if (Path.EMPTY.isValidSegment(this.folderName)) {
            return ((IContainer)this.getSelection()).getFolder((IPath)new Path(this.folderName));
        }
        return null;
    }

    public IContainer getParentFolder() {
        return (IContainer)this.getSelection();
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    private void handleFilterSelection() {
        this.filter = this.filterList.getSelectionIndex();
        this.updateTreeContents(this.filter);
    }
}

