<?xml version="1.0" encoding="Shift_JIS"?>

<!-- XSLT stylesheet for ChaOne with ChaSen Chunker ver. 1.1.0 -->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xalan="http://xml.apache.org/xalan"
  xmlns:msxml="urn:schemas-microsoft-com:xslt"
  exclude-result-prefixes="xalan msxml"
  version="1.0"
  xml:lang="ja">

  <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>

  <xsl:param name="standalone"/>

  <xsl:variable name="ea_symbol_table" select="document('ea_symbol_table.xml')/ea_symbol_table"/>
  <xsl:variable name="hk_table" select="document('hk_table.xml')/hk_table"/>
  <xsl:variable name="chunk_rules" select="document('chunk_rules.xml')/chunk_rules"/>
  <xsl:variable name="IPAForm_table" select="document('IPAForm.xml')/IPAForm_table"/>
  <xsl:variable name="FPAForm_table" select="document('FPAForm.xml')/FPAForm_table"/>

  <xsl:template match="/">
    <xsl:apply-templates select="S" mode="prep"/>
  </xsl:template>

  <xsl:template match="S" mode="prep">
    <xsl:variable name="preps">
      <preps>
        <xsl:for-each select="*">
          <xsl:choose>
            <xsl:when test="@pos = 'm'">
              <xsl:call-template name="ea-symbol-chk">
                <xsl:with-param name="orth" select="@orth"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:copy-of select="."/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </preps>
    </xsl:variable>
    <S>
      <xsl:choose>
        <xsl:when test="$standalone = 'chaone'">
          <xsl:apply-templates mode="chaone"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="msxml:node-set($preps)/preps/*"/>
        </xsl:otherwise>
      </xsl:choose>
    </S>
  </xsl:template>

  <!-- preprocess for unknown pos with English Alphabet -->
  <xsl:template name="ea-symbol-chk">
    <xsl:param name="orth"/>
    <xsl:variable name="hits">
      <xsl:for-each select="msxml:node-set($ea_symbol_table)/W1[starts-with($orth, @orth)]">
        <xsl:sort select="string-length(@orth)"/>
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="hit" select="msxml:node-set($hits)[1]"/>
    <xsl:choose>
      <xsl:when test="$hit/W1/@orth">
        <xsl:copy-of select="$hit/W1"/>
        <xsl:if test="string-length($orth) > string-length($hit/W1/@orth)">
          <xsl:variable name="rest" select="substring($orth, string-length($hit/W1/@orth) + 1)"/>
          <!-- *** recursive call *** -->
          <xsl:call-template name="ea-symbol-chk">
            <xsl:with-param name="orth" select="$rest"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- standalone ChaOne -->
  <xsl:template match="@*|node()" mode="chaone">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" mode="chaone"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="W2[not(@pron)]" mode="chaone">
    <!-- pronȂW2ɑ΂鉹C֏ -->
    <!-- W2̎qvfłeW1ɂĂ̏ -->
    <xsl:variable name="W1-list">
      <xsl:apply-templates select="W1" mode="alt"/>
    </xsl:variable>
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="pron">
        <xsl:for-each select="msxml:node-set($W1-list)/W1">
          <xsl:value-of select="@pron"/>
        </xsl:for-each>
      </xsl:attribute>
      <xsl:copy-of select="$W1-list"/>
    </xsl:copy>
  </xsl:template>

  <!-- chunker -->
  <xsl:template match="*[not(self::W1)]" priority="-10">
    <!-- W1ȊȌ -->
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="W1[(position() = 1)
                          or (preceding-sibling::W1[1][@w2Chunk = 'E'])
                          or (preceding-sibling::*[1][not(self::W1)])]">
    <!-- 擪ȂĚȂW1ȊÕm[ȟ̃m[hI -->
    <!-- 擪ȂĚȂW1ȊÕm[ȟ납AŌȂBȂW1ȊȎO܂ł̃m[hΏ -->
    <xsl:call-template name="select-target"/>
  </xsl:template>

  <xsl:template name="select-target">
    <!-- KKp͈͂̌ƓKp -->
    <!-- current = "W1" -->
    <xsl:variable name="from">
      <xsl:apply-templates select="." mode="get-position"/>
    </xsl:variable>
    <xsl:variable name="to">
      <xsl:call-template name="calc-to">
        <xsl:with-param name="from" select="$from"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="selected-rules">
      <xsl:call-template name="select-rules">
        <xsl:with-param name="input" select="parent::*[1]"/>
        <xsl:with-param name="from" select="$from"/>
        <xsl:with-param name="to" select="$to"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="apply-rules">
      <xsl:with-param name="input" select="parent::*[1]"/>
      <xsl:with-param name="from" select="$from"/>
      <xsl:with-param name="to" select="$to"/>
      <xsl:with-param name="rules">
        <xsl:for-each select="msxml:node-set($selected-rules)/range">
          <xsl:sort select="@from" data-type="number"/>
          <xsl:copy-of select="."/>
        </xsl:for-each>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="calc-to">
    <!-- ŌȂB̑OȂW1ȊÕm[h̑Õm[ĥłÖʒuԂ -->
    <xsl:param name="from"/>
    <xsl:variable name="Bpos">
      <xsl:if test="following-sibling::W1[@w2Chunk = 'B']">
        <xsl:choose>
          <xsl:when test="following-sibling::W1[1][@w2Chunk = 'B']">
            <xsl:value-of select="$from"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates
              select="following-sibling::W1[not(@w2Chunk)][following-sibling::W1[1][@w2Chunk = 'B']][1]"
              mode="get-position"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="nonW1pos">
      <xsl:if test="following-sibling::*[not(self::W1)]">
        <xsl:variable name="nonW1poscand">
          <xsl:choose>
            <xsl:when test="following-sibling::*[1][not(self::W1)]">
              <xsl:value-of select="$from"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates
                select="following-sibling::W1[following-sibling::*[1][not(self::W1)]][1]"
                mode="get-position"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="number($nonW1poscand)">
            <xsl:value-of select="$nonW1poscand"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$from"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="lastpos">
      <xsl:apply-templates
        select="following-sibling::W1[last()]"
        mode="get-position"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="number($Bpos) and number($nonW1pos)">
        <xsl:choose>
          <xsl:when test="number($nonW1pos) > number($Bpos)">
            <xsl:value-of select="$Bpos"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$nonW1pos"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="number($Bpos)">
        <xsl:value-of select="$Bpos"/>
      </xsl:when>
      <xsl:when test="number($nonW1pos)">
        <xsl:value-of select="$nonW1pos"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="number($lastpos)">
            <xsl:value-of select="$lastpos"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$from"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="node()" mode="get-position">
    <xsl:value-of select="count(preceding-sibling::*) + 1"/>
  </xsl:template>

  <xsl:template name="select-rules">
    <!-- current = "W1" -->
    <!-- returns <range rule="id" from="from" to="to"/>... -->
    <xsl:param name="input"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <!-- Kp\ȂׂĂ̋Kɂ'id,from,to'vZ -->
    <xsl:variable name="applicable-rules">
      <xsl:for-each select="msxml:node-set($chunk_rules)/rule">
        <xsl:call-template name="check-rule">
          <xsl:with-param name="input" select="$input"/>
          <xsl:with-param name="from" select="$from"/>
          <xsl:with-param name="to" select="$to"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:variable>
    <!-- ̂Kp͈͂̍L̂珇ɗ\Ȃ -->
    <xsl:variable name="sorted-rules">
      <xsl:for-each select="msxml:node-set($applicable-rules)/range">
        <xsl:sort select="@to - @from" order="descending" data-type="number"/>
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:for-each select="msxml:node-set($sorted-rules)/range">
      <xsl:variable name="rfrom" select="@from"/>
      <xsl:variable name="rto" select="@to"/>
      <xsl:variable name="chk">
        <xsl:for-each select="preceding-sibling::range">
          <xsl:choose>
            <xsl:when test="(number($rto) &lt; number(@from)) or (number($rfrom) > number(@to))">
              <xsl:text>T</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>F</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </xsl:variable>
      <xsl:if test="not(contains($chk, 'F'))">
        <xsl:copy-of select="."/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="check-rule">
    <!-- rule$from$to͈̔͂̂ǂɓKp\ǂ̃`FbN -->
    <!-- YrulerhsׂĖ邩ǂ -->
    <!-- current = "rule" -->
    <!-- returns <range id="id" from="from" to="to"/>... -->
    <xsl:param name="input"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:variable name="results">
      <xsl:call-template name="check-rule-top">
        <xsl:with-param name="input" select="$input"/>
        <xsl:with-param name="from" select="$from"/>
        <xsl:with-param name="to" select="$to"/>
      </xsl:call-template>
    </xsl:variable>
    <!-- return value -->
    <xsl:variable name="id" select="@id"/>
    <xsl:for-each select="msxml:node-set($results)/range">
      <xsl:copy>
        <xsl:attribute name="id">
          <xsl:value-of select="$id"/>
        </xsl:attribute>
        <xsl:copy-of select="@*"/>
      </xsl:copy>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="check-rule-top">
    <!-- returns <range from="from" to="to"/> ... -->
    <!-- current = "rule" -->
    <xsl:param name="input"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:variable name="targets"
                  select="$input/*[(position() >= number($from)) and (position() &lt;= number($to))]"/>

    <xsl:choose>
      <!-- rhs̃gbvɂW1ȂchoiceƉ -->
      <xsl:when test="rhs/W1">
        <!-- rhs̃gbv̐擪W1ɂď -->
        <xsl:variable name="rhs-cur" select="rhs/W1[1]"/>
        <xsl:variable name="rhs-pre" select="rhs/*[generate-id(following-sibling::W1[1]) = generate-id($rhs-cur)]"/>
        <xsl:variable name="rhs-post" select="rhs/*[generate-id(preceding-sibling::W1[last()]) = generate-id($rhs-cur)]"/>
        <xsl:choose>
          <xsl:when test="$targets[self::W1 and contains(@pos, $rhs-cur/@pos)]">
            <xsl:variable name="hit-locs">
              <xsl:for-each select="$targets[self::W1 and contains(@pos, $rhs-cur/@pos)]">
                <hit>
                  <xsl:apply-templates select="." mode="get-position"/>
                </hit>
                </xsl:for-each>
            </xsl:variable>
            <!-- $targetŝ𖞂ׂĂW1ɂď -->
            <xsl:variable name="results">
              <xsl:for-each select="msxml:node-set($hit-locs)/hit">
                <xsl:call-template name="calc-result">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="hit-loc" select="."/>
                  <xsl:with-param name="rhs-pre" select="$rhs-pre"/>
                  <xsl:with-param name="rhs-post" select="$rhs-post"/>
                  <xsl:with-param name="from" select="$from"/>
                  <xsl:with-param name="to" select="$to"/>
                </xsl:call-template>
              </xsl:for-each>
            </xsl:variable>
            <xsl:copy-of select="$results"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>F</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="rhs/choice">
      <!-- *** -->
      </xsl:when>
      <!--
      <xsl:when test="rhs/zeroOrMore">
      </xsl:when>
      <xsl:when test="rhs/oneOrMore">
      </xsl:when>
      <xsl:when test="rhs/optional">
      </xsl:when>
      -->
    </xsl:choose>
  </xsl:template>

  <xsl:template name="calc-result">
    <!-- current = "rule" -->
    <!-- returns <range from="from" to="to"/> or 'F' -->
    <xsl:param name="input"/>
    <xsl:param name="hit-loc"/>
    <xsl:param name="rhs-pre"/>
    <xsl:param name="rhs-post"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:variable name="rhs-pre-result">
      <xsl:if test="count($rhs-pre)">
        <xsl:call-template name="check-rule-pre">
          <xsl:with-param name="input" select="$input"/>
          <xsl:with-param name="from" select="$from"/>
          <xsl:with-param name="to" select="$hit-loc - 1"/>
          <xsl:with-param name="rhs" select="$rhs-pre"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="rhs-post-result">
      <xsl:if test="count($rhs-post)">
        <xsl:call-template name="check-rule-post">
          <xsl:with-param name="input" select="$input"/>
          <xsl:with-param name="from" select="$hit-loc + 1"/>
          <xsl:with-param name="to" select="$to"/>
          <xsl:with-param name="rhs" select="$rhs-post"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="($rhs-pre-result = 'F') or ($rhs-post-result = 'F')">
        <xsl:text>F</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="range">
          <xsl:attribute name="from">
            <xsl:choose>
              <xsl:when test="$rhs-pre-result != ''">
                <xsl:value-of select="$rhs-pre-result"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$hit-loc"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:attribute name="to">
            <xsl:choose>
              <xsl:when test="$rhs-post-result != ''">
                <xsl:value-of select="$rhs-post-result"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$hit-loc"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="check-rule-pre">
    <!-- returns 'from' or 'F' -->
    <!-- current = "text()" -->
    <xsl:param name="input"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:param name="rhs"/>
    <xsl:call-template name="check-rule-des">
      <xsl:with-param name="input" select="$input"/>
      <xsl:with-param name="dir" select="'pre'"/>
      <xsl:with-param name="from" select="$from"/>
      <xsl:with-param name="to" select="$to"/>
      <xsl:with-param name="rhs" select="$rhs"/>
      <xsl:with-param name="rhs-cur" select="$rhs[last()]"/>
      <xsl:with-param name="rhs-des" select="$rhs[position() != last()]"/>
      <xsl:with-param name="target-cur" select="$input/*[number($to)]"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="check-rule-post">
    <!-- returns 'to' or 'F' -->
    <!-- current = "text()" -->
    <xsl:param name="input"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:param name="rhs"/>
    <xsl:call-template name="check-rule-des">
      <xsl:with-param name="input" select="$input"/>
      <xsl:with-param name="dir" select="'post'"/>
      <xsl:with-param name="from" select="$from"/>
      <xsl:with-param name="to" select="$to"/>
      <xsl:with-param name="rhs" select="$rhs"/>
      <xsl:with-param name="rhs-cur" select="$rhs[1]"/>
      <xsl:with-param name="rhs-des" select="$rhs[position() != 1]"/>
      <xsl:with-param name="target-cur" select="$input/*[number($from)]"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="check-rule-des">
    <!-- returns 'from | to' or 'F' -->
    <!-- current = "text()" -->
    <xsl:param name="input"/>
    <xsl:param name="dir"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:param name="rhs"/>
    <xsl:param name="rhs-cur"/>
    <xsl:param name="rhs-des"/>
    <xsl:param name="target-cur"/>
    <xsl:variable name="targets" select="$input/*[(position() >= number($from)) and (position() &lt;= number($to))]"/>
    <xsl:variable name="end">
      <xsl:choose>
        <xsl:when test="$dir = 'pre'">
          <xsl:value-of select="$from"/>
        </xsl:when>
        <xsl:when test="$dir = 'post'">
          <xsl:value-of select="$to"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$rhs-cur[name() = 'W1']">
        <xsl:choose>
          <xsl:when test="$target-cur[starts-with(@pos, $rhs-cur/@pos)]">
            <xsl:call-template name="check-rule-des-next-one">
              <xsl:with-param name="input" select="$input"/>
              <xsl:with-param name="dir" select="$dir"/>
              <xsl:with-param name="end" select="$end"/>
              <xsl:with-param name="rhs-des" select="$rhs-des"/>
              <xsl:with-param name="target-cur" select="$target-cur"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>F</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$rhs-cur[name() = 'zeroOrMore']">
      <!-- qƂW1Ȃchoice -->
        <xsl:choose>
          <xsl:when test="$rhs-cur/W1">
            <xsl:choose>
              <xsl:when test="$target-cur[starts-with(@pos, $rhs-cur/W1/@pos)]">
                <!-- $targets ̂AŌ猩ď𖞂т̐擪 -->
                <xsl:call-template name="check-rule-des-next-more">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="rhs-cur" select="$rhs-cur"/>
                  <xsl:with-param name="targets" select="$targets"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <!-- next processing -->
                <xsl:call-template name="check-rule-des-next-zero">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="from" select="$from"/>
                  <xsl:with-param name="to" select="$to"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$rhs-cur/choice">
            <!-- select candidate that matches target-cur -->
            <xsl:variable name="choice-res">
              <xsl:for-each select="$rhs-cur/choice/W1">
                <xsl:if test="$target-cur[starts-with(@pos, ./@pos)]">
                  <xsl:text>T</xsl:text>
                </xsl:if>
              </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="contains($choice-res, 'T')">
                <xsl:call-template name="check-rule-des-next-more">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="rhs-cur" select="$rhs-cur"/>
                  <xsl:with-param name="targets" select="$targets"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <!-- next processing -->
                <xsl:call-template name="check-rule-des-next-zero">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="from" select="$from"/>
                  <xsl:with-param name="to" select="$to"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <!--
      <xsl:when test="$rhs-cur[name() = 'oneOrMore']">
      </xsl:when>
      -->
      <xsl:when test="$rhs-cur[name() = 'optional']">
        <!-- qƂW1Ȃchoice -->
        <xsl:choose>
          <xsl:when test="$rhs-cur/W1">
            <xsl:choose>
              <xsl:when test="$target-cur[starts-with(@pos, $rhs-cur/W1/@pos)]">
                <xsl:call-template name="check-rule-des-next-one">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="target-cur" select="$target-cur"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <!-- next processing -->
                <xsl:call-template name="check-rule-des-next-zero">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="from" select="$from"/>
                  <xsl:with-param name="to" select="$to"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$rhs-cur/choice">
            <!-- select candidate that matches target-cur -->
            <xsl:variable name="choice-res">
              <xsl:for-each select="$rhs-cur/choice/W1">
                <xsl:if test="$target-cur[starts-with(@pos, ./@pos)]">
                  <xsl:text>T</xsl:text>
                </xsl:if>
              </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="contains($choice-res, 'T')">
                <xsl:call-template name="check-rule-des-next-one">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="target-cur" select="$target-cur"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <!-- next processing -->
                <xsl:call-template name="check-rule-des-next-zero">
                  <xsl:with-param name="input" select="$input"/>
                  <xsl:with-param name="dir" select="$dir"/>
                  <xsl:with-param name="end" select="$end"/>
                  <xsl:with-param name="rhs-des" select="$rhs-des"/>
                  <xsl:with-param name="from" select="$from"/>
                  <xsl:with-param name="to" select="$to"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$rhs-cur[name() = 'choice']">
        <!-- select candidate that matches target-cur -->
        <xsl:variable name="choice-res">
          <xsl:for-each select="$rhs-cur/W1">
            <xsl:if test="$target-cur[starts-with(@pos, ./@pos)]">
              <xsl:text>T</xsl:text>
            </xsl:if>
          </xsl:for-each>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="contains($choice-res, 'T')">
            <xsl:call-template name="check-rule-des-next-one">
              <xsl:with-param name="input" select="$input"/>
              <xsl:with-param name="dir" select="$dir"/>
              <xsl:with-param name="end" select="$end"/>
              <xsl:with-param name="rhs-des" select="$rhs-des"/>
              <xsl:with-param name="target-cur" select="$target-cur"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>F</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="des-bound">
    <xsl:param name="dir"/>
    <xsl:param name="rhs-cur"/>
    <xsl:param name="targets"/>
    <xsl:choose>
      <xsl:when test="$dir = 'pre'">
        <xsl:choose>
          <xsl:when test="$rhs-cur/W1">
            <xsl:variable name="nomatch" select="$targets[not(starts-with(@pos, $rhs-cur/W1/@pos))]"/>
            <xsl:choose>
              <xsl:when test="count($nomatch)">
                <xsl:variable name="nmlp">
                  <xsl:apply-templates select="$nomatch[last()]" mode="get-position"/>
                </xsl:variable>
                <xsl:value-of select="$nmlp + 1"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$targets[1]" mode="get-position"/>
              </xsl:otherwise>
            </xsl:choose>      
          </xsl:when>
          <xsl:when test="$rhs-cur/choice">
            <xsl:variable name="nmlocs">
              <xsl:for-each select="$targets">
                <xsl:variable name="ct" select="."/>
                <xsl:variable name="chit">
                  <xsl:for-each select="$rhs-cur/choice/W1">
                    <xsl:if test="starts-with($ct/@pos, @pos)">
                      <xsl:text>T</xsl:text>
                    </xsl:if>
                  </xsl:for-each>
                </xsl:variable>
                <xsl:if test="not(contains($chit, 'T'))">
                  <xsl:text>#</xsl:text>
                  <xsl:value-of select="position()"/>
                  <xsl:text>#</xsl:text>
                </xsl:if>
              </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="nomatch" select="$targets[contains($nmlocs, concat('#', position(), '#'))]"/>
            <xsl:choose>
              <xsl:when test="count($nomatch)">
                <xsl:variable name="nmlp">
                  <xsl:apply-templates select="$nomatch[last()]" mode="get-position"/>
                </xsl:variable>
                <xsl:value-of select="$nmlp + 1"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$targets[1]" mode="get-position"/>
              </xsl:otherwise>
            </xsl:choose>      
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$dir = 'post'">
        <xsl:choose>
          <xsl:when test="$rhs-cur/W1">
            <xsl:variable name="nomatch" select="$targets[not(starts-with(@pos, $rhs-cur/W1/@pos))]"/>
            <xsl:choose>
              <xsl:when test="count($nomatch)">
                <xsl:variable name="nmfp">
                  <xsl:apply-templates select="$nomatch[1]" mode="get-position"/>
                </xsl:variable>
                <xsl:value-of select="$nmfp - 1"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$targets[last()]" mode="get-position"/>
              </xsl:otherwise>
            </xsl:choose>      
          </xsl:when>
          <xsl:when test="$rhs-cur/choice">
            <xsl:variable name="nmlocs">
              <xsl:for-each select="$targets">
                <xsl:variable name="ct" select="."/>
                <xsl:variable name="chit">
                  <xsl:for-each select="$rhs-cur/choice/W1">
                    <xsl:if test="starts-with($ct/@pos, @pos)">
                      <xsl:text>T</xsl:text>
                    </xsl:if>
                  </xsl:for-each>
                </xsl:variable>
                <xsl:if test="not(contains($chit, 'T'))">
                  <xsl:text>#</xsl:text>
                  <xsl:value-of select="position()"/>
                  <xsl:text>#</xsl:text>
                </xsl:if>
              </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="nomatch" select="$targets[contains($nmlocs, concat('#', position(), '#'))]"/>
            <xsl:choose>
              <xsl:when test="count($nomatch)">
                <xsl:variable name="nmfp">
                  <xsl:apply-templates select="$nomatch[1]" mode="get-position"/>
                </xsl:variable>
                <xsl:value-of select="$nmfp - 1"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$targets[last()]" mode="get-position"/>
              </xsl:otherwise>
            </xsl:choose>      
          </xsl:when>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="check-rule-des-next-one">
    <xsl:param name="input"/>
    <xsl:param name="dir"/>
    <xsl:param name="end"/>
    <xsl:param name="rhs-des"/>
    <xsl:param name="target-cur"/>
    <xsl:call-template name="check-rule-des-next-main">
      <xsl:with-param name="input" select="$input"/>
      <xsl:with-param name="dir" select="$dir"/>
      <xsl:with-param name="end" select="$end"/>
      <xsl:with-param name="rhs-des" select="$rhs-des"/>
      <xsl:with-param name="hit-loc">
        <xsl:apply-templates select="$target-cur" mode="get-position"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="check-rule-des-next-more">
    <xsl:param name="input"/>
    <xsl:param name="dir"/>
    <xsl:param name="end"/>
    <xsl:param name="rhs-des"/>
    <xsl:param name="rhs-cur"/>
    <xsl:param name="targets"/>
    <xsl:call-template name="check-rule-des-next-main">
      <xsl:with-param name="input" select="$input"/>
      <xsl:with-param name="dir" select="$dir"/>
      <xsl:with-param name="end" select="$end"/>
      <xsl:with-param name="rhs-des" select="$rhs-des"/>
      <xsl:with-param name="hit-loc">
        <xsl:call-template name="des-bound">
          <xsl:with-param name="dir" select="$dir"/>
          <xsl:with-param name="rhs-cur" select="$rhs-cur"/>
          <xsl:with-param name="targets" select="$targets"/>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="check-rule-des-next-zero">
    <xsl:param name="input"/>
    <xsl:param name="dir"/>
    <xsl:param name="end"/>
    <xsl:param name="rhs-des"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:call-template name="check-rule-des-next-main">
      <xsl:with-param name="input" select="$input"/>
      <xsl:with-param name="dir" select="$dir"/>
      <xsl:with-param name="end" select="$end"/>
      <xsl:with-param name="rhs-des" select="$rhs-des"/>
      <xsl:with-param name="hit-loc">
        <xsl:choose>
          <xsl:when test="$dir = 'pre'">
            <xsl:value-of select="$to + 1"/>
          </xsl:when>
          <xsl:when test="$dir = 'post'">
            <xsl:value-of select="$from - 1"/>
          </xsl:when>
        </xsl:choose>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="check-rule-des-next-main">
    <!-- current = "text()" -->
    <xsl:param name="input"/>
    <xsl:param name="dir"/>
    <xsl:param name="end"/>
    <xsl:param name="rhs-des"/>
    <xsl:param name="hit-loc"/>
    <xsl:variable name="rhs-des-result">
      <xsl:if test="count($rhs-des)">
       	<xsl:choose>
          <xsl:when test="$dir = 'pre'">
            <!-- *** recursive call *** -->
            <xsl:call-template name="check-rule-des">
              <xsl:with-param name="input" select="$input"/>
              <xsl:with-param name="dir" select="$dir"/>
              <xsl:with-param name="from" select="$end"/>
              <xsl:with-param name="to" select="$hit-loc - 1"/>
              <xsl:with-param name="rhs" select="$rhs-des"/>
              <xsl:with-param name="rhs-cur" select="$rhs-des[last()]"/>
              <xsl:with-param name="rhs-des" select="$rhs-des[position() != last()]"/>
              <xsl:with-param name="target-cur" select="$input/*[number($hit-loc) - 1]"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="$dir = 'post'">
            <!-- *** recursive call *** -->
            <xsl:call-template name="check-rule-des">
              <xsl:with-param name="input" select="$input"/>
              <xsl:with-param name="dir" select="$dir"/>
              <xsl:with-param name="from" select="$hit-loc + 1"/>
              <xsl:with-param name="to" select="$end"/>
              <xsl:with-param name="rhs" select="$rhs-des"/>
              <xsl:with-param name="rhs-cur" select="$rhs-des[1]"/>
              <xsl:with-param name="rhs-des" select="$rhs-des[position() != 1]"/>
              <xsl:with-param name="target-cur" select="$input/*[number($hit-loc) + 1]"/>
            </xsl:call-template>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$rhs-des-result = 'F'">
        <xsl:text>F</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$rhs-des-result != ''">
            <xsl:value-of select="$rhs-des-result"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$hit-loc"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<!-- KɃ}b`W1m[hZbgW2̍쐬 -->

  <xsl:template name="apply-rules">
    <xsl:param name="input"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:param name="rules"/>
    <xsl:for-each select="msxml:node-set($rules)/range">
      <xsl:variable name="last">
        <xsl:choose>
          <xsl:when test="position() = 1">
            <xsl:value-of select="$from"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="number(preceding-sibling::range[1]/@to) + 1"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="rid" select="@id"/>
      <xsl:variable name="rfrom" select="@from"/>
      <xsl:variable name="rto" select="@to"/>
      <xsl:if test="number($last) &lt; number(@from)">
        <xsl:for-each select="$input/*[(position() >= number($last)) and (position() &lt; number($rfrom))]">
          <xsl:copy-of select="."/>
        </xsl:for-each>
      </xsl:if>
      <xsl:variable name="W1-list">
        <xsl:for-each select="$input/*[(position() >= number($rfrom)) and (position() &lt;= number($rto))]">
          <xsl:choose>
            <xsl:when test="$standalone = 'chunker'">
              <xsl:copy-of select="."/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="." mode="alt"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </xsl:variable>
      <W2>
        <xsl:attribute name="orth">
          <xsl:for-each select="$input/*[(position() >= number($rfrom)) and (position() &lt;= number($rto))]">
            <xsl:value-of select="@orth"/>
          </xsl:for-each>
        </xsl:attribute>
        <xsl:attribute name="pos">
          <xsl:value-of select="msxml:node-set($chunk_rules)/rule[@id = $rid]/lhs/W2/@pos"/>
        </xsl:attribute>
        <xsl:if test="$standalone != 'chunker'">
          <xsl:attribute name="pron">
            <xsl:for-each select="msxml:node-set($W1-list)/W1">
              <xsl:value-of select="@pron"/>
            </xsl:for-each>
          </xsl:attribute>
        </xsl:if>
        <xsl:variable name="cType" select="$input/*[number($rto)]/@cType"/>
        <xsl:if test="$cType">
          <xsl:attribute name="cType">
            <xsl:value-of select="$cType"/>
          </xsl:attribute>
        </xsl:if>
        <xsl:variable name="cForm" select="$input/*[number($rto)]/@cForm"/>
        <xsl:if test="$cForm">
          <xsl:attribute name="cForm">
            <xsl:value-of select="$cForm"/>
          </xsl:attribute>
        </xsl:if>
        <xsl:copy-of select="$W1-list"/>
      </W2>
    </xsl:for-each>
    <xsl:variable name="last">
      <xsl:choose>
        <xsl:when test="msxml:node-set($rules)/range[last()]/@to">
          <xsl:value-of select="number(msxml:node-set($rules)/range[last()]/@to) + 1"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$from"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="number($to) >= number($last)">
      <xsl:for-each select="$input/*[(position() >= number($last)) and (position() &lt;= number($to))]">
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

<!-- B,I,EɂW2̍쐬 -->

  <xsl:template match="W1[@w2Chunk = 'B']" priority="10">
    <xsl:variable name="nthB" select="count(preceding-sibling::W1[@w2Chunk = 'B']) + 1"/>
    <xsl:element name="W2">
      <xsl:for-each select="@*[starts-with(name(), 'w2_')]">
        <xsl:attribute name="{substring-after(name(), 'w2_')}">
          <xsl:value-of select="."/>
        </xsl:attribute>
      </xsl:for-each>
      <xsl:apply-templates select="." mode="delete-w2-info"/>
      <xsl:apply-templates select="following-sibling::W1[(@w2Chunk = 'I') and (count(preceding-sibling::W1[@w2Chunk = 'B']) = $nthB)]" mode="delete-w2-info"/>
      <xsl:apply-templates select="following-sibling::W1[@w2Chunk = 'E'][1]" mode="delete-w2-info"/> 
    </xsl:element>
  </xsl:template>

  <xsl:template match="W1" mode="delete-w2-info">
    <xsl:element name="W1">
      <xsl:for-each select="@*[not(starts-with(name(), 'w2'))]">
        <xsl:attribute name="{name()}">
          <xsl:value-of select="."/>
        </xsl:attribute>
      </xsl:for-each>
    </xsl:element>  
  </xsl:template>

  <xsl:template match="W1[@w2Chunk = 'I']" priority="10">
  </xsl:template>

  <xsl:template match="W1[@w2Chunk = 'E']" priority="10">
  </xsl:template>

  <!-- ChaOne inside W2 -->
  <xsl:template match="W1" mode="alt">
    <xsl:variable name="ipaForm">
      <xsl:if test="@ipaType">
        <xsl:call-template name="calc-ipaForm"/>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="fpaForm">
      <xsl:if test="@fpaType">
        <xsl:call-template name="calc-fpaForm"/>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="pron">
      <xsl:call-template name="calc-pron">
        <xsl:with-param name="ipaForm" select="$ipaForm"/>
        <xsl:with-param name="fpaForm" select="$fpaForm"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:if test="string($ipaForm)">
        <xsl:attribute name="ipaForm">
          <xsl:value-of select="$ipaForm"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="string($fpaForm)">
        <xsl:attribute name="fpaForm">
          <xsl:value-of select="$fpaForm"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="string($pron)">
        <xsl:attribute name="pron">
          <xsl:value-of select="$pron"/>
        </xsl:attribute>
      </xsl:if>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="calc-ipaForm">
    <!-- current() = W1 -->
    <!-- returns value of ipaForm or nothing -->
    <xsl:variable name="ipaConType">
      <xsl:value-of select="preceding-sibling::W1[1]/@ipaConType"/>
    </xsl:variable>
    <xsl:variable name="ipaType" select="@ipaType"/>
    <xsl:if test="string($ipaConType)">
      <xsl:value-of select="msxml:node-set($IPAForm_table)/IPAFormDefs[@IPAType = $ipaType]/IPAFormDef[@IPAConType = $ipaConType]/@IPAForm"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="calc-fpaForm">
    <!-- current() = W1 -->
    <!-- returns value of fpaForm or nothing -->
    <xsl:variable name="fpaConTypes">
      <xsl:value-of select="following-sibling::W1[1]/@fpaConType"/>
    </xsl:variable>
    <xsl:variable name="fpaType" select="@fpaType"/>
    <xsl:if test="string($fpaConTypes)">
      <xsl:variable name="fpaConType">
        <xsl:choose>
          <xsl:when test="contains($fpaConTypes, ',')">
            <xsl:value-of select="substring-before($fpaConTypes, ',')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$fpaConTypes"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:value-of select="msxml:node-set($FPAForm_table)/FPAFormDefs[@FPAType = $fpaType]/FPAFormDef[@FPAConType = $fpaConType]/@FPAForm"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="calc-pron">
    <!-- current() = W1 -->
    <!-- returns value of pron -->
    <xsl:param name="ipaForm"/>
    <xsl:param name="fpaForm"/>
    <xsl:call-template name="ipaForm-pron-alt">
      <xsl:with-param name="ipaForm" select="$ipaForm"/>
      <xsl:with-param name="pron">
        <xsl:call-template name="fpaForm-pron-alt">
          <xsl:with-param name="fpaForm" select="$fpaForm"/>
          <xsl:with-param name="pron" select="@pron"/>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="ipaForm-pron-alt">
    <!-- current() = W1 -->
    <!-- returns value of pron -->
    <xsl:param name="ipaForm"/>
    <xsl:param name="pron"/>
    <xsl:variable name="ipaType" select="@ipaType"/>
    <xsl:choose>
      <xsl:when test="string($ipaForm)">
        <xsl:call-template name="alt-head">
          <xsl:with-param name="pron" select="$pron"/>
          <xsl:with-param name="len" select="string-length(msxml:node-set($IPAForm_table)/IPAFormDefs[@IPAType = $ipaType]/IPApronDef[@IPAForm = '{`']/@pron)"/>
          <xsl:with-param name="alt" select="msxml:node-set($IPAForm_table)/IPAFormDefs[@IPAType = $ipaType]/IPApronDef[@IPAForm = $ipaForm]/@pron"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$pron"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="fpaForm-pron-alt">
    <!-- current() = W1 -->
    <!-- returns value of pron -->
    <xsl:param name="fpaForm"/>
    <xsl:param name="pron"/>
    <xsl:variable name="fpaType" select="@fpaType"/>
    <xsl:choose>
      <xsl:when test="string($fpaForm)">
        <xsl:call-template name="alt-tail">
          <xsl:with-param name="pron" select="$pron"/>
          <xsl:with-param name="len" select="string-length(msxml:node-set($FPAForm_table)/FPAFormDefs[@FPAType = $fpaType]/FPApronDef[@FPAForm = '{`']/@pron)"/>
          <xsl:with-param name="alt" select="msxml:node-set($FPAForm_table)/FPAFormDefs[@FPAType = $fpaType]/FPApronDef[@FPAForm = $fpaForm]/@pron"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$pron"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="alt-head">
    <xsl:param name="pron"/>
    <xsl:param name="len"/>
    <xsl:param name="alt"/>
    <xsl:value-of select="$alt"/>
    <xsl:value-of select="substring($pron, number($len) + 1)"/>
  </xsl:template>

  <xsl:template name="alt-tail">
    <xsl:param name="pron"/>
    <xsl:param name="len"/>
    <xsl:param name="alt"/>
    <xsl:value-of select="substring($pron, 1, string-length($pron) - number($len))"/>
    <xsl:value-of select="$alt"/>
  </xsl:template>

</xsl:stylesheet>
