/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ResourceInfoPage
extends PropertyPage {
    private Button editableBox;
    private Button derivedBox;
    private boolean previousReadOnlyValue;
    private boolean previousDerivedValue;
    private IContentDescription cachedContentDescription;
    private Combo encodingCombo;
    private Button defaultEncodingButton;
    private Button otherEncodingButton;
    private static String READ_ONLY = IDEWorkbenchMessages.getString("ResourceInfo.readOnly");
    private static String DERIVED = IDEWorkbenchMessages.getString("ResourceInfo.derived");
    private static String TYPE_TITLE = IDEWorkbenchMessages.getString("ResourceInfo.type");
    private static String LOCATION_TITLE = IDEWorkbenchMessages.getString("ResourceInfo.location");
    private static String RESOLVED_LOCATION_TITLE = IDEWorkbenchMessages.getString("ResourceInfo.resolvedLocation");
    private static String SIZE_TITLE = IDEWorkbenchMessages.getString("ResourceInfo.size");
    private static String BYTES_LABEL = IDEWorkbenchMessages.getString("ResourceInfo.bytes");
    private static String FILE_LABEL = IDEWorkbenchMessages.getString("ResourceInfo.file");
    private static String FILE_TYPE_FORMAT = IDEWorkbenchMessages.getString("ResourceInfo.fileTypeFormat");
    private static String FOLDER_LABEL = IDEWorkbenchMessages.getString("ResourceInfo.folder");
    private static String PROJECT_LABEL = IDEWorkbenchMessages.getString("ResourceInfo.project");
    private static String LINKED_FILE_LABEL = IDEWorkbenchMessages.getString("ResourceInfo.linkedFile");
    private static String LINKED_FOLDER_LABEL = IDEWorkbenchMessages.getString("ResourceInfo.linkedFolder");
    private static String UNKNOWN_LABEL = IDEWorkbenchMessages.getString("ResourceInfo.unknown");
    private static String NOT_LOCAL_TEXT = IDEWorkbenchMessages.getString("ResourceInfo.notLocal");
    private static String MISSING_PATH_VARIABLE_TEXT = IDEWorkbenchMessages.getString("ResourceInfo.undefinedPathVariable");
    private static String NOT_EXIST_TEXT = IDEWorkbenchMessages.getString("ResourceInfo.notExist");
    private static String PATH_TITLE = IDEWorkbenchMessages.getString("ResourceInfo.path");
    private static String TIMESTAMP_TITLE = IDEWorkbenchMessages.getString("ResourceInfo.lastModified");
    private static String FILE_NOT_EXIST_TEXT = IDEWorkbenchMessages.getString("ResourceInfo.fileNotExist");
    private static String FILE_ENCODING_TITLE = IDEWorkbenchMessages.getString("WorkbenchPreference.encoding");
    private static String CONTAINER_ENCODING_TITLE = IDEWorkbenchMessages.getString("ResourceInfo.fileEncodingTitle");
    private static String FILE_CONTENT_ENCODING_FORMAT = IDEWorkbenchMessages.getString("ResourceInfo.fileContentEncodingFormat");
    private static String FILE_CONTAINER_ENCODING_FORMAT = IDEWorkbenchMessages.getString("ResourceInfo.fileContainerEncodingFormat");
    private static String CONTAINER_ENCODING_FORMAT = IDEWorkbenchMessages.getString("ResourceInfo.containerEncodingFormat");
    private static final int MAX_VALUE_WIDTH = 80;

    private Composite createBasicInfoGroup(Composite parent, IResource resource) {
        Font font = parent.getFont();
        Composite basicInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        basicInfoComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        basicInfoComposite.setLayoutData((Object)data);
        basicInfoComposite.setFont(font);
        Label pathLabel = new Label(basicInfoComposite, 0);
        pathLabel.setText(PATH_TITLE);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        pathLabel.setLayoutData((Object)gd);
        pathLabel.setFont(font);
        Text pathValueText = new Text(basicInfoComposite, 72);
        pathValueText.setText(resource.getFullPath().toString());
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        pathValueText.setLayoutData((Object)gd);
        pathValueText.setFont(font);
        Label typeTitle = new Label(basicInfoComposite, 16384);
        typeTitle.setText(TYPE_TITLE);
        typeTitle.setFont(font);
        Text typeValue = new Text(basicInfoComposite, 16392);
        typeValue.setText(this.getTypeString(resource));
        typeValue.setFont(font);
        Label locationTitle = new Label(basicInfoComposite, 16384);
        locationTitle.setText(LOCATION_TITLE);
        gd = new GridData();
        gd.verticalAlignment = 128;
        locationTitle.setLayoutData((Object)gd);
        locationTitle.setFont(font);
        Text locationValue = new Text(basicInfoComposite, 72);
        locationValue.setText(this.getLocationText(resource));
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        locationValue.setLayoutData((Object)gd);
        locationValue.setFont(font);
        if (this.isPathVariable(resource)) {
            Label resolvedLocationTitle = new Label(basicInfoComposite, 16384);
            resolvedLocationTitle.setText(RESOLVED_LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            resolvedLocationTitle.setLayoutData((Object)gd);
            resolvedLocationTitle.setFont(font);
            Text resolvedLocationValue = new Text(basicInfoComposite, 72);
            resolvedLocationValue.setText(this.getResolvedLocationText(resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            resolvedLocationValue.setLayoutData((Object)gd);
            resolvedLocationValue.setFont(font);
        }
        if (resource.getType() == 1) {
            Label sizeTitle = new Label(basicInfoComposite, 16384);
            sizeTitle.setText(SIZE_TITLE);
            sizeTitle.setFont(font);
            Text sizeValue = new Text(basicInfoComposite, 16392);
            sizeValue.setText(this.getSizeString((IFile)resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            sizeValue.setLayoutData((Object)gd);
            sizeValue.setFont(font);
        }
        return basicInfoComposite;
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.ide.resource_info_property_page_context");
        IResource resource = (IResource)this.getElement();
        if (resource.getType() != 4) {
            this.previousReadOnlyValue = resource.isReadOnly();
            this.previousDerivedValue = resource.isDerived();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createBasicInfoGroup(composite, resource);
        this.createSeparator(composite);
        this.createStateGroup(composite, resource);
        new Label(composite, 0);
        this.createEncodingGroup(composite, resource);
        return composite;
    }

    private void createEditableButton(Composite composite) {
        this.editableBox = new Button(composite, 131104);
        this.editableBox.setAlignment(16384);
        this.editableBox.setText(READ_ONLY);
        this.editableBox.setSelection(this.previousReadOnlyValue);
        this.editableBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.editableBox.setLayoutData((Object)data);
    }

    private void createDerivedButton(Composite composite) {
        this.derivedBox = new Button(composite, 131104);
        this.derivedBox.setAlignment(16384);
        this.derivedBox.setText(DERIVED);
        this.derivedBox.setSelection(this.previousDerivedValue);
        this.derivedBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.derivedBox.setLayoutData((Object)data);
    }

    private void createSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void createStateGroup(Composite parent, IResource resource) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Label timeStampLabel = new Label(composite, 0);
        timeStampLabel.setText(TIMESTAMP_TITLE);
        timeStampLabel.setFont(font);
        Text timeStampValue = new Text(composite, 8);
        timeStampValue.setText(this.getDateStringValue(resource));
        timeStampValue.setFont(font);
        timeStampValue.setLayoutData((Object)new GridData(768));
        if (resource.getType() != 4) {
            this.createEditableButton(composite);
            this.createDerivedButton(composite);
        }
    }

    private void createEncodingGroup(Composite parent, IResource resource) {
        String enc;
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        if (resource instanceof IContainer) {
            group.setText(CONTAINER_ENCODING_TITLE);
        } else {
            group.setText(FILE_ENCODING_TITLE);
        }
        group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceInfoPage.this.updateEncodingState(ResourceInfoPage.this.defaultEncodingButton.getSelection());
                ResourceInfoPage.this.updateValidState();
            }
        };
        this.defaultEncodingButton = new Button((Composite)group, 16);
        String encoding = this.getEncoding(resource);
        String format = CONTAINER_ENCODING_FORMAT;
        String defaultEnc = null;
        if (resource instanceof IFile) {
            defaultEnc = this.getEncodingFromContent((IFile)resource);
            String string = format = defaultEnc != null ? FILE_CONTENT_ENCODING_FORMAT : FILE_CONTAINER_ENCODING_FORMAT;
        }
        if (defaultEnc == null) {
            defaultEnc = this.getEncoding((IResource)resource.getParent());
        }
        this.defaultEncodingButton.setText(MessageFormat.format(format, defaultEnc));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.defaultEncodingButton.setLayoutData((Object)data);
        this.defaultEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.defaultEncodingButton.setFont(font);
        this.otherEncodingButton = new Button((Composite)group, 16);
        this.otherEncodingButton.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.otherEncoding"));
        this.otherEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.otherEncodingButton.setFont(font);
        this.encodingCombo = new Combo((Composite)group, 0);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(15);
        this.encodingCombo.setFont(font);
        this.encodingCombo.setLayoutData((Object)data);
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceInfoPage.this.updateValidState();
            }
        });
        ArrayList<String> encodings = new ArrayList<String>();
        int n = 0;
        try {
            n = Integer.parseInt(IDEWorkbenchMessages.getString("WorkbenchPreference.numDefaultEncodings"));
        }
        catch (NumberFormatException numberFormatException) {}
        int i = 0;
        while (i < n) {
            enc = IDEWorkbenchMessages.getString("WorkbenchPreference.defaultEncoding" + (i + 1), null);
            if (enc != null) {
                encodings.add(enc);
            }
            ++i;
        }
        String defaultEnc1 = System.getProperty("file.encoding", "UTF-8");
        if (!encodings.contains(defaultEnc1)) {
            encodings.add(defaultEnc1);
        }
        if (!encodings.contains(enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding"))) {
            encodings.add(enc);
        }
        Collections.sort(encodings);
        int i2 = 0;
        while (i2 < encodings.size()) {
            this.encodingCombo.add((String)encodings.get(i2));
            ++i2;
        }
        this.encodingCombo.setText(encoding);
        this.updateEncodingState(this.usesDefaultEncoding(resource));
    }

    private String getEncoding(IResource resource) {
        try {
            if (resource instanceof IContainer) {
                return ((IContainer)resource).getDefaultCharset();
            }
            if (resource instanceof IFile) {
                return ((IFile)resource).getCharset();
            }
        }
        catch (CoreException coreException) {}
        IContainer parent = resource.getParent();
        return this.getEncoding((IResource)parent);
    }

    private String getEncodingFromContent(IFile file) {
        IContentDescription description = this.getContentDescription(file);
        if (description != null) {
            byte[] bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK);
            if (bom == null) {
                return (String)description.getProperty(IContentDescription.CHARSET);
            }
            if (bom == IContentDescription.BOM_UTF_8) {
                return IDEWorkbenchMessages.getString("WorkbenchPreference.encoding.BOM_UTF_8");
            }
            if (bom == IContentDescription.BOM_UTF_16BE) {
                return IDEWorkbenchMessages.getString("WorkbenchPreference.encoding.BOM_UTF_16BE");
            }
            if (bom == IContentDescription.BOM_UTF_16LE) {
                return IDEWorkbenchMessages.getString("WorkbenchPreference.encoding.BOM_UTF_16LE");
            }
        }
        return null;
    }

    private String getContentTypeString(IFile file) {
        IContentType contentType;
        IContentDescription description = this.getContentDescription(file);
        if (description != null && (contentType = description.getContentType()) != null) {
            return contentType.getName();
        }
        return null;
    }

    private IContentDescription getContentDescription(IFile file) {
        if (this.cachedContentDescription == null) {
            try {
                this.cachedContentDescription = file.getContentDescription();
            }
            catch (CoreException coreException) {}
        }
        return this.cachedContentDescription;
    }

    private boolean usesDefaultEncoding(IResource resource) {
        try {
            if (resource instanceof IContainer) {
                return ((IContainer)resource).getDefaultCharset(false) == null;
            }
            if (resource instanceof IFile) {
                return ((IFile)resource).getCharset(false) == null;
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    private void updateEncodingState(boolean useDefault) {
        this.defaultEncodingButton.setSelection(useDefault);
        this.otherEncodingButton.setSelection(!useDefault);
        this.encodingCombo.setEnabled(!useDefault);
        this.updateValidState();
    }

    protected void updateValidState() {
        if (this.isEncodingValid()) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(IDEWorkbenchMessages.getString("WorkbenchPreference.unsupportedEncoding"));
            this.setValid(false);
        }
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isValidEncoding(this.encodingCombo.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    private String getDateStringValue(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            DateFormat format = DateFormat.getDateTimeInstance(1, 2);
            return format.format(new Date(localFile.lastModified()));
        }
        return NOT_EXIST_TEXT;
    }

    private String getLocationText(IResource resource) {
        File file;
        IPath resolvedLocation;
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resolvedLocation = resource.getLocation();
        if (resource.isLinked()) {
            location = resource.getRawLocation();
        }
        if (location == null) {
            return NOT_EXIST_TEXT;
        }
        String locationString = location.toOSString();
        if (resolvedLocation != null && !this.isPathVariable(resource) && !(file = resolvedLocation.toFile()).exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    private String getResolvedLocationText(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        String locationString = location.toOSString();
        File file = location.toFile();
        if (!file.exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    private String getSizeString(IFile file) {
        if (!file.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = file.getLocation();
        if (location == null) {
            if (file.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            String bytesString = Long.toString(localFile.length());
            return MessageFormat.format(BYTES_LABEL, bytesString);
        }
        return NOT_EXIST_TEXT;
    }

    private String getTypeString(IResource resource) {
        if (resource.getType() == 1) {
            String contentType;
            if (resource.isLinked()) {
                return LINKED_FILE_LABEL;
            }
            if (resource instanceof IFile && (contentType = this.getContentTypeString((IFile)resource)) != null) {
                return MessageFormat.format(FILE_TYPE_FORMAT, contentType);
            }
            return FILE_LABEL;
        }
        if (resource.getType() == 2) {
            if (resource.isLinked()) {
                return LINKED_FOLDER_LABEL;
            }
            return FOLDER_LABEL;
        }
        if (resource.getType() == 4) {
            return PROJECT_LABEL;
        }
        return UNKNOWN_LABEL;
    }

    private boolean isPathVariable(IResource resource) {
        if (!resource.isLinked()) {
            return false;
        }
        IPath resolvedLocation = resource.getLocation();
        if (resolvedLocation == null) {
            return true;
        }
        IPath rawLocation = resource.getRawLocation();
        return !resolvedLocation.equals((Object)rawLocation);
    }

    protected void performDefaults() {
        if (this.editableBox != null) {
            this.editableBox.setSelection(false);
        }
        if (this.derivedBox != null) {
            this.derivedBox.setSelection(false);
        }
        if (this.defaultEncodingButton != null) {
            this.updateEncodingState(true);
        }
    }

    public boolean performOk() {
        boolean localReadOnlyValue;
        IResource resource = (IResource)this.getElement();
        if (this.isEncodingValid()) {
            String previousEncoding = null;
            if (!this.usesDefaultEncoding(resource)) {
                previousEncoding = this.getEncoding(resource);
            }
            String newEncoding = null;
            if (!this.defaultEncodingButton.getSelection()) {
                newEncoding = this.encodingCombo.getText();
            }
            if (previousEncoding == null && newEncoding != null || previousEncoding != null && newEncoding == null || previousEncoding != null && newEncoding != null && !previousEncoding.equals(newEncoding)) {
                try {
                    if (resource instanceof IFile) {
                        ((IFile)resource).setCharset(newEncoding, null);
                    } else if (resource instanceof IContainer) {
                        ((IContainer)resource).setDefaultCharset(newEncoding, null);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("InternalError"), (String)e.getLocalizedMessage(), (IStatus)e.getStatus());
                    return false;
                }
            }
        }
        if (this.editableBox != null && this.previousReadOnlyValue != (localReadOnlyValue = this.editableBox.getSelection())) {
            resource.setReadOnly(localReadOnlyValue);
        }
        if (this.derivedBox != null) {
            try {
                boolean localDerivedValue = this.derivedBox.getSelection();
                if (this.previousDerivedValue != localDerivedValue) {
                    resource.setDerived(localDerivedValue);
                }
            }
            catch (CoreException exception) {
                ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("InternalError"), (String)exception.getLocalizedMessage(), (IStatus)exception.getStatus());
                return false;
            }
        }
        return true;
    }
}

