/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.snack;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.jpn.xucker.snack.AbstractParser;
import org.jpn.xucker.snack.ESPS;

public class ESPSParser
extends AbstractParser {
    private String columnSeparator = ",";

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public Object parse(Reader reader) throws IOException {
        Vector<ESPS> result = new Vector<ESPS>();
        try {
            String line;
            BufferedReader breader = new BufferedReader(reader);
            while ((line = breader.readLine()) != null) {
                String[] values = null;
                values = line.startsWith("(") && line.endsWith(")") ? line.substring(1, line.length() - 1).split(",") : line.split(this.columnSeparator);
                if (values == null || values.length != 4) continue;
                ESPS esps = new ESPS();
                if (Double.parseDouble(values[1]) == 1.0) {
                    esps.setVoicing(true);
                }
                esps.setPitch(Double.parseDouble(values[0]));
                esps.setMeasurements(Double.parseDouble(values[2]));
                esps.setCorrelation(Double.parseDouble(values[3]));
                result.add(esps);
            }
            breader.close();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return result;
    }
}

