/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.snack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.jpn.xucker.rcp.ui.ProgressMonitor;
import org.jpn.xucker.snack.AbstractParser;
import org.jpn.xucker.snack.Spectrogram;

public class SpectrogramParser
extends AbstractParser {
    private ProgressMonitor progressMonitor;
    private int perProgress = 100;
    private int samplerate;
    private int height;
    private int permillisecond;
    private boolean removeNoise = true;

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPermillisecond() {
        return this.permillisecond;
    }

    public void setPermillisecond(int permillisecond) {
        this.permillisecond = permillisecond;
    }

    public boolean isRemoveNoise() {
        return this.removeNoise;
    }

    public void setRemoveNoise(boolean removeNoise) {
        this.removeNoise = removeNoise;
    }

    public int getSamplerate() {
        return this.samplerate;
    }

    public void setSamplerate(int samplerate) {
        this.samplerate = samplerate;
    }

    public static int toValue256(double d) {
        if (d < 0.0) {
            d *= -1.0;
        }
        double r = Math.toRadians(d);
        double v = Math.sin(r) * 1.1;
        return Math.min(255, (int)(v * 256.0));
    }

    public SpectrogramParser(int samplerate, int height, int permillisecond) {
        this.samplerate = samplerate;
        this.height = height;
        this.permillisecond = permillisecond;
    }

    public Object parse(Reader read) throws IOException {
        String line;
        ArrayIntList blist = new ArrayIntList();
        Spectrogram spectrogram = new Spectrogram();
        spectrogram.setHeight(this.height);
        spectrogram.setSamplerate(this.samplerate);
        spectrogram.setPerSample(this.permillisecond);
        int index = 0;
        int tmpPer = this.perProgress * this.height;
        BufferedReader reader = new BufferedReader(read);
        int prev = 0;
        while ((line = reader.readLine()) != null) {
            int v = Integer.parseInt(line);
            blist.add(prev -= v);
            if (this.progressMonitor != null && index % tmpPer == 0) {
                if (this.progressMonitor.isCanceled()) {
                    reader.close();
                    return null;
                }
                this.progressMonitor.worked(this.perProgress);
            }
            ++index;
        }
        reader.close();
        int[] rawint = blist.toArray();
        spectrogram.setRawInt(rawint);
        int i = 0;
        while (i < rawint.length) {
            rawint[i] = SpectrogramParser.toValue256(rawint[i]);
            ++i;
        }
        if (this.removeNoise) {
            new NoiseRemover(this.height).removeNoize(spectrogram.getRawInt());
        }
        return spectrogram;
    }

    public byte toSignedByte(int v) {
        byte r = (byte)v;
        if (r > 127) {
            r = (byte)(r - 256);
        }
        return r;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public static class NoiseRemover {
        private int sampleHeight;

        public NoiseRemover(int sampleheight) {
            this.sampleHeight = sampleheight;
        }

        private void removeNoize(int[] values2) {
            int vsize = 10;
            int x = values2.length / this.sampleHeight;
            int i = 0;
            while (i < x) {
                int[] last = new int[vsize - 1];
                int j = 0;
                while (j < this.sampleHeight) {
                    int v = values2[i * this.sampleHeight + j];
                    if (v != 0) {
                        if (this.isNear(v, last)) {
                            int k = 0;
                            while (k < last.length + 1) {
                                values2[i * this.sampleHeight + j - k] = 255;
                                ++k;
                            }
                            this.setInit(0, last);
                        } else {
                            this.setLast(v, last);
                        }
                    } else {
                        this.setLast(v, last);
                    }
                    ++j;
                }
                ++i;
            }
        }

        private boolean near(int a, int b) {
            int ch = 2;
            return Math.abs(a - b) <= ch;
        }

        private boolean isNear(int v, int[] array) {
            int i = array.length - 1;
            while (i > 0) {
                if (!this.near(array[i], array[i - 1])) {
                    return false;
                }
                --i;
            }
            return this.near(array[0], v);
        }

        private void setInit(int value, int[] array) {
            int i = 0;
            while (i < array.length) {
                array[i] = value;
                ++i;
            }
        }

        private void setLast(int v, int[] array) {
            int i = array.length - 1;
            while (i > 0) {
                array[i] = array[i - 1];
                --i;
            }
            array[0] = v;
        }
    }
}

