/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.Messages;

public class AudioToolsWorkbenchAdvisor
extends WorkbenchAdvisor {
    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(false);
    }

    public String getInitialWindowPerspectiveId() {
        return "org.jpn.xucker.rcp.audiotools.default";
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
        super.preWindowOpen(configurer);
        configurer.setInitialSize(new Point(640, 550));
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowFastViewBars(true);
        configurer.setShowMenuBar(true);
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
        AudioToolsPlugin.getDefault().init();
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
        super.fillActionBars(window, configurer, flags);
        if ((flags & 2) != 0) {
            this.fillMenuBar(window, configurer);
        }
    }

    private void fillMenuBar(IWorkbenchWindow window, IActionBarConfigurer configurer) {
        IMenuManager menuBar = configurer.getMenuManager();
        menuBar.add((IContributionItem)this.createFileMenu(window));
        menuBar.add((IContributionItem)this.createWindowMenu(window));
        menuBar.add((IContributionItem)this.createHelpMenu(window));
    }

    private MenuManager createHelpMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.getString("help"), "help");
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        ActionFactory.IWorkbenchAction action = ActionFactory.ABOUT.create(window);
        menu.add((IAction)action);
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        return menu;
    }

    private MenuManager createWindowMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.getString("window"), "window");
        ActionFactory.IWorkbenchAction action = ActionFactory.PREFERENCES.create(window);
        action.setText(Messages.getString("preferences"));
        menu.add((IAction)action);
        return menu;
    }

    private MenuManager createFileMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.getString("file"), "file");
        ActionFactory.IWorkbenchAction action = ActionFactory.QUIT.create(window);
        action.setText(Messages.getString("quit"));
        menu.add((IAction)action);
        return menu;
    }
}

