/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.DifferencesIterator;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.IRangeComparator;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.LinkedRangeDifference;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.LinkedRangeFactory;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.RangeDifference;

public final class RangeDifferencer {
    private static final RangeDifference[] EMPTY_RESULT = new RangeDifference[0];

    private RangeDifferencer() {
    }

    public static RangeDifference[] findDifferences(IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        return RangeDifferencer.findDifferences(null, left, right);
    }

    public static RangeDifference[] findDifferences(IProgressMonitor pm, IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        int upper;
        int diagLen;
        Assert.isTrue((boolean)right.getClass().equals(left.getClass()));
        int rightSize = right.getRangeCount();
        int leftSize = left.getRangeCount();
        int maxDiagonal = diagLen = 2 * Math.max(rightSize, leftSize);
        int[] lastDiagonal = new int[diagLen + 1];
        int origin = diagLen / 2;
        LinkedRangeDifference[] script = new LinkedRangeDifference[diagLen + 1];
        int row = 0;
        while (row < rightSize && row < leftSize && RangeDifferencer.rangesEqual(right, row, left, row)) {
            ++row;
        }
        lastDiagonal[origin] = row;
        script[origin] = null;
        int lower = row == rightSize ? origin + 1 : origin - 1;
        int n = upper = row == leftSize ? origin - 1 : origin + 1;
        if (lower > upper) {
            return EMPTY_RESULT;
        }
        LinkedRangeFactory factory = new LinkedRangeFactory();
        int d = 1;
        while (d <= maxDiagonal) {
            if (pm != null) {
                pm.worked(1);
            }
            if (right.skipRangeComparison(d, maxDiagonal, left)) {
                return EMPTY_RESULT;
            }
            int k = lower;
            while (k <= upper) {
                LinkedRangeDifference edit;
                if (pm != null && pm.isCanceled()) {
                    return EMPTY_RESULT;
                }
                if (k == origin - d || k != origin + d && lastDiagonal[k + 1] >= lastDiagonal[k - 1]) {
                    row = lastDiagonal[k + 1] + 1;
                    edit = factory.newRange(script[k + 1], 1);
                } else {
                    row = lastDiagonal[k - 1];
                    edit = factory.newRange(script[k - 1], 0);
                }
                int col = row + k - origin;
                edit.fRightStart = row;
                edit.fLeftStart = col;
                Assert.isTrue((k >= 0 && k <= maxDiagonal ? 1 : 0) != 0);
                script[k] = edit;
                while (row < rightSize && col < leftSize && RangeDifferencer.rangesEqual(right, row, left, col)) {
                    ++row;
                    ++col;
                }
                Assert.isTrue((k >= 0 && k <= maxDiagonal ? 1 : 0) != 0);
                lastDiagonal[k] = row;
                if (row == rightSize && col == leftSize) {
                    return RangeDifferencer.createDifferencesRanges(script[k]);
                }
                if (row == rightSize) {
                    lower = k + 2;
                }
                if (col == leftSize) {
                    upper = k - 2;
                }
                k += 2;
            }
            --lower;
            ++upper;
            ++d;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static RangeDifference[] findDifferences(IRangeComparator ancestor, IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        return RangeDifferencer.findDifferences(null, ancestor, left, right);
    }

    public static RangeDifference[] findDifferences(IProgressMonitor pm, IRangeComparator ancestor, IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        if (ancestor == null) {
            return RangeDifferencer.findDifferences(pm, left, right);
        }
        RangeDifference[] leftAncestorScript = null;
        RangeDifference[] rightAncestorScript = RangeDifferencer.findDifferences(pm, ancestor, right);
        if (rightAncestorScript != null) {
            leftAncestorScript = RangeDifferencer.findDifferences(pm, ancestor, left);
        }
        if (rightAncestorScript == null || leftAncestorScript == null) {
            return null;
        }
        DifferencesIterator myIter = new DifferencesIterator(rightAncestorScript);
        DifferencesIterator yourIter = new DifferencesIterator(leftAncestorScript);
        ArrayList<RangeDifference> diff3 = new ArrayList<RangeDifference>();
        diff3.add(new RangeDifference(5));
        int changeRangeStart = 0;
        int changeRangeEnd = 0;
        while (myIter.fDifference != null || yourIter.fDifference != null) {
            myIter.removeAll();
            yourIter.removeAll();
            DifferencesIterator startThread = myIter.fDifference == null ? yourIter : (yourIter.fDifference == null ? myIter : (myIter.fDifference.fLeftStart <= yourIter.fDifference.fLeftStart ? myIter : yourIter));
            changeRangeStart = startThread.fDifference.fLeftStart;
            changeRangeEnd = startThread.fDifference.leftEnd();
            startThread.next();
            DifferencesIterator other = startThread.other(myIter, yourIter);
            while (other.fDifference != null && other.fDifference.fLeftStart <= changeRangeEnd) {
                int newMax = other.fDifference.leftEnd();
                other.next();
                if (newMax < changeRangeEnd) continue;
                changeRangeEnd = newMax;
                other = other.other(myIter, yourIter);
            }
            diff3.add(RangeDifferencer.createRangeDifference3(myIter, yourIter, diff3, right, left, changeRangeStart, changeRangeEnd));
        }
        diff3.remove(0);
        return diff3.toArray(EMPTY_RESULT);
    }

    public static List findRanges(IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        return RangeDifferencer.findRanges(null, left, right);
    }

    public static List findRanges(IProgressMonitor pm, IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        RangeDifference rd;
        RangeDifference[] in = RangeDifferencer.findDifferences(pm, left, right);
        ArrayList<RangeDifference> out = new ArrayList<RangeDifference>();
        int mstart = 0;
        int ystart = 0;
        int i = 0;
        while (i < in.length) {
            RangeDifference es = in[i];
            rd = new RangeDifference(0, mstart, es.rightStart() - mstart, ystart, es.leftStart() - ystart);
            if (rd.maxLength() != 0) {
                out.add(rd);
            }
            out.add(es);
            mstart = es.rightEnd();
            ystart = es.leftEnd();
            ++i;
        }
        rd = new RangeDifference(0, mstart, right.getRangeCount() - mstart, ystart, left.getRangeCount() - ystart);
        if (rd.maxLength() > 0) {
            out.add(rd);
        }
        return out;
    }

    public static List findRanges(IRangeComparator ancestor, IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        return RangeDifferencer.findRanges(null, ancestor, left, right);
    }

    public static List findRanges(IProgressMonitor pm, IRangeComparator ancestor, IRangeComparator left, IRangeComparator right) throws LinkedRangeFactory.LowMemoryException {
        RangeDifference rd;
        if (ancestor == null) {
            return RangeDifferencer.findRanges(pm, left, right);
        }
        RangeDifference[] in = RangeDifferencer.findDifferences(pm, ancestor, left, right);
        ArrayList<RangeDifference> out = new ArrayList<RangeDifference>();
        int mstart = 0;
        int ystart = 0;
        int astart = 0;
        int i = 0;
        while (i < in.length) {
            RangeDifference es = in[i];
            rd = new RangeDifference(0, mstart, es.rightStart() - mstart, ystart, es.leftStart() - ystart, astart, es.ancestorStart() - astart);
            if (rd.maxLength() > 0) {
                out.add(rd);
            }
            out.add(es);
            mstart = es.rightEnd();
            ystart = es.leftEnd();
            astart = es.ancestorEnd();
            ++i;
        }
        rd = new RangeDifference(0, mstart, right.getRangeCount() - mstart, ystart, left.getRangeCount() - ystart, astart, ancestor.getRangeCount() - astart);
        if (rd.maxLength() > 0) {
            out.add(rd);
        }
        return out;
    }

    private static RangeDifference[] createDifferencesRanges(LinkedRangeDifference start) {
        LinkedRangeDifference ep = RangeDifferencer.reverseDifferences(start);
        ArrayList<RangeDifference> result = new ArrayList<RangeDifference>();
        RangeDifference es = null;
        while (ep != null) {
            es = new RangeDifference(2);
            if (ep.isInsert()) {
                es.fRightStart = ep.fRightStart + 1;
                es.fLeftStart = ep.fLeftStart;
                LinkedRangeDifference b = ep;
                do {
                    ep = ep.getNext();
                    ++es.fLeftLength;
                } while (ep != null && ep.isInsert() && ep.fRightStart == b.fRightStart);
            } else {
                boolean change;
                es.fRightStart = ep.fRightStart;
                es.fLeftStart = ep.fLeftStart;
                LinkedRangeDifference a = ep;
                do {
                    a = ep;
                    ep = ep.getNext();
                    ++es.fRightLength;
                } while (ep != null && ep.isDelete() && ep.fRightStart == a.fRightStart + 1);
                boolean bl = change = ep != null && ep.isInsert() && ep.fRightStart == a.fRightStart;
                if (change) {
                    LinkedRangeDifference b = ep;
                    do {
                        ep = ep.getNext();
                        ++es.fLeftLength;
                    } while (ep != null && ep.isInsert() && ep.fRightStart == b.fRightStart);
                } else {
                    es.fLeftLength = 0;
                }
                ++es.fLeftStart;
            }
            --es.fRightStart;
            --es.fLeftStart;
            result.add(es);
        }
        return result.toArray(EMPTY_RESULT);
    }

    private static RangeDifference createRangeDifference3(DifferencesIterator myIter, DifferencesIterator yourIter, List diff3, IRangeComparator right, IRangeComparator left, int changeRangeStart, int changeRangeEnd) {
        int leftEnd;
        int leftStart;
        RangeDifference l;
        RangeDifference f;
        int rightEnd;
        int rightStart;
        int kind = 5;
        RangeDifference last = (RangeDifference)diff3.get(diff3.size() - 1);
        Assert.isTrue((myIter.getCount() != 0 || yourIter.getCount() != 0 ? 1 : 0) != 0);
        if (myIter.getCount() == 0) {
            rightStart = changeRangeStart - last.ancestorEnd() + last.rightEnd();
            rightEnd = changeRangeEnd - last.ancestorEnd() + last.rightEnd();
            kind = 3;
        } else {
            f = (RangeDifference)myIter.fRange.get(0);
            l = (RangeDifference)myIter.fRange.get(myIter.fRange.size() - 1);
            rightStart = changeRangeStart - f.fLeftStart + f.fRightStart;
            rightEnd = changeRangeEnd - l.leftEnd() + l.rightEnd();
        }
        if (yourIter.getCount() == 0) {
            leftStart = changeRangeStart - last.ancestorEnd() + last.leftEnd();
            leftEnd = changeRangeEnd - last.ancestorEnd() + last.leftEnd();
            kind = 2;
        } else {
            f = (RangeDifference)yourIter.fRange.get(0);
            l = (RangeDifference)yourIter.fRange.get(yourIter.fRange.size() - 1);
            leftStart = changeRangeStart - f.fLeftStart + f.fRightStart;
            leftEnd = changeRangeEnd - l.leftEnd() + l.rightEnd();
        }
        if (kind == 5) {
            kind = RangeDifferencer.rangeSpansEqual(right, rightStart, rightEnd - rightStart, left, leftStart, leftEnd - leftStart) ? 4 : 1;
        }
        return new RangeDifference(kind, rightStart, rightEnd - rightStart, leftStart, leftEnd - leftStart, changeRangeStart, changeRangeEnd - changeRangeStart);
    }

    private static boolean rangesEqual(IRangeComparator a, int ai, IRangeComparator b, int bi) {
        return a.rangesEqual(ai, b, bi);
    }

    private static boolean rangeSpansEqual(IRangeComparator right, int rightStart, int rightLen, IRangeComparator left, int leftStart, int leftLen) {
        if (rightLen == leftLen) {
            int i = 0;
            i = 0;
            while (i < rightLen) {
                if (!RangeDifferencer.rangesEqual(right, rightStart + i, left, leftStart + i)) break;
                ++i;
            }
            if (i == rightLen) {
                return true;
            }
        }
        return false;
    }

    private static LinkedRangeDifference reverseDifferences(LinkedRangeDifference start) {
        LinkedRangeDifference ahead = start;
        LinkedRangeDifference ep = null;
        while (ahead != null) {
            LinkedRangeDifference behind = ep;
            ep = ahead;
            ahead = ahead.getNext();
            ep.setNext(behind);
        }
        return ep;
    }
}

