/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.FileAudioPlayer;
import org.jpn.xucker.commons.audio.InputStreamAudioPlayer;
import org.jpn.xucker.commons.audio.WaveUtils;

public class JavaSoundAudioPlayer
implements FileAudioPlayer,
InputStreamAudioPlayer {
    public static Log log;
    protected AudioStopper stopper = new NullStopper();
    protected AudioListener audioListener;
    protected int buffer = 1024;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.audio.JavaSoundAudioPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public AudioStopper getStopper() {
        return this.stopper;
    }

    public void setStopper(AudioStopper stopper) {
        this.stopper = stopper;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public void play(File file) {
        try {
            log.trace((Object)("play-file:" + file.getAbsolutePath()));
            log.trace((Object)("file-lehgth:" + file.length()));
            this.play(new FileInputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SourceDataLine toSourceDataLine(AudioFormat format) throws LineUnavailableException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, format);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(format);
        return line;
    }

    public void play(InputStream stream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        try {
            AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
            AudioFormat format = inputStream.getFormat();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info info = new DataLine.Info(clazz, format);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
            int readBytes = 0;
            byte[] bytedata = new byte[1024];
            boolean isStart = false;
            long playstarttime = 0L;
            while (readBytes != -1) {
                if (this.stopper != null && this.stopper.isStopped()) break;
                readBytes = inputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                if (!isStart) {
                    if (this.audioListener != null) {
                        this.audioListener.startPlaying();
                    }
                    isStart = true;
                }
                line.write(bytedata, 0, readBytes);
            }
            line.drain();
            line.close();
            if (this.audioListener != null) {
                this.audioListener.stopPlaying();
            }
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long countByteAt(AudioFormat format, long millisecond) {
        if (millisecond == 0L) {
            return 0L;
        }
        long rateIndex = (int)(format.getFrameRate() / 1000.0f * (float)millisecond);
        return rateIndex * (long)format.getSampleSizeInBits() / 8L * (long)format.getChannels();
    }

    public void play(File file, long startmillisecond, long endmillisecond) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.play(new FileInputStream(file), startmillisecond, endmillisecond);
    }

    public void playLoop(File file, long startmillisecond, long endmillisecond) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.play(file, startmillisecond, endmillisecond, 0);
    }

    public void play(File file, long startmillisecond, long endmillisecond, int loop) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        log.trace((Object)(String.valueOf(file.getAbsolutePath()) + "," + startmillisecond + "," + endmillisecond + ",loop=" + loop));
        AudioInputStream audioInputStream = null;
        audioInputStream = AudioSystem.getAudioInputStream(file);
        AudioFormat format = audioInputStream.getFormat();
        audioInputStream.close();
        long startByte = JavaSoundAudioPlayer.countByteAt(format, startmillisecond);
        long endByte = JavaSoundAudioPlayer.countByteAt(format, endmillisecond);
        long playByte = endByte - startByte;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, format);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(format);
        line.start();
        int playcount = 0;
        while (this.stopper != null && !this.stopper.isStopped()) {
            audioInputStream = AudioSystem.getAudioInputStream(file);
            audioInputStream.skip(startByte);
            int readBytes = 0;
            int buffersize = 1024;
            byte[] bytedata = new byte[buffersize];
            long readedByte = 0L;
            boolean isStart = false;
            while (readBytes != -1) {
                if (this.stopper != null && this.stopper.isStopped()) {
                    line.stop();
                    if (this.audioListener != null) {
                        this.audioListener.stopPlaying();
                    }
                    line.close();
                    line = null;
                    audioInputStream.close();
                    audioInputStream = null;
                    info = null;
                    return;
                }
                readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
                log.trace((Object)("readbytes:" + readBytes));
                if (readBytes < 0) continue;
                if (!isStart) {
                    if (this.audioListener != null) {
                        this.audioListener.startPlaying();
                    }
                    isStart = true;
                }
                if (readedByte + (long)readBytes >= playByte) {
                    line.write(bytedata, 0, Math.min((int)(playByte - readedByte), readBytes));
                    break;
                }
                line.write(bytedata, 0, readBytes);
                readedByte += (long)readBytes;
            }
            audioInputStream.close();
            if (loop == 0 || ++playcount < loop) continue;
        }
        line.drain();
        if (this.audioListener != null) {
            this.audioListener.stopPlaying();
        }
        byte[] tmpbyte = new byte[256];
        line.write(tmpbyte, 0, tmpbyte.length);
        line.stop();
        line.close();
        line = null;
        audioInputStream = null;
        info = null;
    }

    public void play(InputStream stream, long startmillisecond, long endmillisecond) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        AudioInputStream audioInputStream = null;
        audioInputStream = AudioSystem.getAudioInputStream(stream);
        AudioFormat format = audioInputStream.getFormat();
        long startByte = JavaSoundAudioPlayer.countByteAt(format, startmillisecond);
        long endByte = JavaSoundAudioPlayer.countByteAt(format, endmillisecond);
        long playByte = endByte - startByte;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, format);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(format);
        line.start();
        audioInputStream.skip(startByte);
        int readBytes = 0;
        int buffersize = 1024;
        byte[] bytedata = new byte[buffersize];
        long readedByte = 0L;
        boolean isStart = false;
        while (readBytes != -1) {
            if (this.stopper != null && this.stopper.isStopped()) {
                line.stop();
                if (this.audioListener != null) {
                    this.audioListener.stopPlaying();
                }
                line.close();
                line = null;
                audioInputStream.close();
                audioInputStream = null;
                info = null;
                return;
            }
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes < 0) continue;
            if (!isStart) {
                if (this.audioListener != null) {
                    this.audioListener.startPlaying();
                }
                isStart = true;
            }
            if (readedByte + (long)readBytes >= playByte) {
                line.write(bytedata, 0, Math.min((int)(playByte - readedByte), readBytes));
                break;
            }
            line.write(bytedata, 0, readBytes);
            readedByte += (long)readBytes;
        }
        line.drain();
        if (this.audioListener != null) {
            this.audioListener.stopPlaying();
        }
        byte[] tmpbyte = new byte[256];
        line.write(tmpbyte, 0, tmpbyte.length);
        line.stop();
        line.close();
        line = null;
        audioInputStream.close();
        audioInputStream = null;
        info = null;
    }

    public void execClose(SourceDataLine line, AudioInputStream audioInputStream) throws IOException {
        line.stop();
        line.flush();
        line.drain();
        line.close();
        line = null;
        audioInputStream.close();
        audioInputStream = null;
    }

    public boolean isStopped() {
        return this.stopper != null && this.stopper.isStopped();
    }

    public void execStop() {
        if (this.audioListener != null) {
            this.audioListener.stopPlaying();
        }
    }

    public void execStart() {
        if (this.audioListener != null) {
            this.audioListener.startPlaying();
        }
    }

    public void execFinish() {
        if (this.audioListener != null) {
            this.audioListener.finishPlaying();
        }
    }

    public void playByte(AudioInputStream audioInputStream, long startSample, long endSample) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        log.trace((Object)("startSample=" + startSample + ",endSample=" + endSample));
        AudioFormat format = audioInputStream.getFormat();
        long playByte = (endSample - startSample) * (long)format.getChannels() * 2L;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, format);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(format);
        line.start();
        audioInputStream.skip(startSample * (long)format.getChannels() * (long)(format.getSampleSizeInBits() / 8));
        int readBytes = 0;
        int buffersize = 2048;
        int bbyte = 64;
        byte[] bytedata = new byte[buffersize];
        long readedByte = 0L;
        boolean isStart = false;
        long playStart = 0L;
        while (readBytes != -1) {
            if (this.isStopped()) {
                this.execClose(line, audioInputStream);
                this.execStop();
                return;
            }
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes <= 0) continue;
            if (!isStart) {
                this.execStart();
                playStart = System.currentTimeMillis();
                isStart = true;
            }
            if (this.isStopped()) {
                this.execClose(line, audioInputStream);
                this.execStop();
                return;
            }
            if (readedByte + (long)readBytes < playByte || endSample == 0L) {
                readedByte += (long)readBytes;
                int writed = line.write(bytedata, 0, readBytes);
                continue;
            }
            int writebyte = Math.min((int)(playByte - readedByte), readBytes);
            int p = writebyte / bbyte;
            if (writebyte % bbyte != 1) {
                ++p;
            }
            int shoudread = p * bbyte;
            log.trace((Object)("writing:" + shoudread));
            int writed = line.write(bytedata, 0, shoudread);
            log.trace((Object)("writed:" + writed));
            readedByte += (long)readBytes;
            break;
        }
        log.trace((Object)("readedByte:" + readedByte));
        long playsample = readedByte / (long)format.getChannels() / (long)(format.getSampleSizeInBits() / 8);
        log.trace((Object)("playsample:" + playsample));
        long playtime = WaveUtils.sampleToMillisecond(playsample, format.getFrameRate());
        log.trace((Object)("playtime:" + playtime));
        while (System.currentTimeMillis() < playStart + playtime) {
            if (this.isStopped()) {
                this.execClose(line, audioInputStream);
                this.execStop();
                return;
            }
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.execFinish();
        this.execClose(line, audioInputStream);
    }

    public AudioListener getAudioListener() {
        return this.audioListener;
    }

    public void setAudioListener(AudioListener audioListener) {
        this.audioListener = audioListener;
    }

    public class NullStopper
    implements AudioStopper {
        public boolean isStopped() {
            log.isTraceEnabled();
            return false;
        }

        public void setStopped(boolean bool) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("stopped:" + bool));
            }
        }
    }
}

