/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.mp3;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileFormat;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class MP3JavaSoundAudioPlayer
extends JavaSoundAudioPlayer {
    public static Log log;
    private MpegAudioFileReader mpegAudioFileReader = new MpegAudioFileReader();
    private AdvancedPlayer advancedPlayer;
    private StopMonitor stopMonitor = new StopMonitor();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.mp3.MP3JavaSoundAudioPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void play(InputStream stream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.play(stream, 0L, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play(File file, long startmillisecond, long endmillisecond) {
        this.stopMonitor.start();
        try {
            Class<?> clazz;
            boolean isLimit = true;
            if (endmillisecond == 0L) {
                isLimit = false;
            }
            AudioInputStream audioInputStream = null;
            AudioInputStream in = this.mpegAudioFileReader.getAudioInputStream((InputStream)new FileInputStream(file));
            AudioFormat baseFormat = in.getFormat();
            AudioFileFormat baseFileFormat = this.mpegAudioFileReader.getAudioFileFormat((InputStream)in);
            long skipbyte = 0L;
            double fps = 0.0;
            int bps = 0;
            double frequency = 0.0;
            if (baseFileFormat instanceof MpegAudioFileFormat) {
                Map props = ((TAudioFileFormat)baseFileFormat).properties();
                Object[] obj = props.keySet().toArray();
                int i = 0;
                while (true) {
                    if (i >= obj.length) {
                        bps = Integer.parseInt(props.get("mp3.bitrate.nominal.bps").toString());
                        fps = Double.parseDouble(props.get("mp3.framerate.fps").toString());
                        frequency = Double.parseDouble(props.get("mp3.frequency.hz").toString());
                        break;
                    }
                    log.trace((Object)(obj[i] + "=" + props.get(obj[i]).toString()));
                    ++i;
                }
            }
            long myskip = 0L;
            if (baseFileFormat instanceof TAudioFileFormat) {
                Map props = ((TAudioFileFormat)baseFileFormat).properties();
                Object[] obj = props.keySet().toArray();
                int i = 0;
                while (true) {
                    if (i >= obj.length) {
                        myskip = startmillisecond * (long)(bps / 8) / 1000L;
                        if (!log.isTraceEnabled()) break;
                        log.trace((Object)("myskip:" + myskip));
                        break;
                    }
                    ++i;
                }
            }
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            MpegFormatConversionProvider provider = new MpegFormatConversionProvider();
            audioInputStream = provider.getAudioInputStream(decodedFormat, in);
            AudioFormat format = audioInputStream.getFormat();
            long startByte = JavaSoundAudioPlayer.countByteAt(decodedFormat, startmillisecond);
            long endByte = JavaSoundAudioPlayer.countByteAt(decodedFormat, endmillisecond);
            long playByte = endByte - startByte;
            if (log.isTraceEnabled()) {
                log.debug((Object)("s=" + startByte + ",e=" + endByte + " p=" + playByte));
            }
            if ((clazz = class$1) == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("javax.sound.sampled.SourceDataLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$1 = clazz2;
            }
            DataLine.Info info = new DataLine.Info(clazz, format);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
            long skipped = audioInputStream.skip(myskip);
            if (log.isTraceEnabled()) {
                log.trace((Object)("skipped:" + skipped));
            }
            int readbytes = 0;
            byte[] bytedata = new byte[this.buffer];
            long readed = 0L;
            while (!(readbytes == -1 || this.stopper != null && this.stopper.isStopped())) {
                block20: {
                    readbytes = audioInputStream.read(bytedata, 0, bytedata.length);
                    if (readbytes <= 0) continue;
                    if (isLimit) {
                        if (readed + (long)readbytes < playByte) {
                            try {
                                line.write(bytedata, 0, readbytes);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block20;
                        } else {
                            log.trace((Object)"break;");
                            line.write(bytedata, 0, Math.min((int)(playByte - readed), readbytes));
                            break;
                        }
                    }
                    line.write(bytedata, 0, readbytes);
                }
                readed += (long)readbytes;
            }
            line.drain();
            line.close();
            audioInputStream.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class DummyPlayBackListener
    extends PlaybackListener {
        public void playbackStarted(PlaybackEvent evt) {
            log.debug((Object)"playback start");
        }

        public void playbackFinished(PlaybackEvent evt) {
            log.debug((Object)"playback stop");
        }
    }

    public class StopMonitor
    extends Thread {
        public void run() {
            log.debug((Object)"start stopmonitor");
            while (!MP3JavaSoundAudioPlayer.this.stopper.isStopped()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (MP3JavaSoundAudioPlayer.this.advancedPlayer != null) {
                log.debug((Object)"call stopped");
                try {
                    MP3JavaSoundAudioPlayer.this.advancedPlayer.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

