/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import java.awt.image.BufferedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.jpn.xucker.rcp.ui.ProgressMonitor;

public class BufferedImagePainter {
    private ProgressMonitor monitor;
    public static final int DEFAULT_PERCHECK = 50;
    private int percheck = 50;

    public int getMaxProgress(int y) {
        return y / this.percheck;
    }

    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public int getPercheck() {
        return this.percheck;
    }

    public void setPercheck(int percheck) {
        this.percheck = percheck;
    }

    public void drawAtBufferedImage(BufferedImage bimg, Image image, int x, int y) {
        ImageData data = image.getImageData();
        int at = 0;
        int j = 0;
        while (j < image.getBounds().height) {
            int i = 0;
            while (i < image.getBounds().width) {
                int r = 0xFF & data.data[at + 2];
                int g = 0xFF & data.data[at + 1];
                int b = 0xFF & data.data[at];
                bimg.setRGB(i + x, j + y, 0xFF000000 | r << 16 | g << 8 | b << 0);
                at += 4;
                ++i;
            }
            if (this.monitor != null && j % this.percheck == 0) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                this.monitor.worked(this.percheck);
            }
            ++j;
        }
    }
}

