/*
 * Created on 2005/04/29
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram.actions;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView;

import java.io.File;




/**
 * Our sample action implements workbench action delegate.
 * The action proxy will be created by the workbench and
 * shown in the UI. When the user tries to use the action,
 * this delegate will be created and execution will be 
 * delegated to it.
 * @see IWorkbenchWindowActionDelegate
 */
public class ViewStatusAction implements IViewActionDelegate,IWorkbenchWindowActionDelegate {
	private IWorkbenchWindow window;
	public static final String FORMANT=ViewStatusAction.class.getName()+".formant";
	public static final String SPECTROGRAM=ViewStatusAction.class.getName()+".spectrogram";
	public static final String FIT=ViewStatusAction.class.getName()+".fit";
	/**
	 * The constructor.
	 */
	public ViewStatusAction() {
	}

	/**
	 * The action has been activated. The argument of the
	 * method represents the 'real' action sitting
	 * in the workbench UI.
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
	   
	    AudioGraphView view=(AudioGraphView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(AudioGraphView.ID_VIEW);
		if(action.getId().equals(FORMANT)){
	      view.setFormant(action.isChecked());
	  }else if(action.getId().equals(SPECTROGRAM)){
	      
	  }else if(action.getId().equals(FIT)){
	      
	      view.setFit(action.isChecked());
	  }
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	    
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

    /* (non-Javadoc)
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
        // TODO Auto-generated method stub
        
    }
}