/*
 * Created on 2004/12/08
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.snack;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;


public class FormantParser extends AbstractParser{
    public static Log log = LogFactory.getLog(FormantParser.class);
    private String columnSeparator=",";
    
    public String getColumnSeparator() {
        return columnSeparator;
    }
    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public static void normalize(SmallFormant[] formants,int size){
        
        SmallFormant[] replace=new SmallFormant[formants.length];
        
        //System.out.println(formants[0]);
        for(int j=0;j<formants.length;j++){
        short f1=0;
        short f2=0;
        short f3=0;
        short f4=0;

        int index=0;
        for(int i=-size;i<=size;i++){
            if(j+i>=0 && j+i<formants.length){
                f1+=formants[j+i].getF1();
                f2+=formants[j+i].getF2();
                f3+=formants[j+i].getF3();
                f4+=formants[j+i].getF4();
               
                index++;
            }
        }
        replace[j]=new SmallFormant();
        //System.out.println(j+"="+index);
        replace[j].setF1((f1/index));
        replace[j].setF2((f2/index));
        replace[j].setF3((f3/index));
        replace[j].setF4((f4/index));
        
        }
        log.trace("normalized:"+formants.length);
        System.arraycopy(replace,0,formants,0,formants.length);
        //System.out.println(formants[0]);
    }
    
    public static void normalize(Formant[] formants,int size){
        Formant[] replace=new Formant[formants.length];
        
        //System.out.println(formants[0]);
        for(int j=0;j<formants.length;j++){
        double f1=0;
        double f2=0;
        double f3=0;
        double f4=0;
        double b1=0;
        double b2=0;
        double b3=0;
        double b4=0;
        int index=0;
        for(int i=-size;i<=size;i++){
            if(j+i>=0 && j+i<formants.length){
                f1+=formants[j+i].getF1();
                f2+=formants[j+i].getF2();
                f3+=formants[j+i].getF3();
                f4+=formants[j+i].getF4();
                b1+=formants[j+i].getB1();
                b2+=formants[j+i].getB2();
                b3+=formants[j+i].getB3();
                b4+=formants[j+i].getB4();
                index++;
            }
        }
        replace[j]=new Formant();
        //System.out.println(j+"="+index);
        replace[j].setF1(f1/index);
        replace[j].setF2(f2/index);
        replace[j].setF3(f3/index);
        replace[j].setF4(f4/index);
        replace[j].setB1(b1/index);
        replace[j].setB2(b2/index);
        replace[j].setB3(b3/index);
        replace[j].setB4(b4/index);
        }
        System.arraycopy(replace,0,formants,0,formants.length);
        replace=null;//for gc?
        //System.out.println(formants[0]);
    }
    //Warrning return List object.//TODO fix that.
    public Object parse(Reader reader) throws IOException{
       
        List result=new ArrayList();
       
            BufferedReader breader=new BufferedReader(reader);
            String line;
            while((line=breader.readLine())!=null){
              //  System.out.println(line);
                String values[]=null;
                if(line.startsWith("(") && line.endsWith(")")){
                    //System.out.println("end");
                    values=line.substring(1,line.length()-1).split(",");
                }else{
                    values=line.split(columnSeparator);//DUMMY
                }
                
                    if(values!=null && values.length==8){
                        Formant formant=new Formant();
                        formant.setF1(Double.parseDouble(values[0]));
                        formant.setF2(Double.parseDouble(values[1]));
                        formant.setF3(Double.parseDouble(values[2]));
                        formant.setF4(Double.parseDouble(values[3]));
                        formant.setB1(Double.parseDouble(values[4]));
                        formant.setB2(Double.parseDouble(values[5]));
                        formant.setB3(Double.parseDouble(values[6]));
                        formant.setB4(Double.parseDouble(values[7]));
                        result.add(formant);
                        
                    }
                
            }
            breader.close();
        
            
        return (Formant[])result.toArray(new Formant[result.size()]);
    }

}