package org.jpn.xucker.rcp.audiotools.ffmpeg;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class FFMpegPage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	public static final String MP3_DEFAULT_BITRATE = "mp3DefaultBitrate";
	public static final String AC3_DEFAULT_BITRATE = "ac3DefaultBitrate";
	public static final String MP2_DEFAULT_BITRATE = "mp2DefaultBitrate";
	
	public static final String FFMPEG_PATH="ffmpeg_path";

	public FFMpegPage() {
		super(GRID);
		setPreferenceStore(AudioToolsPlugin.getDefault().getPreferenceStore());
		setDescription("FFmpeg multimedia System.");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(MP3_DEFAULT_BITRATE,160);
		store.setDefault(MP2_DEFAULT_BITRATE,160);
		store.setDefault(AC3_DEFAULT_BITRATE,160);
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */

	

    protected void createFieldEditors() {
    
        FileFieldEditor fileField=new FileFieldEditor(
                FFMPEG_PATH, "ffmpeg path",getFieldEditorParent());
        fileField.setFileExtensions(new String[]{"ffmpeg.exe"});
        addField(fileField);
        
        IntegerFieldEditor mp3DefaultBitrateEditor=new IntegerFieldEditor(MP3_DEFAULT_BITRATE,"mp3 default bitrate",getFieldEditorParent());
        addField(mp3DefaultBitrateEditor);
        
        
        addField(new IntegerFieldEditor(MP2_DEFAULT_BITRATE,"mp2 default bitrate",getFieldEditorParent()));
        
        addField(new IntegerFieldEditor(AC3_DEFAULT_BITRATE,"ac3 default bitrate",getFieldEditorParent()));
    }
	
	public void init(IWorkbench workbench) {
	}
}