/*
 * Created on 2005/05/13
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram;

import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Image;

import org.jpn.xucker.rcp.draw2d.CachedImageLoader;
import org.jpn.xucker.rcp.draw2d.ScalableImageFigure;

/**
 * 
 *
 */
public class SpectrogramFigure extends ScalableImageFigure{

   
    
    private SpectrogramDrawInfo spectrogramDrawInfo;
  
    /**
     * @param arg0
     * @param arg1
     * @param arg2
     * @param arg3
     */
    public SpectrogramFigure(SpectrogramDrawInfo info,CachedImageLoader arg0, String arg1, int arg2, int arg3) {
        super(arg0, arg1, arg2, arg3);
        this.spectrogramDrawInfo=info;
        
    }
    
    public void paintFigure(Graphics g) {
        
        Image spectrogramImage=getImage();
        if(spectrogramImage!=null && !spectrogramImage.isDisposed()){
            //change resize.
            int w=spectrogramImage.getBounds().width;
            int h=spectrogramImage.getBounds().height;
            if(w!=defaultWidth || h!=defaultHeight){
                //resize action.
                defaultWidth=w;
                defaultHeight=h;
                resize();
                getParent().revalidate();//resized.
            }
            //clientarea is width & height.
            if(spectrogramDrawInfo.isFit()){
                g.drawImage(spectrogramImage,0,0,spectrogramImage.getBounds().width,spectrogramImage.getBounds().height,getClientArea().x,getClientArea().y,this.getSize().width,this.getSize().height);
                    
            }else{
                int drawHeight=(int)(spectrogramDrawInfo.getSampleRate()*spectrogramDrawInfo.getBaseHeight()*hzoom/SpectrogramListFigure.MAX_SAMPLERATE);
               // System.out.println(drawHeight);
                g.drawImage(spectrogramImage,0,0,spectrogramImage.getBounds().width,spectrogramImage.getBounds().height,getClientArea().x,getClientArea().y+getClientArea().height-drawHeight,this.getSize().width,drawHeight);
            }
            
           // g.drawImage(img,0,0,w,h,getClientArea().x,getClientArea().y,this.getClientArea().width,this.getClientArea().height);
        	}
        }

}
