/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngFileReadState;

class PngIhdrChunk
extends PngChunk {
    static final int EXPECTED_DATA_LENGTH = 13;
    static final int WIDTH_DATA_OFFSET = 8;
    static final int HEIGHT_DATA_OFFSET = 12;
    static final int BIT_DEPTH_OFFSET = 16;
    static final int COLOR_TYPE_OFFSET = 17;
    static final int COMPRESSION_METHOD_OFFSET = 18;
    static final int FILTER_METHOD_OFFSET = 19;
    static final int INTERLACE_METHOD_OFFSET = 20;
    static final int COLOR_TYPE_GRAYSCALE = 0;
    static final int COLOR_TYPE_RGB = 2;
    static final int COLOR_TYPE_PALETTE = 3;
    static final int COLOR_TYPE_GRAYSCALE_WITH_ALPHA = 4;
    static final int COLOR_TYPE_RGB_WITH_ALPHA = 6;
    static final int INTERLACE_METHOD_NONE = 0;
    static final int INTERLACE_METHOD_ADAM7 = 1;
    static final int FILTER_NONE = 0;
    static final int FILTER_SUB = 1;
    static final int FILTER_UP = 2;
    static final int FILTER_AVERAGE = 3;
    static final int FILTER_PAETH = 4;
    static final byte[] ValidBitDepths = new byte[]{1, 2, 4, 8, 16};
    static final byte[] ValidColorTypes;

    static {
        byte[] byArray = new byte[5];
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 6;
        ValidColorTypes = byArray;
    }

    PngIhdrChunk(byte[] reference) {
        super(reference);
    }

    int getWidth() {
        return this.getInt32(8);
    }

    void setWidth(int value) {
        this.setInt32(8, value);
    }

    int getHeight() {
        return this.getInt32(12);
    }

    void setHeight(int value) {
        this.setInt32(12, value);
    }

    byte getBitDepth() {
        return this.reference[16];
    }

    void setBitDepth(byte value) {
        this.reference[16] = value;
    }

    byte getColorType() {
        return this.reference[17];
    }

    void setColorType(byte value) {
        this.reference[17] = value;
    }

    byte getCompressionMethod() {
        return this.reference[18];
    }

    void setCompressionMethod(byte value) {
        this.reference[18] = value;
    }

    byte getFilterMethod() {
        return this.reference[19];
    }

    void setFilterMethod(byte value) {
        this.reference[19] = value;
    }

    byte getInterlaceMethod() {
        return this.reference[20];
    }

    void setInterlaceMethod(byte value) {
        this.reference[20] = value;
    }

    void validate(PngFileReadState readState, PngIhdrChunk headerChunk) {
        if (readState.readIHDR || readState.readPLTE || readState.readIDAT || readState.readIEND) {
            SWT.error(40);
        } else {
            readState.readIHDR = true;
        }
        super.validate(readState, headerChunk);
        if (this.getLength() != 13) {
            SWT.error(40);
        }
        if (this.getCompressionMethod() != 0) {
            SWT.error(40);
        }
        if (this.getInterlaceMethod() != 0 && this.getInterlaceMethod() != 1) {
            SWT.error(40);
        }
        boolean colorTypeIsValid = false;
        byte colorType = this.getColorType();
        int i = 0;
        while (i < ValidColorTypes.length) {
            if (ValidColorTypes[i] == colorType) {
                colorTypeIsValid = true;
                break;
            }
            ++i;
        }
        if (!colorTypeIsValid) {
            SWT.error(40);
        }
        boolean bitDepthIsValid = false;
        byte bitDepth = this.getBitDepth();
        int i2 = 0;
        while (i2 < ValidBitDepths.length) {
            if (ValidBitDepths[i2] == bitDepth) {
                bitDepthIsValid = true;
                break;
            }
            ++i2;
        }
        if (!bitDepthIsValid) {
            SWT.error(40);
        }
        if ((colorType == 2 || colorType == 6 || colorType == 4) && bitDepth < 8) {
            SWT.error(40);
        }
        if (colorType == 3 && bitDepth > 8) {
            SWT.error(40);
        }
    }

    String getColorTypeString() {
        switch (this.getColorType()) {
            case 0: {
                return "Grayscale";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "Palette";
            }
            case 4: {
                return "Grayscale with Alpha";
            }
            case 6: {
                return "RGB with Alpha";
            }
        }
        return "Unknown - " + this.getColorType();
    }

    String getFilterMethodString() {
        switch (this.getFilterMethod()) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Sub";
            }
            case 2: {
                return "Up";
            }
            case 3: {
                return "Average";
            }
            case 4: {
                return "Paeth";
            }
        }
        return "Unknown";
    }

    String getInterlaceMethodString() {
        switch (this.getInterlaceMethod()) {
            case 0: {
                return "Not Interlaced";
            }
            case 1: {
                return "Interlaced - ADAM7";
            }
        }
        return "Unknown";
    }

    void contributeToString(StringBuffer buffer) {
        buffer.append("\n\tWidth: ");
        buffer.append(this.getWidth());
        buffer.append("\n\tHeight: ");
        buffer.append(this.getHeight());
        buffer.append("\n\tBit Depth: ");
        buffer.append(this.getBitDepth());
        buffer.append("\n\tColor Type: ");
        buffer.append(this.getColorTypeString());
        buffer.append("\n\tCompression Method: ");
        buffer.append(this.getCompressionMethod());
        buffer.append("\n\tFilter Method: ");
        buffer.append(this.getFilterMethodString());
        buffer.append("\n\tInterlace Method: ");
        buffer.append(this.getInterlaceMethodString());
    }

    boolean getMustHavePalette() {
        return this.getColorType() == 3;
    }

    boolean getCanHavePalette() {
        byte colorType = this.getColorType();
        return colorType != 0 && colorType != 4;
    }

    int getBitsPerPixel() {
        byte bitDepth = this.getBitDepth();
        switch (this.getColorType()) {
            case 6: {
                return 4 * bitDepth;
            }
            case 2: {
                return 3 * bitDepth;
            }
            case 4: {
                return 2 * bitDepth;
            }
            case 0: 
            case 3: {
                return bitDepth;
            }
        }
        SWT.error(40);
        return 0;
    }

    int getSwtBitsPerPixel() {
        byte bitDepth = this.getBitDepth();
        switch (this.getColorType()) {
            case 2: 
            case 4: 
            case 6: {
                return 24;
            }
            case 0: 
            case 3: {
                return Math.min(bitDepth, 8);
            }
        }
        SWT.error(40);
        return 0;
    }

    int getFilterByteOffset() {
        if (this.getBitDepth() < 8) {
            return 1;
        }
        return this.getBitsPerPixel() / 8;
    }

    boolean usesDirectColor() {
        switch (this.getColorType()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    PaletteData createGrayscalePalette() {
        int bitDepth = Math.min(this.getBitDepth(), 8);
        int max = Compatibility.pow2(bitDepth) - 1;
        int delta = 255 / max;
        int gray = 0;
        RGB[] rgbs = new RGB[max + 1];
        int i = 0;
        while (i <= max) {
            rgbs[i] = new RGB(gray, gray, gray);
            gray += delta;
            ++i;
        }
        return new PaletteData(rgbs);
    }

    PaletteData getPaletteData() {
        switch (this.getColorType()) {
            case 0: {
                return this.createGrayscalePalette();
            }
            case 2: 
            case 4: 
            case 6: {
                return new PaletteData(0xFF0000, 65280, 255);
            }
        }
        return null;
    }
}

