/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class DocumentTemplateContext
extends TemplateContext {
    private final IDocument fDocument;
    private int fCompletionOffset;
    private int fCompletionLength;

    public DocumentTemplateContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength) {
        super(type);
        Assert.isNotNull(document);
        Assert.isTrue(completionOffset >= 0 && completionOffset <= document.getLength());
        Assert.isTrue(completionLength >= 0);
        this.fDocument = document;
        this.fCompletionOffset = completionOffset;
        this.fCompletionLength = completionLength;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public int getCompletionOffset() {
        return this.fCompletionOffset;
    }

    protected void setCompletionOffset(int newOffset) {
        this.fCompletionOffset = newOffset;
    }

    public int getCompletionLength() {
        return this.fCompletionLength;
    }

    protected void setCompletionLength(int newLength) {
        this.fCompletionLength = newLength;
    }

    public String getKey() {
        int offset = this.getStart();
        int length = this.getEnd() - offset;
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getStart() {
        return this.fCompletionOffset;
    }

    public int getEnd() {
        return this.fCompletionOffset + this.fCompletionLength;
    }

    public boolean canEvaluate(Template template) {
        return true;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, this);
        return buffer;
    }
}

