/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;
import org.jpn.xucker.commons.util.ArrayMoveUtils;
import org.jpn.xucker.rcp.ui.AbstractFileListTable;

public class PathListTable
extends AbstractFileListTable {
    private boolean acceptFolder;
    private boolean acceptSame;
    private MenuItem moveTop;
    private MenuItem moveBottom;
    private MenuItem moveUp;
    private MenuItem moveDown;

    public PathListTable(Composite parent, int layout) {
        super(parent, layout);
        new MenuItem(this.popupMenu, 2);
        this.moveTop = new MenuItem(this.popupMenu, 8);
        this.moveTop.addSelectionListener((SelectionListener)this);
        this.moveTop.setText("move top");
        this.moveUp = new MenuItem(this.popupMenu, 8);
        this.moveUp.addSelectionListener((SelectionListener)this);
        this.moveUp.setText("move up");
        this.moveDown = new MenuItem(this.popupMenu, 8);
        this.moveDown.addSelectionListener((SelectionListener)this);
        this.moveDown.setText("move down");
        this.moveBottom = new MenuItem(this.popupMenu, 8);
        this.moveBottom.addSelectionListener((SelectionListener)this);
        this.moveBottom.setText("move bottom");
    }

    public void createHeader() {
    }

    public void addFileItem(String path) {
        TableItem item = new TableItem(this.table, 0);
        item.setImage(this.fileIcon);
        item.setText(path);
    }

    public void addDirectoryItem(String path) {
        TableItem item = new TableItem(this.table, 0);
        item.setImage(this.folderIcon);
        item.setText(path);
    }

    public void execOther(SelectionEvent event) {
        if (event.getSource().equals(this.moveTop)) {
            this.doMoveTop();
        } else if (event.getSource().equals(this.moveBottom)) {
            this.doMoveBottom();
        } else if (event.getSource().equals(this.moveUp)) {
            this.doMoveUp();
        } else if (event.getSource().equals(this.moveDown)) {
            this.doMoveDown();
        }
    }

    private void doMoveBottom() {
        int selection = this.table.getSelectionIndex();
        if (selection != -1) {
            String path = this.table.getItem(selection).getText();
            List list = this.toTextList();
            ArrayMoveUtils.moveBottom(list, path);
            this.setLabels(list);
        }
    }

    protected void setLabels(List list) {
        this.table.removeAll();
        String[] labels = list.toArray(new String[list.size()]);
        int i = 0;
        while (i < labels.length) {
            this.addFileItem(labels[i]);
            ++i;
        }
    }

    protected List toTextList() {
        TableItem[] items = this.table.getItems();
        ArrayList<String> labelList = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            labelList.add(items[i].getText());
            ++i;
        }
        return labelList;
    }

    private void doMoveTop() {
        int selection = this.table.getSelectionIndex();
        if (selection != -1) {
            String path = this.table.getItem(selection).getText();
            List list = this.toTextList();
            ArrayMoveUtils.moveTop(list, path);
            this.setLabels(list);
        }
    }

    private void doMoveUp() {
        int selection = this.table.getSelectionIndex();
        if (selection != -1) {
            String path = this.table.getItem(selection).getText();
            List list = this.toTextList();
            ArrayMoveUtils.moveUp(list, path);
            this.setLabels(list);
        }
    }

    private void doMoveDown() {
        int selection = this.table.getSelectionIndex();
        if (selection != -1) {
            String path = this.table.getItem(selection).getText();
            List list = this.toTextList();
            ArrayMoveUtils.moveDown(list, path);
            this.setLabels(list);
        }
    }
}

