/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jpn.xucker.commons.util.AbstractBasicFileApplication;

public abstract class RCPFileApplication
extends AbstractBasicFileApplication {
    private String openText = "Open File";
    private String saveText = "Save File";
    private String[] openFilterNames;
    private String[] openFilterExtensions;
    private String[] saveFilterNames;
    private String[] saveFilterExtensions;
    private String openDirectory;
    private String saveDirectory;

    public String[] getOpenFilterExtensions() {
        return this.openFilterExtensions;
    }

    public void setOpenFilterExtensions(String[] openFilterExtensions) {
        this.openFilterExtensions = openFilterExtensions;
    }

    public String[] getOpenFilterNames() {
        return this.openFilterNames;
    }

    public void setOpenFilterNames(String[] openFilterNames) {
        this.openFilterNames = openFilterNames;
    }

    public String[] getSaveFilterExtensions() {
        return this.saveFilterExtensions;
    }

    public void setSaveFilterExtensions(String[] saveFilterExtensions) {
        this.saveFilterExtensions = saveFilterExtensions;
    }

    public String[] getSaveFilterNames() {
        return this.saveFilterNames;
    }

    public void setSaveFilterNames(String[] saveFilterNames) {
        this.saveFilterNames = saveFilterNames;
    }

    protected File execChooseOpenFile() {
        String path;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell);
        dialog.setText(this.openText);
        if (this.openFilterNames != null) {
            dialog.setFilterNames(this.openFilterNames);
        }
        if (this.openFilterExtensions != null) {
            dialog.setFilterExtensions(this.openFilterExtensions);
        }
        if (this.openDirectory != null) {
            dialog.setFilterPath(this.openDirectory);
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        return new File(path);
    }

    protected File execChooseSaveFile() {
        String path;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText(this.saveText);
        if (this.saveFilterNames != null) {
            dialog.setFilterNames(this.saveFilterNames);
        }
        if (this.saveFilterExtensions != null) {
            dialog.setFilterExtensions(this.saveFilterExtensions);
        }
        if (this.saveDirectory != null) {
            dialog.setFilterPath(this.saveDirectory);
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        return new File(path);
    }

    protected int executeAskSave(String title, String message) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageBox box = new MessageBox(shell, 448);
        box.setText(title);
        box.setMessage(message);
        int result = box.open();
        if (result == 64) {
            return 0;
        }
        if (result == 128) {
            return 1;
        }
        return 2;
    }

    protected void execExit() {
        PlatformUI.getWorkbench().close();
    }
}

