/*
 * Created on 2004/07/27 Author aki@www.xucker.jpn.org License Apache2.0 or
 * Common Public License
 */
package org.jpn.xucker.subplayer;



import org.apache.commons.lang.ObjectUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.jpn.xucker.commons.swt.ui.FileDirChoicer;
import org.jpn.xucker.rcp.subplayer.compatibility.SubPlayFileXmlObject;

import java.io.File;

public class SubPlayFileXmlDialog implements SelectionListener {
    /**
     * @param shell
     */
    private Group group1;

    private FileDirChoicer firstSub;
    private FileDirChoicer secondSub;
    private FileDirChoicer firstWav;

//    private Button firstSubBrowseButton;
    //private Button secondSubBrowseButton;
    //private Button firstWavBrowseButton;
    
    public String getFirstSubFilePath() {
        return firstSub.getAbsoluteFilePath();
    }
    public void setFirstSubFilePath(String firstSubFilePath) {
        firstSub.setFilePath(firstSubFilePath);
    }
    public String getFirstWavFilePath() {
        return firstWav.getAbsoluteFilePath();
    }
    public void setFirstWavFilePath(String firstWavFilePath) {
        firstWav.setFilePath(firstWavFilePath);
    }
    public String getSecondSubFilePath() {
        return secondSub.getAbsoluteFilePath();
    }
    public void setSecondSubFilePath(String secondSubFilePath) {
        secondSub.setFilePath(secondSubFilePath);
    }
    
    private Button okButton;

    private Button cancelButton;

    Shell shell;

    

  

    SubPlayFileUpdater updater;
    private Button freettsButton;
    public Shell getShell() {
        return shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    


    public SubPlayFileXmlDialog(SubPlayFileUpdater updater,Shell shell) {
       this.updater=updater;
      
       
        this.shell = shell;
        /*TODO ̃t@Cl*/
        shell.setText("");
        shell.setBounds(50, 50, 370, 240);
        RowLayout layout = new RowLayout();
        shell.setLayout(layout);
        group1 = new Group(shell, SWT.NULL);
        group1.setText("t@[Xgt@C@pX");
        RowData group1_data = new RowData();
        group1_data.width = 350;
        group1.setLayoutData(group1_data);
        RowLayout group1_layout = new RowLayout();
        group1.setLayout(group1_layout);

        /*
        firstSubPath = new Label(group1, SWT.NULL);
        firstSubPath.setText("");
        RowData filePath_data = new RowData();
        filePath_data.width = 300;
        firstSubPath.setLayoutData(filePath_data);

        //Q
        firstSubBrowseButton = new Button(group1, SWT.NULL);
        firstSubBrowseButton.setText("Q");
        firstSubBrowseButton.addSelectionListener(this);
        RowData browseButton_data = new RowData();
        firstSubBrowseButton.setLayoutData(browseButton_data);
        */
        firstSub=new FileDirChoicer(group1,SWT.NULL,FileDirChoicer.FILE,null,true);
        firstSub.setFilterExtensions(new String[]{"*.txt;*.srt","*.srt","*.*"});
        firstSub.setFilterNames(new String[]{"t@C (*.srt *.txt)","SRTt@C (*.srt)","ׂẴt@C (*.*)"});

        
        Group secondSubGroup=new Group(shell,SWT.NULL);
        secondSubGroup.setLayout(new RowLayout());
        secondSubGroup.setText("ZJht@C@pX");
        RowData secondSubGroup_data = new RowData();
        secondSubGroup_data.width=350;
        secondSubGroup.setLayoutData(secondSubGroup_data);
        
        secondSub=new FileDirChoicer(secondSubGroup,SWT.NULL,FileDirChoicer.FILE,null,true);
        
        secondSub.setFilterExtensions(new String[]{"*.txt;*.srt","*.srt","*.*"});
        secondSub.setFilterNames(new String[]{"t@C (*.srt *.txt)","SRTt@C (*.srt)","ׂẴt@C (*.*)"});
        
        
        
        Group wavegroup=new Group(shell,SWT.NULL);
        wavegroup.setLayout(new RowLayout());
        wavegroup.setText("(Wav/Mp3)t@C@pX");
        RowData wavegroup_data = new RowData();
        wavegroup_data.width=350;
        wavegroup.setLayoutData(wavegroup_data);
        
        
        firstWav=new FileDirChoicer(wavegroup,SWT.NULL,FileDirChoicer.FILE,null,true);
        firstWav.setFilterExtensions(new String[]{"*.wav;*.mp3","*.wav","*.mp3"});
        firstWav.setFilterNames(new String[]{"Ή`(Wav`/MP3`)","Wav` (*.wav)","MP3` (*.mp3)"});
        //OK
        okButton = new Button(shell, SWT.NULL);
        okButton.setText("OK");
        okButton.addSelectionListener(this);
        RowData okButton_data = new RowData();
        okButton.setLayoutData(okButton_data);
        
        

        //LZ
        cancelButton = new Button(shell, SWT.NULL);
        cancelButton.setText("LZ");
        cancelButton.addSelectionListener(this);
        RowData cancelButton_data = new RowData();
        cancelButton.setLayoutData(cancelButton_data);
        
        
        //copy setting.
        SubPlayFileXmlObject xmlObject=updater.getSubPlayFileXmlObject();
        
        String firstSubPath=(String)ObjectUtils.defaultIfNull(xmlObject.getFirstSubFilePath(),"");
        if(firstSubPath.equals("")){
            firstSub.setFile(null);
        }else{
            firstSub.setFile(new File(firstSubPath));    
        }
        
        String secondSubPath=(String)ObjectUtils.defaultIfNull(xmlObject.getSecondSubFilePath(),"");
        if(secondSubPath.equals("")){
            secondSub.setFile(null);
        }else{
            secondSub.setFile(new File(secondSubPath));    
        }
        
        String firstWavPath=(String)ObjectUtils.defaultIfNull(xmlObject.getFirstWavFilePath(),"");
        if(firstWavPath.equals("")){
            firstWav.setFile(null);
        }else{
            firstWav.setFile(new File(firstWavPath));    
        }
        

    }

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == null) {
            //
            System.out.println("target==null");
        }
        
        
        //OK
        else if (target == okButton) {
            do_okButton();
        }
        //LZ
        else if (target == cancelButton) {
            do_cancelButton();
        }

    }

    

    public void widgetDefaultSelected(SelectionEvent arg0) {
        // TODO Auto-generated method stub

    }

   

    //OK
    public void do_okButton() {
        shell.close();
        
        
        
        updater.update(this);
    }

    //LZ
    public void do_cancelButton() {
        shell.close();
    }

    
}

