/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Vector;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Compatibility;

class DefaultLineStyler
implements LineStyleListener,
LineBackgroundListener {
    StyledTextContent content;
    StyleRange[] styles = new StyleRange[0];
    int styleCount = 0;
    int lineExpandExp = 1;
    int lineCount = 0;
    Color[] lineBackgrounds;

    public DefaultLineStyler(StyledTextContent content) {
        this.content = content;
        this.lineCount = content.getLineCount();
        this.lineBackgrounds = new Color[this.lineCount];
    }

    void insertStyle(StyleRange style, int index) {
        this.insertStyles(new StyleRange[]{style}, index);
    }

    void insertStyles(StyleRange[] insertStyles, int index) {
        int insertCount = insertStyles.length;
        int size = this.styles.length;
        int spaceNeeded = this.styleCount + insertCount - size;
        if (spaceNeeded > 0) {
            StyleRange[] newStyles = new StyleRange[size + spaceNeeded];
            System.arraycopy(this.styles, 0, newStyles, 0, size);
            this.styles = newStyles;
        }
        System.arraycopy(this.styles, index, this.styles, index + insertCount, this.styleCount - index);
        System.arraycopy(insertStyles, 0, this.styles, index, insertCount);
        this.styleCount += insertCount;
    }

    boolean insertMergeStyle(StyleRange style, int index) {
        if (this.mergeStyleBefore(style, index)) {
            return false;
        }
        if (this.mergeStyleAfter(style, index)) {
            return false;
        }
        this.insertStyle(style, index);
        return true;
    }

    boolean mergeStyleBefore(StyleRange style, int index) {
        int previousEnd;
        StyleRange previous;
        if (index > 0 && style.similarTo(previous = this.styles[index - 1]) && style.start <= (previousEnd = previous.start + previous.length) && style.start >= previous.start) {
            int styleEnd = style.start + style.length;
            if (index == this.styleCount || styleEnd <= this.styles[index].start) {
                previous.length = style.start + style.length - previous.start;
                return true;
            }
        }
        return false;
    }

    boolean mergeStyleAfter(StyleRange style, int index) {
        int nextEnd;
        int styleEnd;
        StyleRange next;
        if (index < this.styleCount && style.similarTo(next = this.styles[index]) && (styleEnd = style.start + style.length) <= (nextEnd = next.start + next.length) && styleEnd >= next.start && (index == 0 || style.start >= this.styles[index - 1].start + this.styles[index - 1].length)) {
            next.length = next.start + next.length - style.start;
            next.start = style.start;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void clearStyle(StyleRange clearStyle) {
        Point pt = this.getOverlappingStyles(clearStyle.start, clearStyle.length);
        int clearStyleEnd = clearStyle.start + clearStyle.length - 1;
        if (pt == null || pt.y == 0) {
            return;
        }
        int count = 0;
        int deleteStyle = -1;
        int deleteCount = 0;
        int i = pt.x;
        while (count < pt.y) {
            block8: {
                StyleRange overlap = this.styles[i];
                int overlapEnd = overlap.start + overlap.length - 1;
                if (overlap.start < clearStyle.start) {
                    if (overlapEnd <= clearStyleEnd) {
                        overlap.length = clearStyle.start - overlap.start;
                        break block8;
                    } else {
                        StyleRange endStyle = (StyleRange)overlap.clone();
                        endStyle.start = clearStyleEnd + 1;
                        endStyle.length = overlapEnd - clearStyleEnd;
                        overlap.length = clearStyle.start - overlap.start;
                        this.insertStyle(endStyle, i + 1);
                        break;
                    }
                }
                if (overlapEnd <= clearStyleEnd) {
                    if (deleteStyle == -1) {
                        deleteStyle = i;
                    }
                    ++deleteCount;
                } else {
                    overlap.start = clearStyleEnd + 1;
                    overlap.length = overlapEnd - overlap.start + 1;
                    break;
                }
            }
            ++count;
            ++i;
        }
        this.deleteStyles(deleteStyle, deleteCount);
    }

    void expandLinesBy(int numLines) {
        int size = this.lineBackgrounds.length;
        if (size - this.lineCount >= numLines) {
            return;
        }
        Color[] newLines = new Color[size + Math.max(Compatibility.pow2(this.lineExpandExp), numLines)];
        System.arraycopy(this.lineBackgrounds, 0, newLines, 0, size);
        this.lineBackgrounds = newLines;
        ++this.lineExpandExp;
    }

    void deleteStyle(int index) {
        this.deleteStyles(index, 1);
    }

    void deleteStyles(int index, int count) {
        if (count == 0 || index < 0) {
            return;
        }
        System.arraycopy(this.styles, index + count, this.styles, index, this.styleCount - (index + count));
        int i = 0;
        while (i < count) {
            this.styles[this.styleCount - i - 1] = null;
            ++i;
        }
        this.styleCount -= count;
    }

    StyleRange[] getStyleRanges() {
        StyleRange[] newStyles = new StyleRange[this.styleCount];
        System.arraycopy(this.styles, 0, newStyles, 0, this.styleCount);
        return newStyles;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        int lineIndex = this.content.getLineAtOffset(event.lineOffset);
        event.lineBackground = this.lineBackgrounds[lineIndex];
    }

    public void lineGetStyle(LineStyleEvent event) {
        int lineStart = event.lineOffset;
        int lineEnd = lineStart + event.lineText.length();
        int high = this.searchForStyle(lineStart, lineEnd);
        StyleRange style = null;
        Vector<StyleRange> lineStyles = new Vector<StyleRange>();
        int index = high;
        while (index < this.styleCount) {
            style = this.styles[index];
            if (style.start > lineEnd) break;
            int styleEnd = style.start + style.length - 1;
            if (styleEnd >= lineStart) {
                lineStyles.addElement(style);
            }
            ++index;
        }
        event.styles = new StyleRange[lineStyles.size()];
        lineStyles.copyInto(event.styles);
    }

    int searchForStyle(int start, int end) {
        int high = this.styleCount;
        int low = -1;
        int index = high;
        while (high - low > 1) {
            index = (high + low) / 2;
            StyleRange style = this.styles[index];
            int styleEnd = style.start + style.length - 1;
            if (start <= style.start || end <= styleEnd || start > style.start && styleEnd >= start && styleEnd < end) {
                high = index;
                continue;
            }
            low = index;
        }
        return high;
    }

    void setLineBackground(int startLine, int count, Color background) {
        int i = startLine;
        while (i < startLine + count) {
            this.lineBackgrounds[i] = background;
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setStyleRange(StyleRange newStyle) {
        if (newStyle == null) {
            this.styles = new StyleRange[0];
            this.styleCount = 0;
            return;
        }
        if (newStyle.length == 0) {
            return;
        }
        if (newStyle.isUnstyled()) {
            this.clearStyle(newStyle);
            return;
        }
        Point pt = this.getOverlappingStyles(newStyle.start, newStyle.length);
        int newStyleEnd = newStyle.start + newStyle.length - 1;
        if (pt == null) {
            this.insertStyle(newStyle, 0);
            return;
        }
        if (pt.y == 0) {
            this.insertMergeStyle(newStyle, pt.x);
            return;
        }
        boolean added = false;
        int count = 0;
        int i = pt.x;
        while (count < pt.y) {
            block16: {
                StyleRange overlap = this.styles[i];
                int overlapEnd = overlap.start + overlap.length - 1;
                if (overlap.start < newStyle.start) {
                    if (overlapEnd <= newStyleEnd) {
                        if (newStyle.similarTo(overlap)) {
                            overlap.length = newStyle.start + newStyle.length - overlap.start;
                        } else {
                            overlap.length = newStyle.start - overlap.start;
                            if (this.mergeStyleAfter(newStyle, i + 1)) {
                                return;
                            }
                            this.insertStyle(newStyle, i + 1);
                            ++i;
                        }
                        added = true;
                        break block16;
                    } else {
                        if (newStyle.similarTo(overlap)) {
                            return;
                        }
                        StyleRange endStyle = (StyleRange)overlap.clone();
                        endStyle.start = newStyleEnd + 1;
                        endStyle.length = overlapEnd - newStyleEnd;
                        overlap.length = newStyle.start - overlap.start;
                        this.insertStyle(newStyle, i + 1);
                        this.insertStyle(endStyle, ++i + 1);
                        return;
                    }
                }
                if (overlapEnd > newStyleEnd) {
                    overlap.start = newStyleEnd + 1;
                    overlap.length = overlapEnd - overlap.start + 1;
                    if (added) return;
                    this.insertMergeStyle(newStyle, i);
                    return;
                }
                if (!added) {
                    this.styles[i] = newStyle;
                    added = true;
                } else {
                    this.deleteStyle(i);
                    --i;
                }
            }
            ++count;
            ++i;
        }
    }

    void replaceStyleRanges(int start, int length, StyleRange[] ranges) {
        this.clearStyle(new StyleRange(start, length, null, null));
        int high = this.styleCount;
        int low = -1;
        int index = high;
        while (high - low > 1) {
            index = (high + low) / 2;
            StyleRange style = this.styles[index];
            if (start <= style.start) {
                high = index;
                continue;
            }
            low = index;
        }
        this.insertStyles(ranges, high);
    }

    void setStyleRanges(StyleRange[] styles) {
        this.styles = new StyleRange[styles.length];
        System.arraycopy(styles, 0, this.styles, 0, styles.length);
        this.styleCount = styles.length;
    }

    public void textChanging(TextChangingEvent event) {
        int startLine = this.content.getLineAtOffset(event.start);
        int startLineOffset = this.content.getOffsetAtLine(startLine);
        this.textChanging(event.start, -event.replaceCharCount);
        this.textChanging(event.start, event.newCharCount);
        if (event.replaceCharCount == this.content.getCharCount()) {
            this.linesChanging(0, -this.lineCount);
            this.linesChanging(0, this.content.getLineCount() - event.replaceLineCount + event.newLineCount);
            return;
        }
        if (event.start != startLineOffset) {
            ++startLine;
        }
        this.linesChanging(startLine, -event.replaceLineCount);
        this.linesChanging(startLine, event.newLineCount);
    }

    void linesChanging(int start, int delta) {
        boolean inserting;
        if (delta == 0) {
            return;
        }
        boolean bl = inserting = delta > 0;
        if (inserting) {
            this.expandLinesBy(delta);
            int i = this.lineCount - 1;
            while (i >= start) {
                this.lineBackgrounds[i + delta] = this.lineBackgrounds[i];
                --i;
            }
            i = start;
            while (i < start + delta) {
                this.lineBackgrounds[i] = null;
                ++i;
            }
        } else {
            int i = start - delta;
            while (i < this.lineCount) {
                this.lineBackgrounds[i + delta] = this.lineBackgrounds[i];
                ++i;
            }
        }
        this.lineCount += delta;
    }

    /*
     * Enabled aggressive block sorting
     */
    void textChanging(int start, int delta) {
        StyleRange style;
        int high;
        if (delta == 0) {
            return;
        }
        int deleteStart = -1;
        int deleteCount = 0;
        boolean inserting = delta > 0;
        int end = inserting ? start + delta - 1 : start - delta - 1;
        int index = high = this.searchForStyle(start, end);
        while (index < this.styleCount) {
            block11: {
                style = this.styles[index];
                if (inserting) {
                    if (style.start >= start) break;
                    StyleRange beforeStyle = (StyleRange)style.clone();
                    beforeStyle.length = start - style.start;
                    style.start = start;
                    style.length -= beforeStyle.length;
                    if (beforeStyle.length != 0) {
                        this.insertStyle(beforeStyle, index);
                    }
                    ++index;
                    break;
                }
                int styleEnd = style.start + style.length - 1;
                if (style.start > end) break;
                if (style.start < start) {
                    if (styleEnd <= end) {
                        style.length = start - style.start;
                        break block11;
                    } else {
                        style.length += delta;
                        ++index;
                        break;
                    }
                }
                if (styleEnd <= end) {
                    if (deleteStart == -1) {
                        deleteStart = index;
                    }
                    ++deleteCount;
                } else {
                    style.start = start;
                    style.length = styleEnd - end;
                    ++index;
                    break;
                }
            }
            ++index;
        }
        this.deleteStyles(deleteStart, deleteCount);
        int i = index - deleteCount;
        while (i < this.styleCount) {
            style = this.styles[i];
            style.start += delta;
            ++i;
        }
    }

    Point getOverlappingStyles(int start, int length) {
        if (this.styleCount == 0) {
            return null;
        }
        int end = start + length - 1;
        int high = this.searchForStyle(start, end);
        int count = 0;
        int index = high;
        while (index < this.styleCount) {
            StyleRange style = this.styles[index];
            int styleEnd = style.start + style.length - 1;
            if (style.start > end) break;
            if (styleEnd >= start) {
                ++count;
            }
            ++index;
        }
        return new Point(high, count);
    }

    Color getLineBackground(int index) {
        return this.lineBackgrounds[index];
    }

    StyleRange getStyleRangeAtOffset(int offset) {
        if (this.styleCount == 0) {
            return null;
        }
        Point pt = this.getOverlappingStyles(offset, 1);
        if (pt == null || pt.y == 0) {
            return null;
        }
        StyleRange newStyle = (StyleRange)this.styles[pt.x].clone();
        newStyle.start = offset;
        newStyle.length = 1;
        return newStyle;
    }

    StyleRange[] getStyleRangesFor(int offset, int length) {
        if (this.styleCount == 0) {
            return null;
        }
        Point pt = this.getOverlappingStyles(offset, length);
        if (pt == null || pt.y == 0) {
            return null;
        }
        StyleRange[] ranges = new StyleRange[pt.y];
        int i = 0;
        while (i < pt.y) {
            StyleRange newStyle;
            ranges[i] = newStyle = this.styles[pt.x + i];
            ++i;
        }
        return ranges;
    }

    void release() {
        this.styles = null;
    }
}

