/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.framework.launcher.Launcher;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class FrameworkCommandProvider
implements CommandProvider {
    private OSGi osgi;
    private BundleContext context;
    private StartLevelManager slImpl;
    private String tab = "\t";
    private String newline = "\r\n";
    static /* synthetic */ Class class$0;

    public FrameworkCommandProvider(OSGi osgi) {
        this.osgi = osgi;
        this.context = osgi.getBundleContext();
        this.slImpl = osgi.framework.startLevelManager;
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ((Dictionary)props).put("service.ranking", new Integer(Integer.MAX_VALUE));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.context.registerService(clazz.getName(), (Object)this, props);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(1024);
        help.append(this.newline);
        help.append(ConsoleMsg.CONSOLE_HELP_VALID_COMMANDS_HEADER);
        help.append(this.newline);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_CONTROLLING_FRAMEWORK_HEADER, help);
        this.addCommand("launch", ConsoleMsg.CONSOLE_HELP_LAUNCH_COMMAND_DESCRIPTION, help);
        this.addCommand("shutdown", ConsoleMsg.CONSOLE_HELP_SHUTDOWN_COMMAND_DESCRIPTION, help);
        this.addCommand("close", ConsoleMsg.CONSOLE_HELP_CLOSE_COMMAND_DESCRIPTION, help);
        this.addCommand("exit", ConsoleMsg.CONSOLE_HELP_EXIT_COMMAND_DESCRIPTION, help);
        this.addCommand("gc", ConsoleMsg.CONSOLE_HELP_GC_COMMAND_DESCRIPTION, help);
        this.addCommand("init", ConsoleMsg.CONSOLE_HELP_INIT_COMMAND_DESCRIPTION, help);
        this.addCommand("setprop", ConsoleMsg.CONSOLE_HELP_KEYVALUE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SETPROP_COMMAND_DESCRIPTION, help);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_CONTROLLING_BUNDLES_HEADER, help);
        this.addCommand("install", ConsoleMsg.CONSOLE_HELP_INSTALL_COMMAND_DESCRIPTION, help);
        this.addCommand("uninstall", ConsoleMsg.CONSOLE_HELP_UNINSTALL_COMMAND_DESCRIPTION, help);
        this.addCommand("start", ConsoleMsg.CONSOLE_HELP_START_COMMAND_DESCRIPTION, help);
        this.addCommand("stop", ConsoleMsg.CONSOLE_HELP_STOP_COMMAND_DESCRIPTION, help);
        this.addCommand("refresh", ConsoleMsg.CONSOLE_HELP_REFRESH_COMMAND_DESCRIPTION, help);
        this.addCommand("update", ConsoleMsg.CONSOLE_HELP_UPDATE_COMMAND_DESCRIPTION, help);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_DISPLAYING_STATUS_HEADER, help);
        this.addCommand("status", ConsoleMsg.CONSOLE_HELP_STATUS_COMMAND_DESCRIPTION, help);
        this.addCommand("ss", ConsoleMsg.CONSOLE_HELP_SS_COMMAND_DESCRIPTION, help);
        this.addCommand("services", ConsoleMsg.CONSOLE_HELP_FILTER_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SERVICES_COMMAND_DESCRIPTION, help);
        this.addCommand("packages", ConsoleMsg.CONSOLE_HELP_PACKAGES_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_PACKAGES_COMMAND_DESCRIPTION, help);
        this.addCommand("bundles", ConsoleMsg.CONSOLE_HELP_BUNDLES_COMMAND_DESCRIPTION, help);
        this.addCommand("bundle", ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_BUNDLE_COMMAND_DESCRIPTION, help);
        this.addCommand("headers", ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_HEADERS_COMMAND_DESCRIPTION, help);
        this.addCommand("log", ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_LOG_COMMAND_DESCRIPTION, help);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_EXTRAS_HEADER, help);
        this.addCommand("exec", ConsoleMsg.CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_EXEC_COMMAND_DESCRIPTION, help);
        this.addCommand("fork", ConsoleMsg.CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_FORK_COMMAND_DESCRIPTION, help);
        this.addHeader(ConsoleMsg.STARTLEVEL_HELP_HEADING, help);
        this.addCommand("sl", ConsoleMsg.CONSOLE_HELP_OPTIONAL_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SL, help);
        this.addCommand("setfwsl", ConsoleMsg.STARTLEVEL_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETFWSL, help);
        this.addCommand("setbsl", ConsoleMsg.STARTLEVEL_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETBSL, help);
        this.addCommand("setibsl", ConsoleMsg.STARTLEVEL_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETIBSL, help);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_PROFILE_HEADING, help);
        this.addCommand("profilelog", ConsoleMsg.CONSOLE_HELP_PROFILELOG_DESCRIPTION, help);
        return help.toString();
    }

    private void addHeader(String header, StringBuffer help) {
        help.append("---");
        help.append(header);
        help.append("---");
        help.append(this.newline);
    }

    private void addCommand(String command, String description, StringBuffer help) {
        help.append(this.tab);
        help.append(command);
        help.append(" - ");
        help.append(description);
        help.append(this.newline);
    }

    private void addCommand(String command, String parameters, String description, StringBuffer help) {
        help.append(this.tab);
        help.append(command);
        help.append(" ");
        help.append(parameters);
        help.append(" - ");
        help.append(description);
        help.append(this.newline);
    }

    public void _exit(CommandInterpreter intp) throws Exception {
        intp.println();
        System.exit(0);
    }

    public void _launch(CommandInterpreter intp) throws Exception {
        this.osgi.launch();
    }

    public void _shutdown(CommandInterpreter intp) throws Exception {
        this.osgi.shutdown();
    }

    public void _sta(CommandInterpreter intp) throws Exception {
        this._start(intp);
    }

    public void _start(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                bundle.start();
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _sto(CommandInterpreter intp) throws Exception {
        this._stop(intp);
    }

    public void _stop(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                bundle.stop();
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _i(CommandInterpreter intp) throws Exception {
        this._install(intp);
    }

    public void _install(CommandInterpreter intp) throws Exception {
        String url = intp.nextArgument();
        if (url == null) {
            intp.println(ConsoleMsg.CONSOLE_NOTHING_TO_INSTALL_ERROR);
        } else {
            String start;
            AbstractBundle bundle = (AbstractBundle)this.context.installBundle(url);
            intp.print(ConsoleMsg.CONSOLE_BUNDLE_ID_MESSAGE);
            intp.println(new Long(bundle.getBundleId()));
            String nextArg = intp.nextArgument();
            if (nextArg != null && Launcher.matchCommand("start", start = nextArg.toLowerCase(), 1)) {
                bundle.start();
            }
        }
    }

    public void _up(CommandInterpreter intp) throws Exception {
        this._update(intp);
    }

    public void _update(CommandInterpreter intp) throws Exception {
        String token = intp.nextArgument();
        if (token == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (token != null) {
            if ("*".equals(token)) {
                AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
                int size = bundles.length;
                if (size > 0) {
                    int i = 0;
                    while (i < size) {
                        AbstractBundle bundle = bundles[i];
                        if (bundle.getBundleId() != 0L) {
                            try {
                                bundle.update();
                            }
                            catch (BundleException e) {
                                intp.printStackTrace(e);
                            }
                        }
                        ++i;
                    }
                } else {
                    intp.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
                }
            } else {
                AbstractBundle bundle = this.getBundleFromToken(intp, token, true);
                if (bundle != null) {
                    String source = intp.nextArgument();
                    try {
                        if (source != null) {
                            bundle.update(new URL(source).openStream());
                        }
                        bundle.update();
                    }
                    catch (BundleException e) {
                        intp.printStackTrace(e);
                    }
                }
            }
            token = intp.nextArgument();
        }
    }

    public void _un(CommandInterpreter intp) throws Exception {
        this._uninstall(intp);
    }

    public void _uninstall(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                bundle.uninstall();
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _s(CommandInterpreter intp) throws Exception {
        this._status(intp);
    }

    public void _status(CommandInterpreter intp) throws Exception {
        if (this.osgi.isActive()) {
            intp.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            intp.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        intp.println();
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            intp.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        intp.print(ConsoleMsg.CONSOLE_ID);
        intp.print(this.tab);
        intp.println(ConsoleMsg.CONSOLE_BUNDLE_LOCATION_MESSAGE);
        intp.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_FILE_NAME_HEADER);
        int i = 0;
        while (i < size) {
            AbstractBundle bundle = bundles[i];
            intp.print(new Long(bundle.getBundleId()));
            intp.print(this.tab);
            intp.println(bundle.getLocation());
            intp.print("  ");
            intp.print(this.getStateName(bundle.getState()));
            intp.println(bundle.bundledata);
            ++i;
        }
        ServiceReference[] services = this.context.getServiceReferences(null, null);
        if (services != null) {
            intp.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
            size = services.length;
            int i2 = 0;
            while (i2 < size) {
                intp.println(services[i2]);
                ++i2;
            }
        }
    }

    public void _se(CommandInterpreter intp) throws Exception {
        this._services(intp);
    }

    public void _services(CommandInterpreter intp) throws Exception {
        int size;
        ServiceReference[] services;
        String filter = null;
        String nextArg = intp.nextArgument();
        if (nextArg != null) {
            StringBuffer buf = new StringBuffer();
            while (nextArg != null) {
                buf.append(' ');
                buf.append(nextArg);
                nextArg = intp.nextArgument();
            }
            filter = buf.toString();
        }
        if ((services = this.context.getServiceReferences(null, filter)) != null && (size = services.length) > 0) {
            int j = 0;
            while (j < size) {
                ServiceReference service = services[j];
                intp.println(service);
                intp.print("  ");
                intp.print(ConsoleMsg.CONSOLE_REGISTERED_BY_BUNDLE_MESSAGE);
                intp.print(" ");
                intp.println(service.getBundle());
                AbstractBundle[] users = (AbstractBundle[])service.getUsingBundles();
                if (users != null) {
                    intp.print("  ");
                    intp.println(ConsoleMsg.CONSOLE_BUNDLES_USING_SERVICE_MESSAGE);
                    int k = 0;
                    while (k < users.length) {
                        intp.print("    ");
                        intp.println(users[k]);
                        ++k;
                    }
                } else {
                    intp.print("  ");
                    intp.println(ConsoleMsg.CONSOLE_NO_BUNDLES_USING_SERVICE_MESSAGE);
                }
                ++j;
            }
            return;
        }
        intp.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
    }

    public void _p(CommandInterpreter intp) throws Exception {
        this._packages(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _packages(CommandInterpreter intp) throws Exception {
        ServiceReference packageAdminRef;
        AbstractBundle bundle = null;
        String token = intp.nextArgument();
        if (token != null) {
            bundle = this.getBundleFromToken(intp, token, false);
        }
        if ((packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin")) == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
            return;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
        if (packageAdmin == null) return;
        try {
            ExportedPackage[] packages = null;
            if (token != null && bundle == null) {
                ExportedPackage pkg = packageAdmin.getExportedPackage(token);
                if (pkg != null) {
                    packages = new ExportedPackage[]{pkg};
                }
            } else {
                packages = packageAdmin.getExportedPackages(bundle);
            }
            if (packages == null) {
                intp.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
            } else {
                int i = 0;
                while (i < packages.length) {
                    Bundle exporter;
                    ExportedPackage pkg = packages[i];
                    intp.print(pkg);
                    boolean removalPending = pkg.isRemovalPending();
                    if (removalPending) {
                        intp.print("(");
                        intp.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                        intp.println(")");
                    }
                    if ((exporter = pkg.getExportingBundle()) != null) {
                        intp.print("<");
                        intp.print(exporter);
                        intp.println(">");
                        Bundle[] importers = pkg.getImportingBundles();
                        int j = 0;
                        while (j < importers.length) {
                            intp.print("  ");
                            intp.print(importers[j]);
                            intp.print(" ");
                            intp.println(ConsoleMsg.CONSOLE_IMPORTS_MESSAGE);
                            ++j;
                        }
                    } else {
                        intp.print("<");
                        intp.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                        intp.println(">");
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.context.ungetService(packageAdminRef);
            throw throwable;
        }
        {
            Object var13_16 = null;
            this.context.ungetService(packageAdminRef);
            return;
        }
    }

    public void _bundles(CommandInterpreter intp) throws Exception {
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            intp.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        int i = 0;
        while (i < size) {
            AbstractBundle bundle = bundles[i];
            long id = bundle.getBundleId();
            intp.println(bundle);
            intp.print("  ");
            intp.print(NLS.bind(ConsoleMsg.CONSOLE_ID_MESSAGE, String.valueOf(id)));
            intp.print(", ");
            intp.print(NLS.bind(ConsoleMsg.CONSOLE_STATUS_MESSAGE, this.getStateName(bundle.getState())));
            if (id != 0L) {
                File dataRoot = this.osgi.framework.getDataFile(bundle, "");
                String root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                intp.print(NLS.bind(ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, root));
            } else {
                intp.println();
            }
            ServiceReference[] services = bundle.getRegisteredServices();
            if (services != null) {
                intp.print("  ");
                intp.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                int j = 0;
                while (j < services.length) {
                    intp.print("    ");
                    intp.println(services[j]);
                    ++j;
                }
            } else {
                intp.print("  ");
                intp.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
            }
            services = bundle.getServicesInUse();
            if (services != null) {
                intp.print("  ");
                intp.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                int j = 0;
                while (j < services.length) {
                    intp.print("    ");
                    intp.println(services[j]);
                    ++j;
                }
            } else {
                intp.print("  ");
                intp.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
            }
            ++i;
        }
    }

    public void _b(CommandInterpreter intp) throws Exception {
        this._bundle(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _bundle(CommandInterpreter intp) throws Exception {
        nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (true) {
            block50: {
                block49: {
                    block51: {
                        if (nextArg == null) {
                            return;
                        }
                        bundle = this.getBundleFromToken(intp, nextArg, true);
                        if (bundle == null) break block50;
                        id = bundle.getBundleId();
                        intp.println(bundle);
                        intp.print("  ");
                        intp.print(NLS.bind(ConsoleMsg.CONSOLE_ID_MESSAGE, String.valueOf(id)));
                        intp.print(", ");
                        intp.print(NLS.bind(ConsoleMsg.CONSOLE_STATUS_MESSAGE, this.getStateName(bundle.getState())));
                        if (id != 0L) {
                            dataRoot = this.osgi.framework.getDataFile(bundle, "");
                            root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                            intp.print(NLS.bind(ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, root));
                        } else {
                            intp.println();
                        }
                        services = bundle.getRegisteredServices();
                        if (services != null) {
                            intp.print("  ");
                            intp.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                            j = 0;
                            while (j < services.length) {
                                intp.print("    ");
                                intp.println(services[j]);
                                ++j;
                            }
                        } else {
                            intp.print("  ");
                            intp.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
                        }
                        services = bundle.getServicesInUse();
                        if (services != null) {
                            intp.print("  ");
                            intp.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                            j = 0;
                            while (j < services.length) {
                                intp.print("    ");
                                intp.println(services[j]);
                                ++j;
                            }
                        } else {
                            intp.print("  ");
                            intp.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
                        }
                        packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
                        if (packageAdminRef == null) break block51;
                        packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
                        if (packageAdmin == null) break block49;
                        try {
                            block53: {
                                block47: {
                                    block48: {
                                        block52: {
                                            exportedpkgs = packageAdmin.getExportedPackages((Bundle)null);
                                            if (exportedpkgs != null) break block52;
                                            intp.print("  ");
                                            intp.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                                            intp.print("  ");
                                            intp.println(ConsoleMsg.CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE);
                                            ** GOTO lbl-1000
                                        }
                                        title = true;
                                        i = 0;
                                        while (true) {
                                            if (i >= exportedpkgs.length) {
                                                if (title) {
                                                    intp.print("  ");
                                                    intp.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                                                }
                                                break;
                                            }
                                            exportedpkg = exportedpkgs[i];
                                            if (exportedpkg.getExportingBundle() == bundle) {
                                                if (title) {
                                                    intp.print("  ");
                                                    intp.println(ConsoleMsg.CONSOLE_EXPORTED_PACKAGES_MESSAGE);
                                                    title = false;
                                                }
                                                intp.print("    ");
                                                intp.print(exportedpkg);
                                                if (exportedpkg.isRemovalPending()) {
                                                    intp.println(ConsoleMsg.CONSOLE_EXPORTED_REMOVAL_PENDING_MESSAGE);
                                                } else {
                                                    intp.println(ConsoleMsg.CONSOLE_EXPORTED_MESSAGE);
                                                }
                                            }
                                            ++i;
                                        }
                                        title = true;
                                        i = 0;
                                        while (true) {
                                            if (i >= exportedpkgs.length) {
                                                if (title) {
                                                    intp.print("  ");
                                                    intp.println(ConsoleMsg.CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE);
                                                }
                                                intp.print("  ");
                                                if ((packageAdmin.getBundleType(bundle) & 1) <= 0) break block47;
                                                hosts = packageAdmin.getHosts(bundle);
                                                if (hosts != null) {
                                                    intp.println(ConsoleMsg.CONSOLE_HOST_MESSAGE);
                                                    i = 0;
                                                    break;
                                                }
                                                break block48;
                                            }
                                            exportedpkg = exportedpkgs[i];
                                            importers = exportedpkg.getImportingBundles();
                                            j = 0;
                                            while (j < importers.length) {
                                                if (importers[j] == bundle) {
                                                    if (title) {
                                                        intp.print("  ");
                                                        intp.println(ConsoleMsg.CONSOLE_IMPORTED_PACKAGES_MESSAGE);
                                                        title = false;
                                                    }
                                                    intp.print("    ");
                                                    intp.print(exportedpkg);
                                                    exporter = exportedpkg.getExportingBundle();
                                                    if (exporter != null) {
                                                        intp.print("<");
                                                        intp.print(exporter);
                                                        intp.println(">");
                                                        break;
                                                    }
                                                    intp.print("<");
                                                    intp.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                                                    intp.println(">");
                                                    break;
                                                }
                                                ++j;
                                            }
                                            ++i;
                                        }
                                        while (i < hosts.length) {
                                            intp.print("    ");
                                            intp.println(hosts[i]);
                                            ++i;
                                        }
                                        break block53;
                                    }
                                    intp.println(ConsoleMsg.CONSOLE_NO_HOST_MESSAGE);
                                    break block53;
                                }
                                fragments = packageAdmin.getFragments(bundle);
                                if (fragments != null) {
                                    intp.println(ConsoleMsg.CONSOLE_FRAGMENT_MESSAGE);
                                    i = 0;
                                    while (i < fragments.length) {
                                        intp.print("    ");
                                        intp.println(fragments[i]);
                                        ++i;
                                    }
                                } else {
                                    intp.println(ConsoleMsg.CONSOLE_NO_FRAGMENT_MESSAGE);
                                }
                            }
                            requiredBundles = packageAdmin.getRequiredBundles(null);
                            requiredBundle = null;
                            if (requiredBundles != null) {
                                i = 0;
                                while (i < requiredBundles.length) {
                                    if (requiredBundles[i].getBundle() == bundle) {
                                        requiredBundle = requiredBundles[i];
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (requiredBundle == null) {
                                intp.print("  ");
                                intp.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
                            } else {
                                intp.print("  ");
                                intp.println(ConsoleMsg.CONSOLE_NAMED_CLASS_SPACE_MESSAGE);
                                intp.print("    ");
                                intp.print(requiredBundle);
                                if (requiredBundle.isRemovalPending()) {
                                    intp.println(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                                } else {
                                    intp.println(ConsoleMsg.CONSOLE_PROVIDED_MESSAGE);
                                }
                            }
                            title = true;
                            i = 0;
                            while (true) {
                                block54: {
                                    if (i < requiredBundles.length) break block54;
                                    if (title) {
                                        intp.print("  ");
                                        intp.println(ConsoleMsg.CONSOLE_NO_REQUIRED_BUNDLES_MESSAGE);
                                    }
                                    break;
                                }
                                if (requiredBundles[i] != requiredBundle && (depBundles = requiredBundles[i].getRequiringBundles()) != null) {
                                    j = 0;
                                    while (j < depBundles.length) {
                                        if (depBundles[j] == bundle) {
                                            if (title) {
                                                intp.print("  ");
                                                intp.println(ConsoleMsg.CONSOLE_REQUIRED_BUNDLES_MESSAGE);
                                                title = false;
                                            }
                                            intp.print("    ");
                                            intp.print(requiredBundles[i]);
                                            provider = requiredBundles[i].getBundle();
                                            intp.print("<");
                                            intp.print(provider);
                                            intp.println(">");
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (Throwable var18_28) {
                            var17_27 = null;
                            this.context.ungetService(packageAdminRef);
                            throw var18_28;
                        }
lbl-1000:
                        // 2 sources

                        {
                            var17_27 = null;
                            this.context.ungetService(packageAdminRef);
                            break block49;
                        }
                    }
                    intp.print("  ");
                    intp.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
                }
                if ((sm = System.getSecurityManager()) != null) {
                    domain = bundle.getProtectionDomain();
                    intp.println(domain);
                }
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _l(CommandInterpreter intp) throws Exception {
        this._log(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _log(CommandInterpreter intp) throws Exception {
        block24: {
            Object logreader;
            ServiceReference logreaderRef;
            long logid = -1L;
            String token = intp.nextArgument();
            if (token != null) {
                AbstractBundle bundle = this.getBundleFromToken(intp, token, false);
                if (bundle == null) {
                    try {
                        logid = Long.parseLong(token);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                } else {
                    logid = bundle.getBundleId();
                }
            }
            if ((logreaderRef = this.context.getServiceReference("org.osgi.service.log.LogReaderService")) == null || (logreader = this.context.getService(logreaderRef)) == null) break block24;
            try {
                Enumeration logentries = (Enumeration)logreader.getClass().getMethod("getLog", null).invoke(logreader, null);
                if (logentries.hasMoreElements()) {
                    Object logentry = logentries.nextElement();
                    Class<?> clazz = logentry.getClass();
                    Method getBundle = clazz.getMethod("getBundle", null);
                    Method getLevel = clazz.getMethod("getLevel", null);
                    Method getMessage = clazz.getMethod("getMessage", null);
                    Method getServiceReference = clazz.getMethod("getServiceReference", null);
                    Method getException = clazz.getMethod("getException", null);
                    while (true) {
                        AbstractBundle bundle = (AbstractBundle)getBundle.invoke(logentry, null);
                        if (logid == -1L || bundle != null && logid == bundle.getBundleId()) {
                            Integer level = (Integer)getLevel.invoke(logentry, null);
                            switch (level) {
                                case 4: {
                                    intp.print(">");
                                    intp.print(ConsoleMsg.CONSOLE_DEBUG_MESSAGE);
                                    intp.print(" ");
                                    break;
                                }
                                case 3: {
                                    intp.print(">");
                                    intp.print(ConsoleMsg.CONSOLE_INFO_MESSAGE);
                                    intp.print(" ");
                                    break;
                                }
                                case 2: {
                                    intp.print(">");
                                    intp.print(ConsoleMsg.CONSOLE_WARNING_MESSAGE);
                                    intp.print(" ");
                                    break;
                                }
                                case 1: {
                                    intp.print(">");
                                    intp.print(ConsoleMsg.CONSOLE_ERROR_MESSAGE);
                                    intp.print(" ");
                                    break;
                                }
                                default: {
                                    intp.print(">");
                                    intp.print(level);
                                    intp.print(" ");
                                }
                            }
                            if (bundle != null) {
                                intp.print("[");
                                intp.print(new Long(bundle.getBundleId()));
                                intp.print("] ");
                            }
                            intp.print(getMessage.invoke(logentry, null));
                            intp.print(" ");
                            ServiceReferenceImpl svcref = (ServiceReferenceImpl)getServiceReference.invoke(logentry, null);
                            if (svcref != null) {
                                intp.print("{");
                                intp.print("service.id");
                                intp.print("=");
                                intp.print(svcref.getProperty("service.id").toString());
                                intp.println("}");
                            } else if (bundle != null) {
                                intp.println(bundle.getLocation());
                            } else {
                                intp.println();
                            }
                            Throwable t = (Throwable)getException.invoke(logentry, null);
                            if (t != null) {
                                intp.printStackTrace(t);
                            }
                        }
                        if (logentries.hasMoreElements()) {
                            logentry = logentries.nextElement();
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_19 = null;
                this.context.ungetService(logreaderRef);
                throw throwable;
            }
            {
                Object var19_20 = null;
                this.context.ungetService(logreaderRef);
                return;
            }
        }
        intp.println(ConsoleMsg.CONSOLE_LOGSERVICE_NOT_REGISTERED_MESSAGE);
    }

    public void _gc(CommandInterpreter intp) throws Exception {
        long before = Runtime.getRuntime().freeMemory();
        System.gc();
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        long after = Runtime.getRuntime().freeMemory();
        intp.print(ConsoleMsg.CONSOLE_TOTAL_MEMORY_MESSAGE);
        intp.println(String.valueOf(Runtime.getRuntime().totalMemory()));
        intp.print(ConsoleMsg.CONSOLE_FREE_MEMORY_BEFORE_GARBAGE_COLLECTION_MESSAGE);
        intp.println(String.valueOf(before));
        intp.print(ConsoleMsg.CONSOLE_FREE_MEMORY_AFTER_GARBAGE_COLLECTION_MESSAGE);
        intp.println(String.valueOf(after));
        intp.print(ConsoleMsg.CONSOLE_MEMORY_GAINED_WITH_GARBAGE_COLLECTION_MESSAGE);
        intp.println(String.valueOf(after - before));
    }

    public void _init(CommandInterpreter intp) throws Exception {
        if (this.osgi.isActive()) {
            intp.print(this.newline);
            intp.println(ConsoleMsg.CONSOLE_FRAMEWORK_LAUNCHED_PLEASE_SHUTDOWN_MESSAGE);
            return;
        }
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        int size = bundles.length;
        if (size > 0) {
            int i = 0;
            while (i < size) {
                AbstractBundle bundle = bundles[i];
                if (bundle.getBundleId() != 0L) {
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException e) {
                        intp.printStackTrace(e);
                    }
                }
                ++i;
            }
        } else {
            intp.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        }
    }

    public void _close(CommandInterpreter intp) throws Exception {
        intp.println();
        this.osgi.close();
        System.exit(0);
    }

    public void _r(CommandInterpreter intp) throws Exception {
        this._refresh(intp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _refresh(CommandInterpreter intp) throws Exception {
        ServiceReference packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (packageAdminRef == null) {
            intp.println(ConsoleMsg.CONSOLE_CAN_NOT_REFRESH_NO_PACKAGE_ADMIN_ERROR);
            return;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
        if (packageAdmin == null) return;
        try {
            Object[] refresh = null;
            String token = intp.nextArgument();
            if (token != null) {
                int size;
                Vector<AbstractBundle> bundles = new Vector<AbstractBundle>();
                while (true) {
                    if (token == null) {
                        size = bundles.size();
                        if (size != 0) break;
                        intp.println(ConsoleMsg.CONSOLE_INVALID_BUNDLE_SPECIFICATION_ERROR);
                        Object var8_9 = null;
                        this.context.ungetService(packageAdminRef);
                        return;
                    }
                    AbstractBundle bundle = this.getBundleFromToken(intp, token, true);
                    if (bundle != null) {
                        bundles.addElement(bundle);
                    }
                    token = intp.nextArgument();
                }
                refresh = new AbstractBundle[size];
                bundles.copyInto(refresh);
            }
            packageAdmin.refreshPackages((Bundle[])refresh);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.context.ungetService(packageAdminRef);
            throw throwable;
        }
        Object var8_11 = null;
        this.context.ungetService(packageAdminRef);
    }

    public void _exec(CommandInterpreter intp) throws Exception {
        String command = intp.nextArgument();
        if (command == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        intp.println(NLS.bind(ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, command, String.valueOf(p)));
        int result = p.waitFor();
        intp.println(NLS.bind(ConsoleMsg.CONSOLE_EXECUTED_RESULT_CODE_MESSAGE, command, String.valueOf(result)));
    }

    public void _fork(CommandInterpreter intp) throws Exception {
        String command = intp.nextArgument();
        if (command == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        intp.println(NLS.bind(ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, command, String.valueOf(p)));
    }

    public void _h(CommandInterpreter intp) throws Exception {
        this._headers(intp);
    }

    public void _headers(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                intp.printDictionary(bundle.getHeaders(), ConsoleMsg.CONSOLE_BUNDLE_HEADERS_TITLE);
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _pr(CommandInterpreter intp) throws Exception {
        this._props(intp);
    }

    public void _props(CommandInterpreter intp) throws Exception {
        intp.printDictionary(System.getProperties(), ConsoleMsg.CONSOLE_SYSTEM_PROPERTIES_TITLE);
    }

    public void _setp(CommandInterpreter intp) throws Exception {
        this._setprop(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _setprop(CommandInterpreter intp) throws Exception {
        String argument = intp.nextArgument();
        if (argument == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_PARAMETERS_SPECIFIED_TITLE);
            this._props(intp);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(argument.getBytes());
        try {
            try {
                Properties sysprops = System.getProperties();
                Properties newprops = new Properties();
                newprops.load(in);
                intp.println(ConsoleMsg.CONSOLE_SETTING_PROPERTIES_TITLE);
                Enumeration<?> keys = newprops.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)newprops.get(key);
                    sysprops.put(key, value);
                    intp.println(String.valueOf(this.tab) + key + " = " + value);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ((InputStream)in).close();
    }

    public void _ss(CommandInterpreter intp) throws Exception {
        if (this.osgi.isActive()) {
            intp.println();
            intp.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            intp.println();
            intp.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        if (bundles.length == 0) {
            intp.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        } else {
            intp.print(this.newline);
            intp.print(ConsoleMsg.CONSOLE_ID);
            intp.print(this.tab);
            intp.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_TITLE);
            int i = 0;
            while (i < bundles.length) {
                AbstractBundle b = bundles[i];
                String label = b.getSymbolicName();
                label = label == null || label.length() == 0 ? b.toString() : String.valueOf(label) + "_" + b.getVersion();
                intp.println(String.valueOf(b.getBundleId()) + "\t" + this.getStateName(b.getState()) + label);
                if (b.isFragment()) {
                    BundleLoaderProxy[] hosts = b.getHosts();
                    if (hosts != null) {
                        int j = 0;
                        while (j < hosts.length) {
                            intp.println("\t            Master=" + hosts[j].getBundleHost().getBundleId());
                            ++j;
                        }
                    }
                } else {
                    Bundle[] fragments = b.getFragments();
                    if (fragments != null) {
                        intp.print("\t            Fragments=");
                        int f = 0;
                        while (f < fragments.length) {
                            AbstractBundle fragment = (AbstractBundle)fragments[f];
                            intp.print(String.valueOf(f > 0 ? ", " : "") + fragment.getBundleId());
                            ++f;
                        }
                        intp.println();
                    }
                }
                ++i;
            }
        }
    }

    public void _t(CommandInterpreter intp) throws Exception {
        this._threads(intp);
    }

    public void _threads(CommandInterpreter intp) throws Exception {
        Object[] threadGroups = this.getThreadGroups();
        Util.sort(threadGroups);
        Object tg = this.getTopThreadGroup();
        Object[] threads = new Thread[((ThreadGroup)tg).activeCount()];
        int count = ((ThreadGroup)tg).enumerate((Thread[])threads, true);
        Util.sort(threads);
        StringBuffer sb = new StringBuffer(120);
        intp.println();
        intp.println(ConsoleMsg.CONSOLE_THREADGROUP_TITLE);
        int i = 0;
        while (i < threadGroups.length) {
            tg = threadGroups[i];
            int all = ((ThreadGroup)tg).activeCount();
            int local = ((ThreadGroup)tg).enumerate(new Thread[all], false);
            ThreadGroup p = ((ThreadGroup)tg).getParent();
            String parent = p == null ? "-none-" : p.getName();
            sb.setLength(0);
            sb.append(Util.toString(this.simpleClassName(tg), 18)).append(" ").append(Util.toString(((ThreadGroup)tg).getName(), 21)).append(" ").append(Util.toString(parent, 16)).append(Util.toString(new Integer(((ThreadGroup)tg).getMaxPriority()), 3)).append(Util.toString(new Integer(local), 4)).append("/").append(Util.toString(String.valueOf(all), 6));
            intp.println(sb.toString());
            ++i;
        }
        intp.print(this.newline);
        intp.println(ConsoleMsg.CONSOLE_THREADTYPE_TITLE);
        int j = 0;
        while (j < count) {
            Object t = threads[j];
            if (t != null) {
                sb.setLength(0);
                sb.append(Util.toString(this.simpleClassName(t), 18)).append(" ").append(Util.toString(((Thread)t).getName(), 21)).append(" ").append(Util.toString(((Thread)t).getThreadGroup().getName(), 16)).append(Util.toString(new Integer(((Thread)t).getPriority()), 3));
                intp.println(sb.toString());
            }
            ++j;
        }
    }

    public void _sl(CommandInterpreter intp) throws Exception {
        if (this.isStartLevelSvcPresent(intp)) {
            AbstractBundle bundle = null;
            String token = intp.nextArgument();
            int value = 0;
            if (token != null && (bundle = this.getBundleFromToken(intp, token, true)) == null) {
                return;
            }
            if (bundle == null) {
                value = this.slImpl.getStartLevel();
                intp.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(value)));
            } else {
                value = this.slImpl.getBundleStartLevel(bundle);
                intp.println(NLS.bind(ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, new Long(bundle.getBundleId()), new Integer(value)));
            }
        }
    }

    public void _setfwsl(CommandInterpreter intp) throws Exception {
        if (this.isStartLevelSvcPresent(intp)) {
            int value = 0;
            String token = intp.nextArgument();
            if (token == null) {
                intp.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_GIVEN);
                value = this.slImpl.getStartLevel();
                intp.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(value)));
            } else {
                value = this.getStartLevelFromToken(intp, token);
                if (value > 0) {
                    try {
                        this.slImpl.setStartLevel(value);
                        intp.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(value)));
                    }
                    catch (IllegalArgumentException e) {
                        intp.println(e.getMessage());
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void _setbsl(CommandInterpreter intp) throws Exception {
        block5: {
            if (!this.isStartLevelSvcPresent(intp)) break block5;
            bundle = null;
            token = intp.nextArgument();
            if (token == null) {
                intp.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
                return;
            }
            newSL = this.getStartLevelFromToken(intp, token);
            token = intp.nextArgument();
            if (token != null) ** GOTO lbl21
            intp.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
            return;
lbl-1000:
            // 1 sources

            {
                bundle = this.getBundleFromToken(intp, token, true);
                if (bundle != null) {
                    try {
                        this.slImpl.setBundleStartLevel(bundle, newSL);
                        intp.println(NLS.bind(ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, new Long(bundle.getBundleId()), new Integer(newSL)));
                    }
                    catch (IllegalArgumentException e) {
                        intp.println(e.getMessage());
                    }
                }
                token = intp.nextArgument();
lbl21:
                // 2 sources

                ** while (token != null)
            }
        }
    }

    public void _setibsl(CommandInterpreter intp) throws Exception {
        if (this.isStartLevelSvcPresent(intp)) {
            int value = 0;
            String token = intp.nextArgument();
            if (token == null) {
                intp.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_GIVEN);
                value = this.slImpl.getInitialBundleStartLevel();
                intp.println(NLS.bind(ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, String.valueOf(value)));
            } else {
                value = this.getStartLevelFromToken(intp, token);
                if (value > 0) {
                    try {
                        this.slImpl.setInitialBundleStartLevel(value);
                        intp.println(NLS.bind(ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, String.valueOf(value)));
                    }
                    catch (IllegalArgumentException e) {
                        intp.println(e.getMessage());
                    }
                }
            }
        }
    }

    public void _requiredBundles(CommandInterpreter intp) {
        this._classSpaces(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _classSpaces(CommandInterpreter intp) {
        token = intp.nextArgument();
        packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (packageAdminRef == null) {
            intp.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
            return;
        }
        packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
        if (packageAdmin == null) return;
        try {
            block10: {
                symBundles = null;
                symBundles = packageAdmin.getRequiredBundles(token);
                if (symBundles != null) break block10;
                intp.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
                ** GOTO lbl-1000
            }
            i = 0;
            while (i < symBundles.length) {
                symBundle = symBundles[i];
                intp.print(symBundle);
                removalPending = symBundle.isRemovalPending();
                if (removalPending) {
                    intp.print("(");
                    intp.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                    intp.println(")");
                }
                if ((provider = symBundle.getBundle()) != null) {
                    intp.print("<");
                    intp.print(provider);
                    intp.println(">");
                    requiring = symBundle.getRequiringBundles();
                    if (requiring != null) {
                        j = 0;
                        while (j < requiring.length) {
                            intp.print("  ");
                            intp.print(requiring[j]);
                            intp.print(" ");
                            intp.println(ConsoleMsg.CONSOLE_REQUIRES_MESSAGE);
                            ++j;
                        }
                    }
                } else {
                    intp.print("<");
                    intp.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                    intp.println(">");
                }
                ++i;
            }
        }
        catch (Throwable var13_12) {
            var12_13 = null;
            this.context.ungetService(packageAdminRef);
            throw var13_12;
        }
lbl-1000:
        // 2 sources

        {
            var12_14 = null;
            this.context.ungetService(packageAdminRef);
            return;
        }
    }

    public void _profilelog(CommandInterpreter intp) throws Exception {
        intp.println(Profile.getProfileLog());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _getPackages(CommandInterpreter intp) {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            return;
        }
        AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
        ServiceReference ref = this.context.getServiceReference("org.eclipse.osgi.service.resolver.PlatformAdmin");
        if (ref == null) {
            return;
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(ref);
        try {
            ExportPackageDescription[] exports = platformAdmin.getStateHelper().getVisiblePackages(bundle.getBundleDescription());
            int i = 0;
            while (i < exports.length) {
                intp.println(exports[i] + ": " + platformAdmin.getStateHelper().getAccessCode(bundle.getBundleDescription(), exports[i]));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.context.ungetService(ref);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.context.ungetService(ref);
        }
    }

    protected boolean isStartLevelSvcPresent(CommandInterpreter intp) {
        boolean retval = false;
        ServiceReference slSvcRef = this.context.getServiceReference("org.osgi.service.startlevel.StartLevel");
        if (slSvcRef != null) {
            StartLevel slSvc = (StartLevel)this.context.getService(slSvcRef);
            if (slSvc != null) {
                retval = true;
            }
        } else {
            intp.println(ConsoleMsg.CONSOLE_CAN_NOT_USE_STARTLEVEL_NO_STARTLEVEL_SVC_ERROR);
        }
        return retval;
    }

    protected AbstractBundle getBundleFromToken(CommandInterpreter intp, String token, boolean error) {
        AbstractBundle bundle;
        try {
            long id = Long.parseLong(token);
            bundle = (AbstractBundle)this.context.getBundle(id);
        }
        catch (NumberFormatException numberFormatException) {
            bundle = ((BundleContextImpl)this.context).getBundleByLocation(token);
        }
        if (bundle == null && error) {
            intp.println(NLS.bind(ConsoleMsg.CONSOLE_CANNOT_FIND_BUNDLE_ERROR, token));
        }
        return bundle;
    }

    protected int getStartLevelFromToken(CommandInterpreter intp, String value) {
        int retval = -1;
        try {
            retval = Integer.parseInt(value);
            if (Integer.parseInt(value) <= 0) {
                intp.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
            }
        }
        catch (NumberFormatException numberFormatException) {
            intp.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
        }
        return retval;
    }

    protected String getStateName(int state) {
        switch (state) {
            case 1: {
                return ConsoleMsg.CONSOLE_UNINSTALLED_MESSAGE;
            }
            case 2: {
                return ConsoleMsg.CONSOLE_INSTALLED_MESSAGE;
            }
            case 4: {
                return ConsoleMsg.CONSOLE_RESOLVED_MESSAGE;
            }
            case 8: {
                return ConsoleMsg.CONSOLE_STARTING_MESSAGE;
            }
            case 16: {
                return ConsoleMsg.CONSOLE_STOPPING_MESSAGE;
            }
            case 32: {
                return ConsoleMsg.CONSOLE_ACTIVE_MESSAGE;
            }
        }
        return Integer.toHexString(state);
    }

    protected ThreadGroup[] getThreadGroups() {
        ThreadGroup[] groups;
        ThreadGroup tg = this.getTopThreadGroup();
        int count = tg.enumerate(groups = new ThreadGroup[tg.activeGroupCount()], true);
        if (count == groups.length) {
            return groups;
        }
        ThreadGroup[] ngroups = new ThreadGroup[count];
        System.arraycopy(groups, 0, ngroups, 0, count);
        return ngroups;
    }

    protected ThreadGroup getTopThreadGroup() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        if (topGroup != null) {
            while (topGroup.getParent() != null) {
                topGroup = topGroup.getParent();
            }
        }
        return topGroup;
    }

    public String simpleClassName(Object o) {
        StringTokenizer t = new StringTokenizer(o.getClass().getName(), ".");
        int ct = t.countTokens();
        int i = 1;
        while (i < ct) {
            t.nextToken();
            ++i;
        }
        return t.nextToken();
    }
}

