/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.InstallWizard2;
import org.eclipse.update.internal.ui.wizards.InstallWizardOperation;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.ui.UpdateJob;

public class InstallWizardOperation {
    private UpdateJob job;
    private IJobChangeListener jobListener;
    private Shell shell;
    private Shell parentShell;

    public void run(Shell parent, UpdateJob task) {
        this.shell = parent;
        if (this.shell.getParent() != null && this.shell.getParent() instanceof Shell) {
            this.parentShell = (Shell)this.shell.getParent();
        }
        if (this.jobListener != null) {
            Platform.getJobManager().removeJobChangeListener(this.jobListener);
        }
        if (this.job != null) {
            Platform.getJobManager().cancel((Object)this.job);
        }
        this.job = task;
        this.jobListener = new UpdateJobChangeListener();
        Platform.getJobManager().addJobChangeListener(this.jobListener);
        this.job.schedule();
    }

    private Shell getValidShell() {
        if (this.shell.isDisposed()) {
            return this.parentShell;
        }
        return this.shell;
    }

    private class UpdateJobChangeListener
    extends JobChangeAdapter {
        UpdateJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            Shell validShell = InstallWizardOperation.this.getValidShell();
            if (event.getJob() == InstallWizardOperation.this.job) {
                Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                Platform.getJobManager().cancel((Object)InstallWizardOperation.this.job);
                if (InstallWizardOperation.this.job.getStatus() == Status.CANCEL_STATUS) {
                    return;
                }
                if (InstallWizardOperation.this.job.getStatus() != Status.OK_STATUS) {
                    InstallWizardOperation.this.getValidShell().getDisplay().syncExec(new Runnable(this){
                        final /* synthetic */ UpdateJobChangeListener this$1;
                        {
                            this.this$1 = updateJobChangeListener;
                        }

                        public void run() {
                            UpdateUI.log(InstallWizardOperation.access$1(UpdateJobChangeListener.access$1(this.this$1)).getStatus(), true);
                        }
                    });
                }
                validShell.getDisplay().asyncExec(new Runnable(this, validShell){
                    final /* synthetic */ UpdateJobChangeListener this$1;
                    private final /* synthetic */ Shell val$validShell;
                    {
                        this.this$1 = updateJobChangeListener;
                        this.val$validShell = shell;
                    }

                    public void run() {
                        this.val$validShell.getDisplay().beep();
                        BusyIndicator.showWhile((Display)this.val$validShell.getDisplay(), (Runnable)new Runnable(this){
                            final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                UpdateJobChangeListener.access$0(2.access$0(this.this$2));
                            }
                        });
                    }

                    static /* synthetic */ UpdateJobChangeListener access$0(2 var0) {
                        return var0.this$1;
                    }
                });
            }
        }

        private void openInstallWizard2() {
            if (InstallWizard2.isRunning()) {
                MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_isRunningTitle, (String)UpdateUIMessages.InstallWizard_isRunningInfo);
                return;
            }
            if (InstallWizardOperation.this.job.getUpdates() == null || InstallWizardOperation.this.job.getUpdates().length == 0) {
                if (InstallWizardOperation.this.job.isUpdate()) {
                    MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroUpdates, (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroUpdates);
                } else {
                    MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroFeatures, (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroFeatures);
                }
                return;
            }
            InstallWizard2 wizard = new InstallWizard2(InstallWizardOperation.this.job.getSearchRequest(), InstallWizardOperation.this.job.getUpdates(), InstallWizardOperation.this.job.isUpdate());
            ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(InstallWizardOperation.this.getValidShell(), (IWizard)wizard, UpdateUIMessages.AutomaticUpdatesJob_Updates);
            dialog.create();
            dialog.open();
        }

        static /* synthetic */ void access$0(UpdateJobChangeListener updateJobChangeListener) {
            updateJobChangeListener.openInstallWizard2();
        }

        static /* synthetic */ InstallWizardOperation access$1(UpdateJobChangeListener updateJobChangeListener) {
            return updateJobChangeListener.InstallWizardOperation.this;
        }
    }
}

