/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.basic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FLVUtil {
    public static boolean isFLV(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (FLVUtil.getExtension(file.getName()).toLowerCase().equals("flv")) {
            return true;
        }
        if (FLVUtil.getExtension(file.getName()).equals("")) {
            return FLVUtil.isFLVFileFormat(file);
        }
        return false;
    }

    public static String getExtension(String name) {
        int ex = name.lastIndexOf(".");
        if (ex == -1) {
            return "";
        }
        return name.substring(ex + 1);
    }

    public static boolean isFLVFileFormat(File file) {
        try {
            FileInputStream input = new FileInputStream(file);
            byte[] bts = new byte[5];
            int readed = ((InputStream)input).read(bts);
            if (readed < 5) {
                return false;
            }
            ((InputStream)input).close();
            if (bts[0] == 70 && bts[1] == 76 && bts[2] == 86) {
                return bts[3] < 10;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

