/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.basic.FLVUtil;
import jp.sourceforge.akjrcp.flvtools.basic.OpenDirectable;
import jp.sourceforge.akjrcp.flvtools.basic.SimpleView;
import jp.sourceforge.akjrcp.flvtools.explorer.ThumbnailManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ExplorerView
extends ViewPart
implements OpenDirectable {
    public static Log log;
    public static final String ID;
    private ScrolledComposite scroll;
    private Composite parent;
    private String currentDir;
    private String[] assistantNames;
    private Text directoryPath;
    protected static Image noImage;
    private String[] folders;
    ArrayList actionValueList = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
        Display display = Display.getCurrent();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        noImage = new Image((Device)display, clazz3.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/noimage.png"));
    }

    public void initAssistantName(File file) {
        String[] list = file.list();
        FLVFilter filter = new FLVFilter();
        ArrayList<String> tmpNames = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            File tmp = new File(file, list[i]);
            if (tmp.isDirectory()) {
                String[] flvList = tmp.list(filter);
                int j = 0;
                while (j < flvList.length) {
                    String flvKey = this.trimNumberName(flvList[j].substring(0, flvList[j].length() - ".flv".length()));
                    tmpNames.remove(flvKey);
                    tmpNames.add(flvKey);
                    ++j;
                }
            }
            ++i;
        }
        this.assistantNames = tmpNames.toArray(new String[0]);
    }

    private String trimNumberName(String name) {
        int x;
        String newName = name;
        if (name.endsWith(")") && (x = name.lastIndexOf("(")) != -1) {
            String digi = name.substring(x + 1, name.length() - 1);
            boolean isDigit = true;
            int i = 0;
            while (i < digi.length()) {
                if (!Character.isDigit(digi.charAt(i))) {
                    isDigit = false;
                    break;
                }
                ++i;
            }
            if (isDigit) {
                newName = name.substring(0, x);
            }
        }
        return newName;
    }

    public static File getEmptyFileName(File file) {
        String fileName;
        if (!file.exists()) {
            return file;
        }
        String head = fileName = file.getName();
        int e = fileName.lastIndexOf(".");
        String ext = "";
        if (e != -1) {
            ext = fileName.substring(e);
            head = fileName.substring(0, e);
        }
        int index = 1;
        File newFile = null;
        while (newFile == null || newFile.exists()) {
            String newName = String.valueOf(head) + "(" + index + ")" + ext;
            newFile = new File(file.getParentFile(), newName);
            ++index;
        }
        return newFile;
    }

    public String findBaseDir() {
        String baseDir = SimpleView.findBaseDir();
        return baseDir;
    }

    public void createPartControl(Composite root) {
        String[] flvfiles = this.getFLVFiles(new File(this.findBaseDir()));
        ThumbnailManager.clearThumbnails(flvfiles);
        root.setLayout((Layout)new GridLayout(1, false));
        Composite controler = new Composite(root, 0);
        controler.setLayout((Layout)new GridLayout(2, false));
        Button execButton = new Button(controler, 0);
        execButton.setText(Messages.getString("execute"));
        execButton.addSelectionListener((SelectionListener)new ExecExecuter());
        this.directoryPath = new Text(controler, 12);
        GridData datax = new GridData(768);
        this.directoryPath.setLayoutData((Object)datax);
        Composite cp = new Composite(root, 0);
        GridData data = new GridData(1808);
        cp.setLayoutData((Object)data);
        cp.setBackground(new Color((Device)Display.getCurrent(), 255, 0, 0));
        cp.setLayout((Layout)new FillLayout());
        this.scroll = new ScrolledComposite(cp, 768);
        this.parent = new Composite((Composite)this.scroll, 0);
        this.parent.setLayout((Layout)new GridLayout(1, false));
        String baseDir = this.findBaseDir();
        this.openDirectory(baseDir);
        this.parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
            }
        });
        this.scroll.setContent((Control)this.parent);
        log.info((Object)root.getSize());
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    public void playFLV(File file) {
        Program program = Program.findProgram((String)".flv");
        if (program != null) {
            log.info((Object)("play:" + file.getAbsolutePath()));
            boolean l = program.execute(file.getAbsolutePath());
            log.info((Object)("" + l));
        }
    }

    public void openDirectory(String path) {
        this.directoryPath.setText(path);
        this.currentDir = path;
        File file = new File(path);
        this.initAssistantName(file);
        this.initFolder(file);
        this.initList(file);
        this.parent.layout();
    }

    public String[] getFLVFiles(File baseDir) {
        String[] list = baseDir.list();
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            File file2 = new File(baseDir, list[i]);
            if (FLVUtil.isFLV(file2)) {
                array.add(file2.getAbsolutePath());
            }
            ++i;
        }
        return array.toArray(new String[0]);
    }

    public void initList(File file) {
        this.actionValueList.removeAll(this.actionValueList);
        Control[] cp = this.parent.getChildren();
        int i = 0;
        while (i < cp.length) {
            cp[i].dispose();
            ++i;
        }
        String[] flvfiles = this.getFLVFiles(file);
        int i2 = 0;
        while (i2 < flvfiles.length) {
            this.createFileInfoComposite(this.parent, new File(flvfiles[i2]));
            ++i2;
        }
        this.scroll.setMinSize(320, 136 * this.parent.getChildren().length);
    }

    public Composite createFileInfoComposite(Composite parent, File file) {
        Composite panel = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        panel.setLayout((Layout)grid);
        Label imgLabel = new Label(panel, 0);
        imgLabel.setImage(this.loadIcon(file));
        GridData data1 = new GridData();
        data1.verticalSpan = 2;
        imgLabel.setLayoutData((Object)data1);
        CCombo fileName = new CCombo(panel, 0);
        fileName.add(this.trimExtension(file.getName()));
        int i = 0;
        while (i < this.assistantNames.length) {
            fileName.add(this.assistantNames[i]);
            ++i;
        }
        fileName.select(0);
        GridData data2 = new GridData(768);
        data2.minimumWidth = 160;
        fileName.setLayoutData((Object)data2);
        CCombo box = this.makeComboBox(panel);
        GridData data3 = new GridData(768);
        data3.minimumWidth = 160;
        box.setLayoutData((Object)data3);
        ActionValues values = new ActionValues(file, box, fileName);
        this.actionValueList.add(values);
        imgLabel.addMouseListener((MouseListener)values);
        return panel;
    }

    private String trimExtension(String name) {
        int e = name.toLowerCase().lastIndexOf(".flv");
        if (e != -1) {
            return name.substring(0, e);
        }
        return name;
    }

    private void initFolder(File file) {
        String[] list = file.list();
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            if (new File(file, list[i]).isDirectory()) {
                array.add(list[i]);
            }
            ++i;
        }
        this.folders = array.toArray(new String[0]);
    }

    private CCombo makeComboBox(Composite panel) {
        CCombo box = new CCombo(panel, 8);
        box.add("");
        int i = 0;
        while (i < this.folders.length) {
            box.add(this.folders[i]);
            ++i;
        }
        return box;
    }

    public Image loadIcon(File file) {
        Image img = ThumbnailManager.loadThumbnail(file);
        if (img == null) {
            img = noImage;
        }
        return img;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExplorerView.this.fillContextMenu(manager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    public void openDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        if (path != null) {
            this.openDirectory(path);
        }
    }

    public void setFocus() {
        this.parent.forceFocus();
    }

    public class FLVFilter
    implements FilenameFilter {
        public boolean accept(File arg0, String arg1) {
            return arg1.toLowerCase().endsWith(".flv");
        }
    }

    public class MoveAction
    extends Thread {
        public void run() {
            ActionValues[] values = ExplorerView.this.actionValueList.toArray(new ActionValues[0]);
            int i = 0;
            while (i < values.length) {
                values[i].setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < values.length) {
                this.execMove(values[i]);
                ++i;
            }
            ExplorerView.this.openDirectory(ExplorerView.this.currentDir);
        }

        private void execMove(ActionValues values) {
            File parent = values.getFile().getParentFile();
            String path = parent.getAbsolutePath();
            String dir = values.getNewDirectory();
            if (dir.length() > 0) {
                path = String.valueOf(path) + "\\" + dir;
            }
            path = String.valueOf(path) + "\\" + this.trim(values.getNewName());
            path = String.valueOf(path) + ".flv";
            if (!values.getFile().getAbsolutePath().equals(path)) {
                log.info((Object)("rename to:" + path));
                File renameFile = new File(path);
                File emptyName = ExplorerView.getEmptyFileName(renameFile);
                boolean result = values.getFile().renameTo(emptyName);
                if (!result) {
                    log.warn((Object)("rename faild:" + emptyName.getAbsolutePath()));
                }
            }
        }

        private String trim(String name) {
            if (name.toLowerCase().endsWith(".flv")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
    }

    public class ExecExecuter
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new MoveAction());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ActionValues
    implements MouseListener {
        private File file;
        private CCombo combo;
        private CCombo text;

        public File getFile() {
            return this.file;
        }

        public String getNewName() {
            return this.text.getText();
        }

        public String getNewDirectory() {
            return this.combo.getText();
        }

        public void setEnabled(boolean bool) {
            this.combo.setEnabled(bool);
            this.text.setEnabled(bool);
        }

        public ActionValues(File file, CCombo combo, CCombo text) {
            this.file = file;
            this.combo = combo;
            this.text = text;
        }

        public void mouseDoubleClick(MouseEvent e) {
            log.warn((Object)"mouse");
            ExplorerView.this.playFLV(this.file);
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

