/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarOutputStream;

public class TarFileExporter
implements IFileExporter {
    private TarOutputStream outputStream;
    private GZIPOutputStream gzipOutputStream;

    public TarFileExporter(String filename, boolean compress) throws IOException {
        if (compress) {
            this.gzipOutputStream = new GZIPOutputStream(new FileOutputStream(filename));
            this.outputStream = new TarOutputStream(new BufferedOutputStream(this.gzipOutputStream));
        } else {
            this.outputStream = new TarOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        }
    }

    public void finished() throws IOException {
        this.outputStream.close();
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(TarEntry entry, IFile contents) throws IOException, CoreException {
        block6: {
            IPath location = contents.getLocation();
            if (location == null) {
                throw new FileNotFoundException(contents.getFullPath().toOSString());
            }
            File localFile = location.toFile();
            entry.setSize(localFile.length());
            this.outputStream.putNextEntry(entry);
            InputStream contentStream = contents.getContents(false);
            try {
                int n;
                byte[] readBuffer = new byte[4096];
                while ((n = contentStream.read(readBuffer)) > 0) {
                    this.outputStream.write(readBuffer, 0, n);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (contentStream != null) {
                    contentStream.close();
                }
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (contentStream == null) break block6;
            }
            contentStream.close();
        }
        this.outputStream.closeEntry();
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        ResourceAttributes attributes;
        TarEntry newEntry = new TarEntry(destinationPath);
        if (resource.getLocalTimeStamp() != -1L) {
            newEntry.setTime(resource.getLocalTimeStamp() / 1000L);
        }
        if ((attributes = resource.getResourceAttributes()).isExecutable()) {
            newEntry.setMode(newEntry.getMode() | 0x49L);
        }
        if (attributes.isReadOnly()) {
            newEntry.setMode(newEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        this.write(newEntry, resource);
    }
}

