/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.DialogMarkerProperties;
import org.eclipse.ui.views.markers.internal.FieldSeverity;
import org.eclipse.ui.views.markers.internal.Messages;

class DialogProblemProperties
extends DialogMarkerProperties {
    private Label severityLabel;

    DialogProblemProperties(Shell parentShell) {
        super(parentShell);
    }

    protected void createAttributesArea(Composite parent) {
        super.createAttributesArea(parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        this.severityLabel = new Label(composite, 0);
        this.severityLabel.setFont(composite.getFont());
    }

    protected void updateDialogFromMarker() {
        super.updateDialogFromMarker();
        IMarker marker = this.getMarker();
        if (marker == null) {
            return;
        }
        FieldSeverity type = new FieldSeverity();
        this.severityLabel.setImage(type.getImage(marker));
        int severity = marker.getAttribute("severity", -1);
        if (severity == 2) {
            this.severityLabel.setText(Messages.format("propertiesDialog.severityLabel", new String[]{Messages.getString("propertiesDialog.errorLabel")}));
        } else if (severity == 1) {
            this.severityLabel.setText(Messages.format("propertiesDialog.severityLabel", new String[]{Messages.getString("propertiesDialog.warningLabel")}));
        } else if (severity == 0) {
            this.severityLabel.setText(Messages.format("propertiesDialog.severityLabel", new String[]{Messages.getString("propertiesDialog.infoLabel")}));
        } else {
            this.severityLabel.setText(Messages.format("propertiesDialog.severityLabel", new String[]{Messages.getString("propertiesDialog.noseverityLabel")}));
        }
    }
}

