/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dvdstyler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.akjrcp.akj_betas.wizards.DVDStylerExportWizard;
import jp.sourceforge.akjrcp.dvdstyler.DVDStylerMenu;
import jp.sourceforge.akjrcp.dvdstyler.DVDStylerTitle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DVDStylerData {
    private DVDStylerMenu menu = new DVDStylerMenu();
    private List videos = new ArrayList();

    public static String createJumpMenu(int index) {
        return "jump title " + index + ";";
    }

    public static String createVmgmMenu(int index) {
        return "call vmgm menu " + index + ";";
    }

    public Element toTitleElement(Document document, DVDStylerTitle title) {
        Element pgc = document.createElement("pgc");
        Element vob = document.createElement("vob");
        vob.setAttribute("file", title.getPath());
        vob.setAttribute("chapters", title.getChapters());
        pgc.appendChild(vob);
        Element post = document.createElement("post");
        post.appendChild(document.createTextNode(title.getPostAction()));
        pgc.appendChild(post);
        return pgc;
    }

    public Document toDocument() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("dvdstyler");
            root.setAttribute("jumppad", "1");
            root.setAttribute("emptymenu", "1");
            document.appendChild(root);
            DVDStylerExportWizard.log.info((Object)root);
            Element vmgm = document.createElement("vmgm");
            Element menus = document.createElement("menus");
            root.appendChild(vmgm);
            vmgm.appendChild(menus);
            Element titleset = document.createElement("titleset");
            root.appendChild(titleset);
            Element menus2 = document.createElement("menus");
            titleset.appendChild(menus2);
            Element pgc = document.createElement("pgc");
            menus2.appendChild(pgc);
            Element spumux = document.createElement("spumux");
            pgc.appendChild(spumux);
            Element menu = document.createElement("menu");
            spumux.appendChild(menu);
            menu.setAttribute("videoFormat", "NTSC");
            menu.setAttribute("bgColour", "#000000");
            Element vob = document.createElement("vob");
            pgc.appendChild(vob);
            vob.setAttribute("file", "");
            vob.setAttribute("pause", "inf");
            Element pre = document.createElement("pre");
            pgc.appendChild(pre);
            Text text = document.createTextNode(this.menu.getPreAction());
            pre.appendChild(text);
            Element titles = document.createElement("titles");
            titleset.appendChild(titles);
            DVDStylerTitle[] stylerTitles = this.videos.toArray(new DVDStylerTitle[0]);
            int i = 0;
            while (i < stylerTitles.length) {
                titles.appendChild(this.toTitleElement(document, stylerTitles[i]));
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            DVDStylerExportWizard.log.warn((Object)e.getMessage());
        }
        return document;
    }

    public void addTitle(DVDStylerTitle title) {
        this.videos.add(title);
    }
}

