/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;

public class FFMpegFileInfo {
    private String audioCodec;
    private int audioBitrate;
    private int audioRate;
    private int audioChannel;

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public int getAudioChannel() {
        return this.audioChannel;
    }

    public void setAudioChannel(int audioChannel) {
        this.audioChannel = audioChannel;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
    }

    public int getAudioRate() {
        return this.audioRate;
    }

    public void setAudioRate(int audioRate) {
        this.audioRate = audioRate;
    }

    public FFMpegFileInfo(String ffmpegPath, File file) {
        String[] commands = new String[]{ffmpegPath, "-i", file.getAbsolutePath()};
        Runtime runtime = Runtime.getRuntime();
        InfoParseProcessPrinter printer = new InfoParseProcessPrinter();
        Process process = null;
        try {
            process = runtime.exec(commands);
            ProcessMonitor monitor = new ProcessMonitor(process, printer);
            monitor.startMonitor();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
    }

    public String toString() {
        return "audio:" + this.audioCodec + " " + this.audioRate + " " + this.audioChannel + " " + this.audioBitrate;
    }

    public class InfoParseProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (line.indexOf("Stream #") != -1) {
                String v = line.replaceAll(" ", "");
                int m = (v = v.replaceAll("\n", "")).indexOf("Audio:");
                if (m != -1) {
                    v = v.substring(m + 6);
                    System.out.println(v);
                    String[] vs = v.split(",");
                    FFMpegFileInfo.this.audioCodec = vs[0];
                    if (vs.length > 1) {
                        FFMpegFileInfo.this.audioRate = Integer.parseInt(vs[1].substring(0, vs[1].length() - 2));
                        if (vs.length > 2) {
                            if (vs[2].equals("stereo")) {
                                FFMpegFileInfo.this.audioChannel = 2;
                            } else if (vs[2].equals("mono")) {
                                FFMpegFileInfo.this.audioChannel = 1;
                            }
                            if (vs.length > 3) {
                                FFMpegFileInfo.this.audioBitrate = Integer.parseInt(vs[3].substring(0, vs[3].length() - 4));
                            }
                        }
                    }
                }
            }
        }
    }
}

