/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.greycstoration;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.greycstoration.DirectoryBasedGreycstorationExecuter;
import jp.sourceforge.akjrcp.greycstoration.RestorationSetting;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.SpinnerAndScale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class GreycstorationTabBuilder
implements IDropSomething {
    public static Log log;
    private FileOverwriteControler fileOverwriteControler;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.greycstoration.GreycstorationTabBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("greycstoration.tab_title"));
        tabItem1.setControl((Control)new GreycstorationTab((Composite)tab, 0));
        this.fileOverwriteControler = new FileOverwriteControler(tab.getShell());
    }

    public class GreycstorationTab
    extends DirectoryBasedDropSomething {
        private Composite controler;
        private DirectoryBasedGreycstorationExecuter directoryBasedExecuter;
        private Label dragHere;
        private SpinnerAndScale alphaSAS;
        private SpinnerAndScale sigmaSAS;
        private SpinnerAndScale pSAS;
        private SpinnerAndScale aSAS;
        private SpinnerAndScale iterSAS;
        private SpinnerAndScale dtSAS;
        private CCombo preSets;
        private Button beforeafter;

        public GreycstorationTab(Composite parent, int style) {
            super(parent, style);
        }

        public Composite createControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            this.createDirectoryInfo(composite);
            Composite advancedOption = new Composite(composite, 0);
            advancedOption.setLayout((Layout)new RowLayout());
            this.beforeafter = new Button(advancedOption, 32);
            this.beforeafter.setText(Messages.getString("GreycstorationTab.before_after"));
            this.controler = new Group(composite, 0);
            ((Group)this.controler).setText("Restoration");
            this.controler.setLayout((Layout)new GridLayout(4, false));
            Akj_betasPlugin.getDefault().getPreferenceStore();
            GridData preData = new GridData();
            preData.horizontalSpan = 4;
            this.preSets = new CCombo(this.controler, 0);
            this.preSets.add("Default\u30002.5.1 -restore -alpha 0.6 -sigma 1.1 -p 0.9 -a 0.15 -iter 1 -dt 40");
            this.preSets.add("Aki Natural v1 -restore -alpha 0.6 -sigma 1.1 -p 0.7 -a 0.15 -iter 1 -dt 50");
            this.preSets.add("Aki noise v1 -restore -alpha 0.6 -sigma 0.1 -p 0.7 -a 0.15 -iter 2 -dt 50");
            this.preSets.add("Aki Recommend v1 -restore -alpha 1.0 -sigma 2.5 -p 0.6 -a 0.6 -iter 1 -dt 75");
            this.preSets.add("Aki Fantasy v1 -restore -alpha 0.3 -sigma 1.1 -p 0.4 -a 0.05 -iter 1 -dt 252");
            this.preSets.select(0);
            this.preSets.setLayoutData((Object)preData);
            this.preSets.addSelectionListener((SelectionListener)new PreSetChange());
            PreSetUpdate preSetUpdate = new PreSetUpdate();
            this.createLabel(this.controler, Messages.getString("greycstoration.alpha"));
            this.alphaSAS = new SpinnerAndScale(this.controler, 0);
            this.alphaSAS.setMaximum(1000);
            this.alphaSAS.setSelection(6);
            this.alphaSAS.setDigits(1);
            this.alphaSAS.addSelectionListener(preSetUpdate);
            this.createLabel(this.controler, Messages.getString("greycstoration.sigma"));
            this.sigmaSAS = new SpinnerAndScale(this.controler, 0);
            this.sigmaSAS.setMaximum(1000);
            this.sigmaSAS.setSelection(11);
            this.sigmaSAS.setDigits(1);
            this.sigmaSAS.addSelectionListener(preSetUpdate);
            this.createLabel(this.controler, Messages.getString("greycstoration.p"));
            this.pSAS = new SpinnerAndScale(this.controler, 0);
            this.pSAS.setMaximum(50);
            this.pSAS.setSelection(9);
            this.pSAS.setDigits(1);
            this.pSAS.addSelectionListener(preSetUpdate);
            this.createLabel(this.controler, Messages.getString("greycstoration.a"));
            this.aSAS = new SpinnerAndScale(this.controler, 0);
            this.aSAS.setMaximum(100);
            this.aSAS.setSelection(15);
            this.aSAS.setDigits(2);
            this.aSAS.addSelectionListener(preSetUpdate);
            this.createLabel(this.controler, Messages.getString("greycstoration.iter"));
            this.iterSAS = new SpinnerAndScale(this.controler, 0);
            this.iterSAS.setMaximum(100);
            this.iterSAS.setMinimum(1);
            this.iterSAS.setSelection(1);
            this.iterSAS.addSelectionListener(preSetUpdate);
            this.createLabel(this.controler, Messages.getString("greycstoration.dt"));
            this.dtSAS = new SpinnerAndScale(this.controler, 0);
            this.dtSAS.setMaximum(1000);
            this.dtSAS.setMinimum(0);
            this.dtSAS.setSelection(40);
            this.dtSAS.addSelectionListener(preSetUpdate);
            this.dragHere = new Label(composite, 0);
            this.dragHere.setLayoutData((Object)new GridData(768));
            this.setCanConvert(true);
            this.updateStatus();
            this.presetChanged();
            return composite;
        }

        public void presetChanged() {
            String value = this.preSets.getText();
            Pattern restro = Pattern.compile(".*-alpha (.*) -sigma (.*) -p (.*) -a (.*) -iter (.*) -dt (.*$)");
            Matcher match = restro.matcher(value);
            if (match.matches()) {
                int alpha = (int)(Double.parseDouble(match.group(1)) * 10.0);
                int sigma = (int)(Double.parseDouble(match.group(2)) * 10.0);
                int p = (int)(Double.parseDouble(match.group(3)) * 10.0);
                int a = (int)(Double.parseDouble(match.group(4)) * 100.0);
                int iter = Integer.parseInt(match.group(5));
                int dt = Integer.parseInt(match.group(6));
                this.alphaSAS.setSelection(alpha);
                this.sigmaSAS.setSelection(sigma);
                this.pSAS.setSelection(p);
                this.aSAS.setSelection(a);
                this.iterSAS.setSelection(iter);
                this.dtSAS.setSelection(dt);
            }
        }

        public void inconvert(File file) {
            this.directoryBasedExecuter.execute(new File[]{file});
        }

        private void setDirectoryBasedSetting() {
            if (this.directoryBasedExecuter != null) {
                this.directoryBasedExecuter.setSameDirectory(this.samefolder.getSelection());
                this.directoryBasedExecuter.setBackup(this.backup.getSelection());
                if (!this.samefolder.getSelection()) {
                    this.directoryBasedExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
                }
            }
        }

        public void beforeConvert() {
            this.directoryBasedExecuter = new DirectoryBasedGreycstorationExecuter();
            this.setDirectoryBasedSetting();
            this.directoryBasedExecuter.setExecuteListener(new FFMpegMonitor());
            String greycstorationPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("greycstoration_path");
            RestorationSetting restorationSetting = new RestorationSetting(greycstorationPath);
            this.directoryBasedExecuter.setRestorationSetting(restorationSetting);
            this.directoryBasedExecuter.setSettingLabel(this.preSets.getText());
            restorationSetting.setAlpha(this.alphaSAS.getDigitedSelection());
            restorationSetting.setSigma(this.sigmaSAS.getDigitedSelection());
            restorationSetting.setA(this.aSAS.getDigitedSelection());
            restorationSetting.setP(this.pSAS.getDigitedSelection());
            restorationSetting.setIter(this.iterSAS.getSelection());
            restorationSetting.setDt(this.dtSAS.getSelection());
            this.directoryBasedExecuter.setCreateCompareImage(this.beforeafter.getSelection());
        }

        public void afterConvert() {
        }

        private void createLabel(Composite composite, String label) {
            Label label1 = new Label(composite, 0);
            label1.setText(label);
        }

        public boolean isCanConvert() {
            String exePath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("greycstoration_path");
            if (!new File(exePath).exists()) {
                return false;
            }
            return super.isCanConvert();
        }

        public void cancelConvert() {
            this.directoryBasedExecuter.cancel();
        }

        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public class PreSetUpdate
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                double alpha = (double)GreycstorationTab.this.alphaSAS.getSelection() / 10.0;
                double sigma = (double)GreycstorationTab.this.sigmaSAS.getSelection() / 10.0;
                double p = (double)GreycstorationTab.this.pSAS.getSelection() / 10.0;
                double a = (double)GreycstorationTab.this.aSAS.getSelection() / 100.0;
                int iter = GreycstorationTab.this.iterSAS.getSelection();
                int dt = GreycstorationTab.this.dtSAS.getSelection();
                String label = "Unknown -restore -alpha " + alpha + " -sigma " + sigma + " -p " + p + " -a " + a + " -iter " + iter + " -dt " + dt;
                GreycstorationTab.this.preSets.setText(label);
            }
        }

        public class PreSetChange
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
                GreycstorationTab.this.presetChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                GreycstorationTab.this.presetChanged();
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
            }

            public void startConvert(File file) {
            }

            public void endConvert(File file) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:image]" + file.getAbsolutePath());
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:image]" + message + "," + file.getAbsolutePath());
            }

            public void printProcess(String line) {
                System.out.println(line);
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(GreycstorationTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

