/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.imageedit;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jp.sourceforge.akjrcp.imageedit.BufferImageCasher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class ImageListView
extends ViewPart
implements ISelectionProvider {
    public static Log log;
    public static final String ID;
    private static int thumbnailWidth;
    private static int thumbnailHeight;
    private String defaultDir = String.valueOf(System.getProperty("user.home")) + "/" + "My Documents/captures/";
    private String currentDir;
    private SelectAction selectAction = new SelectAction();
    private ImageButton currentButton;
    private String[] supprtedExtensions = new String[]{"png", "jpg", "gif", "bmp"};
    private BufferImageCasher bufferImageCasher = new BufferImageCasher();
    List listeners = new ArrayList();
    ISelection current;
    private Text directoryText;
    private Composite imageList;
    private CCombo directorySelect;
    private ScrolledComposite scrollComposite;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.imageedit.ImageListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.imageedit.ImageListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
        thumbnailWidth = 120;
        thumbnailHeight = 60;
    }

    public static Image createThumbnail(Image img) {
        Image retImage = new Image(null, thumbnailWidth, thumbnailHeight);
        GC gc = new GC((Drawable)retImage);
        gc.setBackground(new Color(null, 255, 255, 255));
        gc.fillRectangle(0, 0, retImage.getBounds().width, retImage.getBounds().height);
        if (img.getBounds().width > retImage.getBounds().width || img.getBounds().height > retImage.getBounds().height) {
            int overw = img.getBounds().width - retImage.getBounds().width;
            int overh = img.getBounds().height - retImage.getBounds().height;
            double ratio = 0.0;
            ratio = overw > overh ? (double)retImage.getBounds().width / (double)img.getBounds().width : (double)retImage.getBounds().height / (double)img.getBounds().height;
            int dw = (int)((double)img.getBounds().width * ratio);
            int dh = (int)((double)img.getBounds().height * ratio);
            int cx = (retImage.getBounds().width - dw) / 2;
            int cy = (retImage.getBounds().height - dh) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, dw, dh);
        } else {
            int cx = (retImage.getBounds().width - img.getBounds().width) / 2;
            int cy = (retImage.getBounds().height - img.getBounds().height) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, img.getBounds().width, img.getBounds().height);
        }
        gc.dispose();
        return retImage;
    }

    public ImageButton makeThumbnailButton(Composite parent, File file) {
        Image base = new Image(null, file.getAbsolutePath());
        Image thumb = ImageListView.createThumbnail(base);
        base.dispose();
        this.bufferImageCasher.putImage(thumb, file.getAbsolutePath());
        ImageButton bt = new ImageButton(parent, 0, thumb.getBounds().width, thumb.getBounds().height);
        thumb.dispose();
        bt.setImageName(file.getAbsolutePath());
        bt.setToolTipText(file.getName());
        bt.addSelectionListener(this.selectAction);
        log.info((Object)bt.getBounds());
        return bt;
    }

    public void doOpen() {
        DirectoryDialog dialog = new DirectoryDialog(this.getSite().getShell());
        String path = dialog.open();
        if (path != null) {
            this.doOpen(path);
        }
    }

    private boolean isSupportedImage(String name) {
        int i = 0;
        while (i < this.supprtedExtensions.length) {
            if (name.toLowerCase().endsWith("." + this.supprtedExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void doOpen(String path) {
        log.info((Object)("open:" + path));
        this.currentDir = path;
        this.directoryText.setText(path);
        this.bufferImageCasher.clear();
        if (this.directorySelect.getItemCount() > 2) {
            this.directorySelect.remove(2, this.directorySelect.getItemCount() - 1);
        }
        Control[] controls = this.imageList.getChildren();
        System.out.println(controls.length);
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        this.imageList.update();
        int index = 0;
        File dir = new File(path);
        File[] list = dir.listFiles();
        int i2 = 0;
        while (i2 < list.length) {
            if (list[i2].isDirectory()) {
                this.directorySelect.add(list[i2].getName());
            } else if (this.isSupportedImage(list[i2].getName())) {
                try {
                    log.info((Object)list[i2]);
                    this.makeThumbnailButton(this.imageList, list[i2]);
                    this.imageList.pack();
                    this.imageList.update();
                    log.info((Object)("index=" + ++index));
                }
                catch (Exception exception) {}
            }
            ++i2;
        }
        this.imageList.layout();
    }

    public void createPartControl(Composite root) {
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        root.setLayout((Layout)new GridLayout(1, false));
        this.directoryText = new Text(root, 8);
        this.directoryText.setText("");
        GridData data1 = new GridData(768);
        this.directoryText.setLayoutData((Object)data1);
        Button browse = new Button(root, 0);
        browse.setText("open");
        browse.addSelectionListener((SelectionListener)new OpenAction());
        this.directorySelect = new CCombo(root, 8);
        this.directorySelect.add("");
        this.directorySelect.add("open parent");
        this.directorySelect.addSelectionListener((SelectionListener)new DirectoryChange());
        this.scrollComposite = new ScrolledComposite(root, 512);
        this.scrollComposite.getVerticalBar().setIncrement(10);
        this.scrollComposite.setLayoutData((Object)new GridData(1808));
        this.imageList = new Composite((Composite)this.scrollComposite, 0);
        this.imageList.setLayout((Layout)new GridLayout(1, false));
        this.doOpen(this.defaultDir);
        this.imageList.setSize(this.imageList.computeSize(-1, -1));
        this.scrollComposite.setContent((Control)this.imageList);
    }

    public void setFocus() {
        this.scrollComposite.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.current;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        log.info((Object)"setSelection");
        this.current = selection;
        ListIterator iterator = this.listeners.listIterator();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        while (iterator.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)iterator.next();
            listener.selectionChanged(event);
        }
    }

    public class ImageButton
    extends Canvas
    implements PaintListener,
    MouseListener {
        String imageName;
        int imageWidth;
        int imageHeight;
        private boolean selected;
        private List selectionListeners = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectionListener(SelectionListener listener) {
            ImageButton imageButton = this;
            synchronized (imageButton) {
                this.selectionListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectionListener(SelectionListener listener) {
            ImageButton imageButton = this;
            synchronized (imageButton) {
                this.selectionListeners.remove(listener);
            }
        }

        public ImageButton(Composite arg0, int arg1, int width, int height) {
            super(arg0, arg1);
            this.addPaintListener(this);
            this.imageWidth = width;
            this.imageHeight = height;
            this.setSize(width, height);
            this.addMouseListener(this);
        }

        public void paintControl(PaintEvent e) {
            Image image = ImageListView.this.bufferImageCasher.getImage(this.imageName);
            if (image != null) {
                e.gc.drawImage(image, 0, 0);
                image.dispose();
            }
            e.gc.setForeground(new Color(null, 128, 128, 128));
            if (this.selected) {
                e.gc.setLineWidth(6);
            } else {
                e.gc.setLineWidth(1);
            }
            e.gc.drawRectangle(0, 0, this.getClientArea().width - 1, this.getClientArea().height - 1);
        }

        public Point computeSize(int whint, int hhint, boolean bool) {
            return new Point(this.imageWidth, this.imageHeight);
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Iterator iterator = this.selectionListeners.iterator();
            while (iterator.hasNext()) {
                SelectionListener listener = (SelectionListener)iterator.next();
                Event ev = new Event();
                ev.widget = this;
                SelectionEvent event = new SelectionEvent(ev);
                listener.widgetSelected(event);
            }
            log.info((Object)"mousedown");
            this.setFocus();
        }

        public void mouseUp(MouseEvent e) {
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    public class DirectoryChange
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CCombo combo = (CCombo)e.getSource();
            int index = combo.getSelectionIndex();
            if (index >= 0) {
                if (index == 0) {
                    ImageListView.this.doOpen(new File(ImageListView.this.currentDir).getAbsolutePath());
                } else if (index == 1) {
                    ImageListView.this.doOpen(new File(ImageListView.this.currentDir).getParent());
                } else {
                    ImageListView.this.doOpen(new File(ImageListView.this.currentDir, combo.getItem(combo.getSelectionIndex())).getAbsolutePath());
                }
            }
            ImageListView.this.scrollComposite.setFocus();
        }
    }

    public class SelectAction
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ImageListView.this.currentButton != null && !ImageListView.this.currentButton.isDisposed()) {
                ImageListView.this.currentButton.setSelected(false);
                ImageListView.this.currentButton.redraw();
            }
            ImageButton bt = (ImageButton)((Object)e.getSource());
            bt.setSelected(true);
            bt.redraw();
            ImageListView.this.currentButton = bt;
            File file = new File(ImageListView.this.currentDir, bt.getToolTipText());
            ImageListView.this.setSelection(new SelectFile(file));
        }
    }

    public class OpenAction
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ImageListView.this.doOpen();
        }
    }

    public class SelectFile
    implements ISelection {
        private File file;

        public SelectFile(File file) {
            this.file = file;
        }

        public boolean isEmpty() {
            return false;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }
}

