/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.imageedit.clipboard;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.imageedit.clipboard.ClipboardUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoClipboardSave
extends Thread {
    public static Log log;
    public static final String IMAGE_JPEG = "jpg";
    public static final String IMAGE_PNG = "png";
    private String fileType = "png";
    private String prefix = "";
    int count = 1;
    int figure = 4;
    private int waitTime = 50;
    private int sleepTime = 200;
    private static int[] oldPixels;
    private String saveDirectory = String.valueOf(System.getProperty("user.home")) + "/" + "My Documents/";
    private boolean saving;
    private List imageReferenceList = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.imageedit.clipboard.AutoClipboardSave");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void startSave() {
        if (!this.saving) {
            log.info((Object)"start");
            this.saving = true;
            this.start();
        }
    }

    public void stopSave() {
        log.info((Object)"stop");
        this.saving = false;
    }

    private File nextFile() {
        File file = null;
        do {
            String path = String.valueOf(this.saveDirectory) + this.prefix + this.toCounter(this.count) + "." + this.fileType;
            file = new File(path);
            ++this.count;
        } while (file.exists());
        return file;
    }

    public void run() {
        log.info((Object)"run");
        int gcindex = 0;
        int gctarget = 50;
        while (this.saving) {
            long startime = System.currentTimeMillis();
            BufferedImage img = ClipboardUtil.getClipboard();
            if (img != null) {
                try {
                    WritableRaster newRaster = img.getRaster();
                    int[] newPixels = newRaster.getPixels(0, 0, newRaster.getWidth(), newRaster.getHeight(), (int[])null);
                    if (oldPixels == null || !ClipboardUtil.isSameImage(oldPixels, newPixels)) {
                        long checkend = System.currentTimeMillis();
                        log.info((Object)("time:" + (checkend - startime)));
                        File file = this.nextFile();
                        log.info((Object)("save:" + file));
                        new ImageSaver(file, img).start();
                        oldPixels = null;
                        oldPixels = newPixels;
                        continue;
                    }
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            oldPixels = null;
            try {
                if (++gcindex == gctarget) {
                    System.gc();
                    gcindex = 0;
                }
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.info((Object)"done");
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public String getSaveDirectory() {
        return this.saveDirectory;
    }

    public void setSaveDirectory(String baseDirectory) {
        this.saveDirectory = baseDirectory;
    }

    private String toCounter(int index) {
        String v = "" + index;
        while (v.length() < this.figure) {
            v = "0" + v;
        }
        return v;
    }

    public int getFigure() {
        return this.figure;
    }

    public void setFigure(int figure) {
        this.figure = figure;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public class ImageReference {
        private boolean availableDispose;
        private Image image;

        public boolean isAvailableDispose() {
            return this.availableDispose;
        }

        public void setAvailableDispose(boolean availableDispose) {
            this.availableDispose = availableDispose;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }
    }

    public class ImageSaver
    extends Thread {
        private File outputFile;
        private BufferedImage image;

        public ImageSaver(File outputFile, BufferedImage image) {
            this.outputFile = outputFile;
            this.image = image;
        }

        public void run() {
            try {
                if (AutoClipboardSave.this.fileType.equals(AutoClipboardSave.IMAGE_PNG)) {
                    ImageIO.write((RenderedImage)this.image, AutoClipboardSave.IMAGE_PNG, this.outputFile);
                } else if (AutoClipboardSave.this.fileType.equals(AutoClipboardSave.IMAGE_JPEG)) {
                    ImageIO.write((RenderedImage)this.image, "jpeg", this.outputFile);
                }
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
            }
            this.image = null;
        }
    }
}

