/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.dropsomething.ProgressAndList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class DropsomethingTab
extends Composite
implements FilenameFilter {
    public static Log log;
    private ProgressAndList plist;
    private StackLayout stack = new StackLayout();
    private Composite controler;
    private boolean canConvert;
    private boolean cancel;
    private String preferenceKey;
    private int progressMaxBytes;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.dropsomething.DropsomethingTab");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public DropsomethingTab(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)this.stack);
        this.plist = new ProgressAndList(this, 0);
        this.plist.getSimpleFileList().setInput(new ArrayList());
        this.plist.getCancelButton().addSelectionListener((SelectionListener)new CancelAction());
        this.plist.setFilenameFilter(this);
        this.controler = this.createControls(this);
        this.stack.topControl = this.controler;
        new DropMonitor(this.controler);
    }

    public void progressBytes(int kByte) {
        if (kByte == 0) {
            return;
        }
        int p = kByte * 100 / this.progressMaxBytes;
        this.setProgress(p);
    }

    public void setProgress(int persent) {
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetProgress(persent));
    }

    public abstract Composite createControls(Composite var1);

    public void startConvert() {
        this.cancel = false;
        this.plist.getSimpleFileList().getTable().select(0);
        this.initConvert();
        this.beforeConvert();
        Thread t = new Thread(new ConvertFile());
        t.start();
    }

    public abstract void inconvert(File var1);

    public abstract void beforeConvert();

    public abstract void afterConvert();

    public abstract void cancelConvert();

    public void addDragAndDropFile(String path) {
        if (this.stack.topControl == this.controler) {
            this.stack.topControl = this.plist;
            this.plist.addFile(path);
            this.layout();
            this.startConvert();
        } else {
            this.plist.addFile(path);
            this.layout();
        }
    }

    public boolean isCanConvert() {
        return this.canConvert;
    }

    public void setCanConvert(boolean canConvert) {
        this.canConvert = canConvert;
    }

    public int compare(Object object) {
        boolean cfr_ignored_0 = object instanceof DropsomethingTab;
        return -1;
    }

    public void initConvert() {
    }

    public void releaseConvert() {
    }

    public boolean accept(File parent, String name) {
        return true;
    }

    public int getProgressMaxBytes() {
        return this.progressMaxBytes;
    }

    public void setProgressMaxBytes(int progressMaxBytes) {
        this.progressMaxBytes = progressMaxBytes;
    }

    public class SetProgress
    implements Runnable {
        private int value;

        public SetProgress(int value) {
            this.value = value;
        }

        public void run() {
            DropsomethingTab.this.plist.getProgressBar().setSelection(this.value);
        }
    }

    public class CancelAction
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            DropsomethingTab.this.cancel = true;
            DropsomethingTab.this.cancelConvert();
            DropsomethingTab.this.plist.getSimpleFileList().removeFiles();
            DropsomethingTab.this.releaseConvert();
            ((DropsomethingTab)DropsomethingTab.this).stack.topControl = DropsomethingTab.this.controler;
            DropsomethingTab.this.layout();
            DropsomethingTab.this.redraw();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ConvertFile
    implements Runnable {
        public void run() {
            while (true) {
                int size;
                if ((size = DropsomethingTab.this.plist.getSimpleFileList().countFiles()) == 0 || DropsomethingTab.this.cancel) break;
                File file = DropsomethingTab.this.plist.getSimpleFileList().getFileList()[0];
                DropsomethingTab.this.inconvert(file);
                DropsomethingTab.this.plist.getSimpleFileList().popFile();
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateTable());
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new FinishConvert());
        }
    }

    public class FinishConvert
    implements Runnable {
        public void run() {
            log.info((Object)"finish converting");
            DropsomethingTab.this.afterConvert();
            DropsomethingTab.this.releaseConvert();
            ((DropsomethingTab)DropsomethingTab.this).stack.topControl = DropsomethingTab.this.controler;
            DropsomethingTab.this.layout();
            DropsomethingTab.this.redraw();
        }
    }

    public class UpdateTable
    implements Runnable {
        public void run() {
            DropsomethingTab.this.plist.getSimpleFileList().refresh(true);
            if (DropsomethingTab.this.plist.getSimpleFileList().countFiles() > 0) {
                DropsomethingTab.this.plist.getSimpleFileList().getTable().select(0);
            }
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public DropMonitor(Composite controler) {
            Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
            int operations = 3;
            DropTarget target2 = new DropTarget((Control)controler, operations);
            target2.setTransfer(types);
            target2.addDropListener((DropTargetListener)this);
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (DropsomethingTab.this.isCanConvert()) {
                String[] files = (String[])event.data;
                int i = 0;
                while (i < files.length) {
                    DropsomethingTab.this.addDragAndDropFile(files[i]);
                    ++i;
                }
            }
        }
    }
}

