/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMpegExecuter {
    public static Log log;
    private boolean useAvisynth;
    private String[] ignoreAvisynthExtensions = new String[]{"mpg", "mp3", "flv", "ac3", "mp2", "m2a", "aac", "ogg", "wav", "vob", "wmv", "wma"};
    private DirectryBasedExecuterListener executeListener;
    private String exportDir;
    private boolean sameDirectory;
    private boolean backup;
    private FFMpegPreference ffmpegPreference = new FFMpegPreference();
    private Process process;
    private boolean cancelling;
    private File rootFile;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public int getGuessSize() {
        return this.ffmpegPreference.getGuessSize();
    }

    public void execute(File[] files) {
        if (this.executeListener != null) {
            this.executeListener.beforeConvert();
        }
        int i = 0;
        while (i < files.length) {
            this.rootFile = files[i];
            this.execute(files[i]);
            ++i;
        }
        if (this.executeListener != null) {
            this.executeListener.afterConvert();
        }
    }

    private void execute(File file) {
        if (file.isDirectory()) {
            if (this.cancelling) {
                log.info((Object)("cancel " + file));
                return;
            }
            String[] list = file.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    this.execute(new File(file, list[i]));
                    ++i;
                }
            }
        } else {
            this.inExecute(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        log.info((Object)"called cancel");
        FFMpegExecuter fFMpegExecuter = this;
        synchronized (fFMpegExecuter) {
            System.out.println("cancell:" + System.currentTimeMillis());
            this.cancelling = true;
        }
        if (this.process != null) {
            this.process.destroy();
            log.info((Object)("maybe destroyed:" + this.process));
        }
    }

    private File toOutputFile(File file) {
        String outputPath;
        String outputDir = file.getParent();
        if (!this.sameDirectory) {
            outputDir = this.exportDir;
            String remain = PathnameUtils.getRemainPath(this.rootFile.getParent(), PathnameUtils.changeExtension(file.getAbsolutePath(), this.ffmpegPreference.getExtension()));
            System.out.println("remain:" + remain);
            outputPath = String.valueOf(outputDir) + "\\" + remain;
        } else {
            outputPath = String.valueOf(outputDir) + "\\" + PathnameUtils.changeExtension(file.getName(), this.ffmpegPreference.getExtension());
        }
        log.info((Object)("save:" + outputPath));
        if (file.getAbsolutePath().equals(outputPath) && this.executeListener != null) {
            this.executeListener.faildConvert(file, "input and output is same");
            return null;
        }
        boolean overwrite = false;
        File tmpOutput = new File(outputPath);
        if (tmpOutput.exists() && !tmpOutput.canWrite() && this.executeListener != null) {
            this.executeListener.faildConvert(file, "file can't overwrite");
            return null;
        }
        if (!this.backup) {
            if (tmpOutput.exists() && this.executeListener != null && !(overwrite = this.executeListener.askOverwrite(tmpOutput))) {
                if (this.executeListener != null) {
                    this.executeListener.faildConvert(file, "file don't overwrite");
                }
                return null;
            }
        } else {
            boolean r;
            File backUpFile = FFMpegExecuter.makeBackupFile(tmpOutput, "bk");
            if (backUpFile.exists()) {
                r = backUpFile.delete();
                if (!r) {
                    log.warn((Object)("delete faild " + backUpFile));
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "can't make backupfile " + backUpFile);
                    }
                    return null;
                }
                log.info((Object)("delete success " + backUpFile));
            }
            if (tmpOutput.exists()) {
                r = tmpOutput.renameTo(backUpFile);
                if (!r) {
                    log.warn((Object)("backup faild " + tmpOutput));
                    if (this.executeListener != null) {
                        this.executeListener.faildConvert(file, "can't make backupfile " + tmpOutput);
                    }
                    return null;
                }
                log.info((Object)("backup success " + tmpOutput));
            }
        }
        return tmpOutput;
    }

    public static File makeBackupFile(File file, String addextension) {
        int count = 1;
        File bkfile = new File(file.getParentFile(), String.valueOf(file.getName()) + "." + addextension);
        while (bkfile.exists()) {
            bkfile = new File(file.getParentFile(), String.valueOf(file.getName()) + "." + "(" + count + ")." + addextension);
            ++count;
        }
        return bkfile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void inExecute(File file) {
        if (this.cancelling) {
            log.info((Object)("cancel " + file));
            return;
        }
        File tmpOutput = this.toOutputFile(file);
        if (tmpOutput == null) {
            return;
        }
        File input = null;
        File avs = null;
        boolean avsAvailable = false;
        if (this.ffmpegPreference != null) {
            avsAvailable = FFMpegUtils.isAvisynthAvailable(new File(this.ffmpegPreference.getFfmpegPath()));
        }
        int i = 0;
        while (i < this.ignoreAvisynthExtensions.length) {
            if (file.getName().toLowerCase().endsWith(this.ignoreAvisynthExtensions[i])) {
                this.useAvisynth = false;
                log.info((Object)("dont use avisynth for " + this.ignoreAvisynthExtensions[i]));
                break;
            }
            ++i;
        }
        log.info((Object)(String.valueOf(this.useAvisynth) + "," + avsAvailable));
        if (this.useAvisynth && avsAvailable) {
            try {
                avs = File.createTempFile("avs", ".avs");
                FileWriter writer = new FileWriter(avs);
                writer.write(FFMpegUtils.toAVSScript(file.getAbsolutePath()));
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        input = file;
        log.info((Object)("avs:" + avs));
        String avsPath = null;
        if (avs != null) {
            avsPath = avs.getAbsolutePath();
        }
        log.info((Object)("avsPath:" + avsPath));
        if (this.process != null) {
            this.process.destroy();
        }
        this.process = null;
        if (this.cancelling) {
            log.info((Object)("cancel " + file));
            return;
        }
        tmpOutput.getParentFile().mkdirs();
        try {
            block29: {
                block28: {
                    try {
                        if (!this.ffmpegPreference.isTwoPassEncode()) {
                            String[] commands = this.ffmpegPreference.toCommand(input.getAbsolutePath(), avsPath, tmpOutput.getAbsolutePath());
                            if (commands == null) {
                                log.warn((Object)"null command");
                                break block28;
                            }
                            if (this.executeListener != null) {
                                this.executeListener.startConvert(file);
                            }
                            Runtime runtime = Runtime.getRuntime();
                            ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
                            try {
                                printer.printOutput(FFMpegExecuter.toDebugArray(commands));
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            log.info((Object)("start process:" + this.process + "," + ArrayUtils.toString((Object)commands)));
                            this.process = runtime.exec(commands);
                            System.out.println("process:" + System.currentTimeMillis() + "," + this.cancelling);
                            ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
                            monitor.startMonitor();
                            try {
                                if (!this.cancelling) {
                                    this.process.waitFor();
                                    break block29;
                                }
                                log.info((Object)("finally cancel " + file));
                                break block28;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                break block29;
                            }
                        }
                        this.twoPassEncode(input, avsPath, tmpOutput, this.ffmpegPreference);
                        break block29;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        this.process.destroy();
                        if (this.executeListener == null) break block28;
                        this.executeListener.faildConvert(file, e1.getMessage());
                    }
                }
                Object var12_12 = null;
                if (avs != null) {
                    avs.delete();
                }
                return;
            }
            Object var12_14 = null;
            if (avs != null) {
                avs.delete();
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (avs != null) {
                avs.delete();
            }
            throw throwable;
        }
        if (this.executeListener != null) {
            this.executeListener.endConvert(file);
        }
        this.process = null;
    }

    public void twoPassEncode(File input, String avsPath, File tmpOutput, FFMpegPreference preferences) throws IOException {
        String[] commands2pass;
        boolean deleteOnePass;
        File onePassFile = new File(tmpOutput.getParent(), "tmp_" + tmpOutput.getName());
        String[] commands1pass = preferences.toCommandPass1(input.getAbsolutePath(), avsPath, String.valueOf(tmpOutput.getAbsolutePath()) + "_log", onePassFile.getAbsolutePath());
        if (commands1pass == null) {
            log.warn((Object)"null command");
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
        try {
            printer.printOutput(FFMpegExecuter.toDebugArray(commands1pass));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        log.info((Object)("start process:" + this.process + "," + ArrayUtils.toString((Object)commands1pass)));
        this.process = runtime.exec(commands1pass);
        ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
        monitor.startMonitor();
        try {
            if (this.cancelling) {
                log.info((Object)("finally cancel " + input));
                return;
            }
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.cancelling) {
            log.info((Object)("canceled " + input));
        }
        if (!(deleteOnePass = onePassFile.delete())) {
            log.warn((Object)("delete one pass file failed:" + onePassFile.getAbsolutePath()));
        }
        if ((commands2pass = preferences.toCommandPass2(input.getAbsolutePath(), avsPath, String.valueOf(tmpOutput.getAbsolutePath()) + "_log", tmpOutput.getAbsolutePath())) == null) {
            log.warn((Object)"null command");
            return;
        }
        try {
            printer.printOutput(FFMpegExecuter.toDebugArray(commands2pass));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        log.info((Object)("start process:" + this.process + "," + ArrayUtils.toString((Object)commands1pass)));
        if (!this.cancelling) {
            this.process = runtime.exec(commands2pass);
        }
        ProcessMonitor monitor2 = new ProcessMonitor(this.process, printer);
        monitor2.startMonitor();
        try {
            if (this.cancelling) {
                log.info((Object)("finally cancel " + input));
                return;
            }
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public DirectryBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(DirectryBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public FFMpegPreference getFfmpegPreference() {
        return this.ffmpegPreference;
    }

    public void setFfmpegPreference(FFMpegPreference ffmpegPreference) {
        this.ffmpegPreference = ffmpegPreference;
    }

    public String[] getIgnoreAvisynthExtensions() {
        return this.ignoreAvisynthExtensions;
    }

    public void setIgnoreAvisynthExtensions(String[] ignoreAvisynthExtensions) {
        this.ignoreAvisynthExtensions = ignoreAvisynthExtensions;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setSameDirectory(boolean sameDirectory) {
        this.sameDirectory = sameDirectory;
    }

    public boolean isUseAvisynth() {
        return this.useAvisynth;
    }

    public void setUseAvisynth(boolean useAvisynth) {
        this.useAvisynth = useAvisynth;
    }

    public class TestMonitor
    implements DirectryBasedExecuterListener {
        public void beforeConvert() {
        }

        public void afterConvert() {
        }

        public void startConvert(File file) {
        }

        public void endConvert(File file) {
        }

        public void faildConvert(File file, String message) {
            System.out.println("faild:" + file);
        }

        public void printProcess(String line) {
        }

        public boolean askOverwrite(File output) {
            return false;
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (FFMpegExecuter.this.executeListener != null) {
                FFMpegExecuter.this.executeListener.printProcess(line);
            }
            log.debug((Object)line);
            if (line.indexOf("Unsupported video codec") != -1) {
                throw new IOException("Unsupported video codec");
            }
        }
    }
}

