/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.basic;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.FilePlayer;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.basic.FLVDirectoryList;
import jp.sourceforge.akjrcp.flvtools.basic.FLVUtil;
import jp.sourceforge.akjrcp.flvtools.basic.OpenDirectable;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class SimpleView
extends ViewPart
implements OpenDirectable {
    public static Log log;
    public static final String ID;
    private FLVDirectoryList directoryList;
    private Button bt1;
    private Button convertButton;
    private CCombo typeCombo;
    private Text pathLabel;
    private Action doubleClickAction;
    public File[] convertingFile;
    IProgressMonitor convertMonitor;
    private String extension;
    public int CONVERT_TASK = 20;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.basic.SimpleView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.basic.SimpleView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
    }

    public void openDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        if (path != null) {
            this.setDirectory(path);
        }
    }

    private void setDirectory(String path) {
        this.directoryList.setBaseDirectory(new File(path));
        this.directoryList.updateDirectory();
        this.directoryList.setlectAllUnknown();
        this.pathLabel.setText(path);
    }

    public static String findBaseDir() {
        String paths = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.paths");
        String[] path = paths.split(";");
        String baseDir = path[0];
        if (baseDir == null || baseDir.equals("")) {
            baseDir = System.getProperty("user.dir");
        } else if (!new File(baseDir).exists()) {
            baseDir = System.getProperty("user.dir");
        }
        return baseDir;
    }

    public void createPartControl(Composite parent) {
        Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new SettingMonitor());
        Composite cp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, true);
        cp.setLayout((Layout)layout);
        this.pathLabel = new Text(cp, 12);
        GridData data0 = new GridData(768);
        data0.horizontalSpan = 3;
        this.pathLabel.setLayoutData((Object)data0);
        this.directoryList = new FLVDirectoryList(cp, 770);
        this.directoryList.setFilenameFilter(new FLVFilter());
        log.info((Object)this.directoryList.getContentProvider());
        this.directoryList.setInput(this.getViewSite());
        String baseDir = SimpleView.findBaseDir();
        this.pathLabel.setText(baseDir);
        log.debug((Object)baseDir);
        this.directoryList.setBaseDirectory(new File(baseDir));
        this.directoryList.updateDirectory();
        this.directoryList.setlectAllUnknown();
        GridData data1 = new GridData(1808);
        data1.horizontalSpan = 3;
        this.directoryList.getControl().setLayoutData((Object)data1);
        this.bt1 = new Button(cp, 0);
        this.bt1.setText(Messages.getString("rename_flv"));
        this.bt1.addSelectionListener((SelectionListener)new RenameAction());
        this.typeCombo = new CCombo(cp, 0);
        this.typeCombo.add("mpg");
        this.typeCombo.add("avi");
        this.typeCombo.add("wmv");
        this.typeCombo.add("mp3");
        this.typeCombo.add("wav");
        this.typeCombo.add("jpg");
        this.typeCombo.add("png");
        this.typeCombo.add("gif");
        this.typeCombo.select(0);
        GridData data4 = new GridData();
        data4.horizontalAlignment = 131072;
        this.typeCombo.setLayoutData((Object)data4);
        this.convertButton = new Button(cp, 0);
        this.convertButton.setText(Messages.getString("convert"));
        this.convertButton.addSelectionListener((SelectionListener)new FFMpegAction());
        GridData data2 = new GridData(768);
        this.bt1.setLayoutData((Object)data2);
        GridData data3 = new GridData(768);
        this.convertButton.setLayoutData((Object)data3);
        this.convertButtonUpdate();
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SimpleView.this.directoryList.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                File file = (File)obj;
                if (file.getName().toLowerCase().endsWith("flv")) {
                    FilePlayer.play(file);
                }
            }
        };
        this.hookDoubleClickAction();
    }

    public void convertButtonUpdate() {
        String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
        if (ffmpegPath.equals("") || !new File(ffmpegPath).exists()) {
            this.convertButton.setEnabled(false);
            this.directoryList.getTable().setToolTipText(Messages.getString("convert_tooltip"));
            this.typeCombo.setToolTipText(Messages.getString("convert_tooltip"));
        } else {
            this.convertButton.setEnabled(true);
            this.directoryList.getTable().setToolTipText("");
            this.typeCombo.setToolTipText("");
        }
    }

    private void hookDoubleClickAction() {
        this.directoryList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SimpleView.this.doubleClickAction.run();
            }
        });
    }

    public static boolean isNumberdName(String key) {
        String regex = ".*\\([0-9]+\\)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(key);
        return matcher.matches();
    }

    public void setFocus() {
        this.directoryList.getControl().setFocus();
    }

    public class FLVFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            if (name.indexOf(".") != -1 && !name.toLowerCase().endsWith(".flv")) {
                return false;
            }
            File tmp = new File(dir, name);
            if (tmp.isHidden()) {
                return false;
            }
            if (tmp.isDirectory()) {
                return false;
            }
            if (tmp.length() < 10240L) {
                return false;
            }
            if (name.equals("NTLDR")) {
                return false;
            }
            if (name.equals("~")) {
                return false;
            }
            boolean result = FLVUtil.isFLVFileFormat(tmp);
            log.info((Object)(String.valueOf(result) + " " + tmp.getName()));
            return result;
        }
    }

    public class SettingMonitor
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            log.info((Object)event.getProperty());
            if (event.getProperty().equals("explorer.paths")) {
                String paths = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.paths");
                String[] path = paths.split(";");
                String baseDir = path[0];
                SimpleView.this.setDirectory(baseDir);
            } else if (event.getProperty().equals("ffmpeg_path")) {
                SimpleView.this.convertButtonUpdate();
            }
        }
    }

    public class RenameAction
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            File[] file = SimpleView.this.directoryList.getSelectionFiles();
            int i = 0;
            while (i < file.length) {
                if (this.isValidFLV(file[i])) {
                    boolean result = FileNameUtils.changeExtension(file[i], "flv");
                    log.warn((Object)(String.valueOf(result) + "," + file[i].getName()));
                }
                ++i;
            }
            SimpleView.this.directoryList.updateDirectory();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public boolean isValidFLV(File file) {
            return file.isFile() && file.getName().indexOf(".") == -1;
        }
    }

    public class FFMpegAction
    implements SelectionListener {
        public File[] filterConvertingFile() {
            ArrayList<File> array = new ArrayList<File>();
            File[] list = SimpleView.this.directoryList.getSelectionFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].getName().toLowerCase().endsWith(".flv")) {
                    array.add(list[i]);
                }
                ++i;
            }
            return array.toArray(new File[0]);
        }

        public void widgetSelected(SelectionEvent e) {
            SimpleView.this.convertButton.setEnabled(false);
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            SimpleView.this.convertMonitor = workbenchWindow.getStatusLineManager().getProgressMonitor();
            SimpleView.this.convertingFile = this.filterConvertingFile();
            SimpleView.this.convertMonitor.beginTask(Messages.getString("converting"), SimpleView.this.convertingFile.length);
            SimpleView.this.extension = SimpleView.this.typeCombo.getText();
            new FFMpegExecuter().start();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class FFMpegExecuter
    extends Thread {
        public void debugArray(String[] array) {
            String v = "";
            int i = 0;
            while (i < array.length) {
                v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
                ++i;
            }
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(v) + "\n");
        }

        public boolean isImageExport(String extension) {
            return extension.equals("png") || extension.equals("jpg") || extension.equals("gif");
        }

        public void run() {
            int i = 0;
            while (i < SimpleView.this.convertingFile.length) {
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorStartSubTask(SimpleView.this.convertingFile[i].getName()));
                ProcessMonitor monitor = null;
                Runtime runtime = Runtime.getRuntime();
                ArrayList<String> param = new ArrayList<String>();
                IPreferenceStore store = Akj_betasPlugin.getDefault().getPreferenceStore();
                String ffmpegPath = store.getString("ffmpeg_path");
                param.add(ffmpegPath);
                param.add("-i");
                param.add(SimpleView.this.convertingFile[i].getAbsolutePath());
                if (this.isImageExport(SimpleView.this.extension)) {
                    param.add("-f");
                    param.add("image2");
                    param.add("-ss");
                    param.add(store.getString("image_time"));
                    param.add("-vframes");
                    param.add("1");
                } else {
                    param.add("-b");
                    param.add(store.getInt("video_bitrate") + "k");
                    param.add("-ab");
                    param.add(store.getInt("audio_bitrate") + "k");
                    param.add("-ar");
                    param.add("" + store.getInt("export.wave.samplerate"));
                    param.add("-ac");
                    param.add("" + store.getInt("export.wave.channel"));
                    param.add("-r");
                    param.add(store.getString("video_fps"));
                    String optionString = store.getString("ffmpeg_option");
                    if (SimpleView.this.extension.equals("avi")) {
                        param.add("-vcodec");
                        String avicodec = store.getString("avisetting.video");
                        param.add(avicodec);
                        if (avicodec.equals("xvid")) {
                            param.add("-vtag");
                            param.add("DIVX");
                        }
                        param.add("-acodec");
                        param.add(store.getString("avisetting.audio"));
                    } else if (SimpleView.this.extension.equals("wmv")) {
                        param.add("-vcodec");
                        param.add(store.getString("wmvsetting.video"));
                        param.add("-acodec");
                        param.add(store.getString("wmvsetting.audio"));
                    } else if (SimpleView.this.extension.equals("mpg")) {
                        param.add("-vcodec");
                        param.add(store.getString("mpegsetting.video"));
                        param.add("-acodec");
                        param.add(store.getString("mpegsetting.audio"));
                        if (store.getString("mpegsetting.mpeg_type").equals("mpeg_type_cbr")) {
                            param.add("-maxrate");
                            param.add(store.getInt("video_bitrate") + "k");
                            param.add("-minrate");
                            param.add(store.getInt("video_bitrate") + "k");
                            param.add("-bufsize");
                            param.add("128k");
                        }
                    }
                    String[] options = optionString.split(" ");
                    int j = 0;
                    while (j < options.length) {
                        param.add(options[j]);
                        ++j;
                    }
                }
                param.add(FileNameUtils.getChangedExtensionName(SimpleView.this.convertingFile[i], SimpleView.this.extension));
                try {
                    String[] arg = param.toArray(new String[0]);
                    this.debugArray(arg);
                    Process p = runtime.exec(arg);
                    monitor = new ProcessMonitor(p, Akj_betasPlugin.getDefault().getProcessPrinter());
                    monitor.startMonitor();
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                monitor.stop();
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorProcess());
                ++i;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorDone());
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new FinishAction());
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new EnableControl((Control)SimpleView.this.convertButton));
        }
    }

    public class ConvertMonitorStartSubTask
    extends Thread {
        String name;

        public ConvertMonitorStartSubTask(String name) {
            this.name = name;
        }

        public void run() {
            log.warn((Object)this.name);
            SimpleView.this.convertMonitor.subTask(this.name);
        }
    }

    public class ConvertMonitorProcess
    extends Thread {
        public void run() {
            SimpleView.this.convertMonitor.worked(1);
        }
    }

    public class FinishAction
    extends Thread {
        public void run() {
            SimpleView.this.directoryList.updateDirectory();
        }
    }

    public class ConvertMonitorDone
    extends Thread {
        public void run() {
            SimpleView.this.convertMonitor.done();
        }
    }

    public class EnableControl
    extends Thread {
        Control composite;

        public EnableControl(Control cp) {
            this.composite = cp;
        }

        public void run() {
            this.composite.setEnabled(true);
        }
    }
}

