/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.imageedit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.imageedit.ImageListView;
import jp.sourceforge.akjrcp.imageedit.figures.LineFigure;
import jp.sourceforge.akjrcp.imageedit.figures.OvalFigure;
import jp.sourceforge.akjrcp.imageedit.figures.RectangleFigure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ImageEditView
extends ViewPart
implements ISelectionListener {
    public static Log log;
    public static final String ID;
    private ScrolledComposite sc;
    private ImageFigure imageFigure;
    private RectangleFigure clip;
    private FigureCanvas canvas;
    private Text baseName;
    private Spinner counter;
    public FigureMover figureMover = new FigureMover();
    private Button ovalButton;
    private Button lineButton;
    private Panel figurePanel;
    private CCombo imagePersent;
    private Button selectButton;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.imageedit.ImageEditView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.imageedit.ImageEditView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
    }

    public static BufferedImage swtImageToAwtImage(Image image) {
        ImageData data = image.getImageData();
        BufferedImage bimage = new BufferedImage(image.getBounds().width, image.getBounds().height, 2);
        WritableRaster raster = bimage.getRaster();
        int i = 0;
        while (i < image.getBounds().width) {
            int j = 0;
            while (j < image.getBounds().height) {
                int color = data.getPixel(i, j);
                int[] int_rgb = new int[]{0xFF & color, 0xFF & color >> 8, 0xFF & color >> 16, 255};
                int x = i;
                int y = j++;
                raster.setPixel(x, y, int_rgb);
            }
            ++i;
        }
        return bimage;
    }

    public void drawFiguresToGraphics2D(Graphics2D g2, boolean isSelectedArea) {
        HashMap<RenderingHints.Key, Object> renderringHints = new HashMap<RenderingHints.Key, Object>();
        renderringHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderringHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        renderringHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderringHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        renderringHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        renderringHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        renderringHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(renderringHints);
        Image image = this.imageFigure.getImage();
        BufferedImage bimage = ImageEditView.swtImageToAwtImage(image);
        int imgw = (int)((double)image.getBounds().width * this.imageFigure.getZoom());
        int imgh = (int)((double)image.getBounds().height * this.imageFigure.getZoom());
        int drawx = 0;
        int drawy = 0;
        if (isSelectedArea) {
            drawx -= this.clip.getLocation().x;
            drawy -= this.clip.getLocation().y;
        }
        g2.drawImage(bimage, drawx, drawy, imgw, imgh, null);
        Iterator iterator = this.figurePanel.getChildren().iterator();
        while (iterator.hasNext()) {
            Rectangle rect;
            Figure figure = (Figure)iterator.next();
            if (figure instanceof OvalFigure) {
                g2.setColor(new Color(255, 0, 0));
                g2.setStroke(new BasicStroke(3.0f));
                rect = figure.getClientArea();
                if (isSelectedArea) {
                    rect.x -= this.clip.getLocation().x;
                    rect.y -= this.clip.getLocation().y;
                }
                g2.drawOval(rect.x, rect.y, rect.width, rect.height);
                continue;
            }
            if (!(figure instanceof LineFigure)) continue;
            g2.setColor(new Color(255, 0, 0));
            g2.setStroke(new BasicStroke(3.0f));
            rect = figure.getClientArea();
            if (isSelectedArea) {
                rect.x -= this.clip.getLocation().x;
                rect.y -= this.clip.getLocation().y;
            }
            g2.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
        }
    }

    private File nextFile() {
        int count = this.counter.getSelection();
        File file = null;
        do {
            String path = String.valueOf(System.getProperty("user.home")) + "/" + "My Documents/My Pictures/" + this.baseName.getText() + "_" + this.toDigits(count) + "." + "png";
            file = new File(path);
            ++count;
        } while (file.exists());
        this.counter.setSelection(count);
        return file;
    }

    public String toDigits(int value) {
        String result = "" + value;
        while (result.length() < 4) {
            result = "0" + result;
        }
        return result;
    }

    public void createPartControl(Composite root) {
        this.getSite().getPage().addSelectionListener(ImageListView.ID, (ISelectionListener)this);
        root.setLayout((Layout)new GridLayout(1, false));
        Composite rootPanel = new Composite(root, 0);
        rootPanel.setLayout((Layout)new GridLayout(2, false));
        Group panel = new Group(rootPanel, 0);
        panel.setLayout((Layout)new GridLayout(6, false));
        this.ovalButton = new Button((Composite)panel, 16);
        this.ovalButton.setText("oval");
        this.ovalButton.setSelection(true);
        this.lineButton = new Button((Composite)panel, 16);
        this.lineButton.setText("line");
        this.selectButton = new Button((Composite)panel, 16);
        this.selectButton.setText("select");
        this.imagePersent = new CCombo((Composite)panel, 8);
        this.imagePersent.add("100%");
        this.imagePersent.add("50%");
        this.imagePersent.add("25%");
        int i = 90;
        while (i >= 0) {
            this.imagePersent.add(String.valueOf(i) + "%");
            i -= 10;
        }
        this.imagePersent.select(0);
        this.imagePersent.addSelectionListener((SelectionListener)new PersetnChange());
        Group saveGroup = new Group(rootPanel, 0);
        saveGroup.setLayout((Layout)new GridLayout(4, true));
        saveGroup.setText("Save");
        this.baseName = new Text((Composite)saveGroup, 0);
        GridData baseNameData = new GridData();
        baseNameData.minimumWidth = 300;
        this.baseName.setLayoutData((Object)baseNameData);
        this.counter = new Spinner((Composite)saveGroup, 2048);
        this.counter.setMinimum(0);
        this.counter.setMaximum(1000);
        this.counter.setSelection(1);
        this.counter.setIncrement(1);
        this.counter.setPageIncrement(1);
        Button saveClip = new Button((Composite)saveGroup, 8);
        saveClip.setText("Selected Save");
        saveClip.addSelectionListener((SelectionListener)new SaveClip(true));
        Button saveAll = new Button((Composite)saveGroup, 8);
        saveAll.setText("All Save");
        saveAll.addSelectionListener((SelectionListener)new SaveClip(false));
        this.sc = new ScrolledComposite(root, 768);
        this.sc.setLayoutData((Object)new GridData(1808));
        this.sc.setLayoutData((Object)new GridData(1808));
        this.sc.setLayout((Layout)new GridLayout(1, false));
        this.sc.setBackground(new org.eclipse.swt.graphics.Color(null, 230, 230, 230));
        this.canvas = new FigureCanvas((Composite)this.sc, 262144);
        this.canvas.addMouseMoveListener((MouseMoveListener)new MouseMove());
        this.canvas.addMouseListener((org.eclipse.swt.events.MouseListener)new MouseClick());
        this.canvas.addKeyListener((KeyListener)new DelKeyDeleteFigure());
        this.sc.setContent((Control)this.canvas);
        this.figurePanel = new Panel();
        this.figurePanel.setLayoutManager((LayoutManager)new XYLayout());
        this.imageFigure = new ImageFigure(null);
        this.figurePanel.add((IFigure)this.imageFigure);
        this.canvas.setContents((IFigure)this.figurePanel);
        this.clip = new RectangleFigure(0, 0, 100, 100);
        this.figurePanel.add((IFigure)this.clip);
        this.clip.addMouseListener(this.figureMover);
        this.clip.addMouseMotionListener((MouseMotionListener)this.figureMover);
    }

    public void openImage(File file) {
        Image image = new Image(null, file.getAbsolutePath());
        this.imageFigure.setImage(image);
        this.canvas.setSize(this.imageFigure.getPreferredSize().width, this.imageFigure.getPreferredSize().height);
        this.clip.setSize(100, 100);
        this.clip.setLocation(new Point(0, 0));
        String name = file.getParentFile().getName();
        this.baseName.setText(name);
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ImageListView.SelectFile selectFile = (ImageListView.SelectFile)selection;
        this.openImage(selectFile.getFile());
    }

    public class DelKeyDeleteFigure
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 127) {
                ImageEditView.this.figureMover.deleteFigure();
            }
        }
    }

    public class PersetnChange
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            String item = ImageEditView.this.imagePersent.getItem(ImageEditView.this.imagePersent.getSelectionIndex());
            double persent = Double.parseDouble(item.substring(0, item.length() - 1)) / 100.0;
            ImageEditView.this.imageFigure.setZoom(persent);
            ImageEditView.this.canvas.setSize(((ImageEditView)ImageEditView.this).imageFigure.getPreferredSize().width, ((ImageEditView)ImageEditView.this).imageFigure.getPreferredSize().height);
            ImageEditView.this.canvas.redraw();
        }
    }

    public class SaveClip
    implements SelectionListener {
        private boolean selection;

        public SaveClip(boolean selection) {
            this.selection = selection;
        }

        public void widgetSelected(SelectionEvent e) {
            Rectangle rect = null;
            Image image = ImageEditView.this.imageFigure.getImage();
            if (this.selection) {
                rect = ImageEditView.this.clip.getBounds();
            } else {
                int imgw = (int)((double)image.getBounds().width * ImageEditView.this.imageFigure.getZoom());
                int imgh = (int)((double)image.getBounds().height * ImageEditView.this.imageFigure.getZoom());
                rect = new Rectangle(0, 0, imgw, imgh);
            }
            BufferedImage bimage = new BufferedImage(rect.width, rect.height, 2);
            Graphics2D g2 = (Graphics2D)bimage.getGraphics();
            ImageEditView.this.drawFiguresToGraphics2D(g2, this.selection);
            try {
                File nextFile = ImageEditView.this.nextFile();
                log.info((Object)("save:" + nextFile));
                ImageIO.write((RenderedImage)bimage, "png", nextFile);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class MouseMove
    implements MouseMoveListener {
        public void mouseMove(org.eclipse.swt.events.MouseEvent e) {
            if (e.stateMask != 0) {
                ImageEditView.this.figureMover.moveOutSide(e.x, e.y);
            }
        }
    }

    public class MouseClick
    implements org.eclipse.swt.events.MouseListener {
        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            if (ImageEditView.this.ovalButton.getSelection()) {
                OvalFigure figure = new OvalFigure(e.x - 15, e.y - 15, 30, 30);
                figure.addMouseListener(ImageEditView.this.figureMover);
                figure.addMouseMotionListener((MouseMotionListener)ImageEditView.this.figureMover);
                ImageEditView.this.figurePanel.add((IFigure)figure);
                figure.setFocusTraversable(true);
            } else if (ImageEditView.this.lineButton.getSelection()) {
                LineFigure figure = new LineFigure(e.x, e.y, 30, 30);
                figure.addMouseListener(ImageEditView.this.figureMover);
                figure.addMouseMotionListener((MouseMotionListener)ImageEditView.this.figureMover);
                ImageEditView.this.figurePanel.add((IFigure)figure);
            } else if (ImageEditView.this.selectButton.getSelection()) {
                ImageEditView.this.clip.setLocation(new Point(e.x, e.y));
            }
        }

        public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
        }

        public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
        }
    }

    public static interface ResizableFigure {
        public boolean isResizeBox(Point var1);

        public void resize(int var1, int var2);
    }

    public class FigureMover
    extends MouseMotionListener.Stub
    implements MouseListener {
        private Figure currentFigure;
        private Point lastPoint;
        boolean resize;

        public void move(int x, int y) {
            if (this.currentFigure != null && this.lastPoint != null) {
                Point newPoint = new Point(x, y);
                Dimension delta = newPoint.getDifference(this.lastPoint);
                this.lastPoint = newPoint;
                if (this.resize) {
                    ResizableFigure f = (ResizableFigure)this.currentFigure;
                    f.resize(delta.width, delta.height);
                } else {
                    this.currentFigure.setBounds(this.currentFigure.getBounds().getTranslated(delta.width, delta.height));
                }
            }
        }

        public void deleteFigure() {
            log.info((Object)this.currentFigure);
            if (this.currentFigure != null) {
                log.info((Object)"delete");
                if (this.currentFigure instanceof OvalFigure) {
                    this.currentFigure.erase();
                    this.currentFigure.getParent().remove((IFigure)this.currentFigure);
                } else if (this.currentFigure instanceof LineFigure) {
                    this.currentFigure.erase();
                    this.currentFigure.getParent().remove((IFigure)this.currentFigure);
                }
            }
        }

        public void moveOutSide(int x, int y) {
            if (this.currentFigure != null && !this.currentFigure.containsPoint(x, y)) {
                this.move(x, y);
            }
        }

        public void mouseDoubleClicked(MouseEvent arg0) {
        }

        public void mouseDragged(MouseEvent me) {
            this.move(me.x, me.y);
        }

        public void mousePressed(MouseEvent me) {
            if (this.currentFigure != null) {
                this.currentFigure.setBorder(null);
            }
            this.currentFigure = (Figure)me.getSource();
            this.currentFigure.setBorder((Border)new FocusBorder());
            this.lastPoint = new Point(me.x, me.y);
            this.resize = this.currentFigure instanceof ResizableFigure ? ((ResizableFigure)this.currentFigure).isResizeBox(this.lastPoint) : false;
            ImageEditView.this.figurePanel.repaint();
        }

        public void mouseReleased(MouseEvent arg0) {
            this.lastPoint = null;
        }
    }

    public class ImageFigure
    extends Figure {
        private Image image;
        private double zoom = 1.0;

        public ImageFigure(Image image) {
            this.setImage(image);
            this.setSize(100, 100);
            this.setBorder((Border)new LineBorder());
        }

        public Dimension getPreferredSize(int whint, int hhint) {
            if (this.image == null) {
                return new Dimension(0, 0);
            }
            if (this.zoom == 1.0) {
                return new Dimension(this.image.getBounds().width, this.image.getBounds().height);
            }
            int w = (int)((double)this.image.getBounds().width * this.zoom);
            int h = (int)((double)this.image.getBounds().height * this.zoom);
            log.info((Object)("imageFigure:" + w + "," + h));
            return new Dimension(w, h);
        }

        public void paintFigure(Graphics g) {
            if (this.image != null) {
                if (this.zoom == 1.0) {
                    g.drawImage(this.image, 0, 0);
                } else {
                    int w = (int)((double)this.image.getBounds().width * this.zoom);
                    int h = (int)((double)this.image.getBounds().height * this.zoom);
                    g.drawImage(this.image, 0, 0, this.image.getBounds().width, this.image.getBounds().height, 0, 0, w, h);
                }
            }
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = image;
            this.setSize(this.getPreferredSize());
            this.repaint();
        }

        public double getZoom() {
            return this.zoom;
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
        }
    }
}

