/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.internal.menus.IMenuContribution;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.services.ExpressionAuthority;

final class MenuAuthority
extends ExpressionAuthority {
    private final Map menuContributionsByElement = new HashMap();
    private final Set[] showingContributionsBySourcePriority = new Set[33];
    private final Window window;

    MenuAuthority(Window window) {
        this.window = window;
    }

    final void contributeMenu(IMenuContribution contribution) {
        ArrayList<IMenuContribution> menuContributions;
        MenuElement element = contribution.getMenuElement();
        Object value = this.menuContributionsByElement.get((Object)element);
        if (value instanceof Collection) {
            menuContributions = (ArrayList<IMenuContribution>)value;
            if (!menuContributions.contains(contribution)) {
                menuContributions.add(contribution);
            }
        } else if (value instanceof IMenuContribution) {
            if (value != contribution) {
                menuContributions = new ArrayList<IMenuContribution>(2);
                menuContributions.add((IMenuContribution)value);
                menuContributions.add(contribution);
                this.menuContributionsByElement.put(element, menuContributions);
            }
        } else {
            this.menuContributionsByElement.put(element, contribution);
        }
        if (contribution.getMenuElement().isShowing(this.window)) {
            int sourcePriority = contribution.getSourcePriority();
            int i = 1;
            while (i <= 32) {
                if ((sourcePriority & 1 << i) != 0) {
                    HashSet<IMenuContribution> contributions = this.showingContributionsBySourcePriority[i];
                    if (contributions == null) {
                        this.showingContributionsBySourcePriority[i] = contributions = new HashSet<IMenuContribution>(1);
                    }
                    contributions.add(contribution);
                }
                ++i;
            }
        }
    }

    final void removeContribution(IMenuContribution contribution) {
        MenuElement element = contribution.getMenuElement();
        Object value = this.menuContributionsByElement.get((Object)element);
        if (value instanceof Collection) {
            Collection menuContributions = (Collection)value;
            if (menuContributions.contains(contribution)) {
                menuContributions.remove(contribution);
                if (menuContributions.isEmpty()) {
                    this.menuContributionsByElement.remove((Object)element);
                } else if (menuContributions.size() == 1) {
                    IMenuContribution remainingContribution = (IMenuContribution)menuContributions.iterator().next();
                    this.menuContributionsByElement.put(element, remainingContribution);
                }
            }
        } else if (value instanceof IMenuContribution && value == contribution) {
            this.menuContributionsByElement.remove((Object)element);
        }
        if (element.isShowing(this.window)) {
            int sourcePriority = contribution.getSourcePriority();
            int i = 1;
            while (i <= 32) {
                Set contributions;
                if ((sourcePriority & 1 << i) != 0 && (contributions = this.showingContributionsBySourcePriority[i]) != null) {
                    contributions.remove(contribution);
                    if (contributions.isEmpty()) {
                        this.showingContributionsBySourcePriority[i] = null;
                    }
                }
                ++i;
            }
        }
    }

    protected final void sourceChanged(int sourcePriority) {
        HashSet contributionsToRecompute = new HashSet();
        int i = 1;
        while (i <= 32) {
            Set contributions;
            if ((sourcePriority & 1 << i) != 0 && (contributions = this.showingContributionsBySourcePriority[i]) != null) {
                Iterator contributionItr = contributions.iterator();
                while (contributionItr.hasNext()) {
                    contributionsToRecompute.add(contributionItr.next());
                }
            }
            ++i;
        }
        Iterator contributionItr = contributionsToRecompute.iterator();
        while (contributionItr.hasNext()) {
            IMenuContribution contribution = (IMenuContribution)contributionItr.next();
            boolean currentlyVisible = this.evaluate(contribution);
            contribution.clearResult();
            boolean newVisible = this.evaluate(contribution);
            if (newVisible == currentlyVisible) continue;
            contribution.getMenuElement().setVisible(this.window, newVisible);
        }
    }
}

