/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ThreadJob
extends Job {
    private final JobManager manager;
    protected boolean acquireRule = false;
    boolean isBlocked = false;
    protected boolean isRunning = false;
    private RuntimeException lastPush = null;
    protected Job realJob;
    private ISchedulingRule[] ruleStack;
    private int top;

    ThreadJob(JobManager manager, ISchedulingRule rule) {
        super("Implicit Job");
        this.manager = manager;
        this.setSystem(true);
        this.setPriority(10);
        this.ruleStack = new ISchedulingRule[2];
        this.top = -1;
        this.setRule(rule);
    }

    private void illegalPop(ISchedulingRule rule) {
        StringBuffer buf = new StringBuffer("Attempted to endRule: ");
        buf.append(rule);
        if (this.top >= 0 && this.top < this.ruleStack.length) {
            buf.append(", does not match most recent begin: ");
            buf.append(this.ruleStack[this.top]);
        } else if (this.top < 0) {
            buf.append(", but there was no matching beginRule");
        } else {
            buf.append(", but the rule stack was out of bounds: " + this.top);
        }
        buf.append(".  See log for trace information if rule tracing is enabled.");
        String msg = buf.toString();
        if (JobManager.DEBUG || JobManager.DEBUG_BEGIN_END) {
            System.out.println(msg);
            RuntimeException t = this.lastPush == null ? new IllegalArgumentException() : this.lastPush;
            Status error = new Status(4, "org.eclipse.core.jobs", 1, msg, (Throwable)t);
            RuntimeLog.log((IStatus)error);
        }
        Assert.isLegal((boolean)false, (String)msg);
    }

    private void illegalPush(ISchedulingRule pushRule, ISchedulingRule baseRule) {
        StringBuffer buf = new StringBuffer("Attempted to beginRule: ");
        buf.append(pushRule);
        buf.append(", does not match outer scope rule: ");
        buf.append(baseRule);
        String msg = buf.toString();
        if (JobManager.DEBUG) {
            System.out.println(msg);
            Status error = new Status(4, "org.eclipse.core.jobs", 1, msg, (Throwable)new IllegalArgumentException());
            RuntimeLog.log((IStatus)error);
        }
        Assert.isLegal((boolean)false, (String)msg);
    }

    private boolean isCanceled(IProgressMonitor monitor) {
        try {
            return monitor.isCanceled();
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "org.eclipse.core.jobs", 2, "ThreadJob.isCanceled", (Throwable)e);
            RuntimeLog.log((IStatus)status);
            return false;
        }
    }

    synchronized boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ThreadJob joinRun(IProgressMonitor monitor) {
        if (this.isCanceled(monitor)) {
            throw new OperationCanceledException();
        }
        blockingJob = this.manager.findBlockingJob(this);
        blocker = blockingJob == null ? null : blockingJob.getThread();
        result = this;
        try {
            if (this.manager.getLockManager().aboutToWait(blocker)) {
                var12_5 = this;
                var10_6 = null;
                this.manager.getLockManager().aboutToRelease();
                return var12_5;
            }
            try {
                this.waitStart(monitor, blockingJob);
                currentThread = Thread.currentThread();
                while (true) lbl-1000:
                // 2 sources

                {
                    if (this.isCanceled(monitor)) {
                        throw new OperationCanceledException();
                    }
                    if (!this.manager.runNow(this)) break block16;
                    var9_13 = this;
                    var7_16 = null;
                    if (this != result) break block17;
                    this.waitEnd(monitor);
                    break;
                }
            }
            catch (Throwable var8_20) {
                var7_19 = null;
                if (this != result) throw var8_20;
                this.waitEnd(monitor);
                throw var8_20;
            }
            {
                block20: {
                    block21: {
                        block18: {
                            block19: {
                                block16: {
                                    block17: {
                                    }
                                    var10_7 = null;
                                    this.manager.getLockManager().aboutToRelease();
                                    return var9_13;
                                }
                                blockingJob = this.manager.findBlockingJob(this);
                                v0 = blocker = blockingJob == null ? null : blockingJob.getThread();
                                if (blocker != currentThread || !(blockingJob instanceof ThreadJob)) break block18;
                                result = (ThreadJob)blockingJob;
                                result.push(this.getRule());
                                result.isBlocked = this.isBlocked;
                                var9_14 = result;
                                var7_17 = null;
                                if (this != result) break block19;
                                this.waitEnd(monitor);
                            }
                            var10_8 = null;
                            this.manager.getLockManager().aboutToRelease();
                            return var9_14;
                        }
                        if (!this.manager.getLockManager().aboutToWait(blocker)) break block20;
                        var9_15 = this;
                        var7_18 = null;
                        if (this != result) break block21;
                        this.waitEnd(monitor);
                    }
                    var10_9 = null;
                    this.manager.getLockManager().aboutToRelease();
                    return var9_15;
                }
                var6_12 = this;
                synchronized (var6_12) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException v1) {}
                    continue;
                }
                ** while (true)
            }
        }
        catch (Throwable var11_21) {
            var10_10 = null;
            this.manager.getLockManager().aboutToRelease();
            throw var11_21;
        }
    }

    boolean pop(ISchedulingRule rule) {
        if (this.top < 0 || this.ruleStack[this.top] != rule) {
            this.illegalPop(rule);
        }
        this.ruleStack[this.top--] = null;
        return this.top < 0;
    }

    void push(ISchedulingRule rule) {
        ISchedulingRule baseRule = this.getRule();
        if (++this.top >= this.ruleStack.length) {
            ISchedulingRule[] newStack = new ISchedulingRule[this.ruleStack.length * 2];
            System.arraycopy(this.ruleStack, 0, newStack, 0, this.ruleStack.length);
            this.ruleStack = newStack;
        }
        this.ruleStack[this.top] = rule;
        if (JobManager.DEBUG_BEGIN_END) {
            this.lastPush = (RuntimeException)new RuntimeException().fillInStackTrace();
        }
        if (baseRule != null && rule != null && !baseRule.contains(rule)) {
            this.illegalPush(rule, baseRule);
        }
    }

    boolean recycle() {
        if (this.getState() != 0) {
            return false;
        }
        this.isBlocked = false;
        this.isRunning = false;
        this.acquireRule = false;
        this.realJob = null;
        this.setRule(null);
        this.setThread(null);
        if (this.ruleStack.length != 2) {
            this.ruleStack = new ISchedulingRule[2];
        } else {
            this.ruleStack[1] = null;
            this.ruleStack[0] = null;
        }
        this.top = -1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        ThreadJob threadJob = this;
        synchronized (threadJob) {
            this.isRunning = true;
            this.notify();
        }
        return Job.ASYNC_FINISH;
    }

    void setRealJob(Job realJob) {
        this.realJob = realJob;
    }

    boolean shouldInterrupt() {
        return this.realJob == null ? true : !this.realJob.isSystem();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ThreadJob");
        buf.append('(').append(this.realJob).append(',').append('[');
        int i = 0;
        while (i <= this.top && i < this.ruleStack.length) {
            buf.append(this.ruleStack[i]).append(',');
            ++i;
        }
        buf.append(']').append(')');
        return buf.toString();
    }

    private void waitEnd(IProgressMonitor monitor) {
        LockManager lockManager = this.manager.getLockManager();
        Thread currentThread = Thread.currentThread();
        if (this.isRunning()) {
            lockManager.addLockThread(currentThread, this.getRule());
            lockManager.resumeSuspendedLocks(currentThread);
        } else {
            lockManager.removeLockWaitThread(currentThread, this.getRule());
        }
    }

    private void waitStart(IProgressMonitor monitor, InternalJob blockingJob) {
        this.manager.getLockManager().addLockWaitThread(Thread.currentThread(), this.getRule());
        this.isBlocked = true;
        this.manager.reportBlocked(monitor, blockingJob);
    }
}

