/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class FileCache {
    private static final String CACHE_DIR_NAME = "filecache";
    private static final Object creationLock = new Object();
    private static FileCache instance = null;
    private File cacheDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCache getCache() throws CoreException {
        Object object = creationLock;
        synchronized (object) {
            if (instance == null) {
                instance = new FileCache();
            }
            return instance;
        }
    }

    private FileCache() throws CoreException {
        IPath location = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.core.filesystem"));
        File cacheParent = new File(location.toFile(), CACHE_DIR_NAME);
        this.cleanOldCache(cacheParent);
        cacheParent.mkdirs();
        this.cacheDir = this.getUniqueDirectory(cacheParent, true);
    }

    public File cache(IFileStore source, IProgressMonitor monitor) throws CoreException {
        File file;
        IFileInfo myInfo;
        block5: {
            monitor.beginTask(NLS.bind((String)Messages.copying, (Object)this.toString()), 100);
            myInfo = source.fetchInfo(0, Policy.subMonitorFor(monitor, 25));
            if (myInfo.exists()) break block5;
            File file2 = new File(this.cacheDir, "Non-Existent-" + System.currentTimeMillis());
            Object var6_6 = null;
            monitor.done();
            return file2;
        }
        try {
            File result = myInfo.isDirectory() ? this.getUniqueDirectory(this.cacheDir, false) : File.createTempFile(source.getFileSystem().getScheme(), "efs", this.cacheDir);
            monitor.worked(25);
            LocalFile resultStore = new LocalFile(result);
            source.copy(resultStore, 2, Policy.subMonitorFor(monitor, 25));
            result.deleteOnExit();
            file = result;
            Object var6_7 = null;
        }
        catch (IOException iOException) {
            try {
                Policy.error(272, NLS.bind((String)Messages.couldNotWrite, (Object)this.toString()));
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return null;
        }
        monitor.done();
        return file;
    }

    private void cleanOldCache(File cacheParent) throws CoreException {
        new LocalFile(cacheParent).delete(0, null);
    }

    private File getUniqueDirectory(File parent, boolean create) {
        File dir;
        long i = 0L;
        while ((dir = new File(parent, Long.toString(System.currentTimeMillis() + i++))).exists()) {
        }
        if (create) {
            dir.mkdir();
        }
        return dir;
    }
}

