/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.imageedit.figures;

import jp.sourceforge.akjrcp.imageedit.ImageEditView;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class LineFigure
extends Figure
implements ImageEditView.ResizableFigure {
    private Color color = new Color(null, 200, 0, 0);
    private int resizeBoxSize = 20;
    private int minBound = 20;

    public LineFigure(int x, int y, int width, int height) {
        this.setSize(width, this.resizeBoxSize);
        this.setLocation(new Point(x, y));
    }

    public boolean isResizeBox(Point pt) {
        Rectangle rect = new Rectangle(this.getLocation().x + this.getBounds().width - this.resizeBoxSize, this.getLocation().y + this.getBounds().height - this.resizeBoxSize, this.resizeBoxSize, this.resizeBoxSize);
        return rect.contains(pt);
    }

    public void paintFigure(Graphics g) {
        g.setForegroundColor(this.color);
        g.setLineWidth(6);
        g.drawLine(this.getLocation().x, this.getLocation().y, this.getLocation().x + this.getBounds().width, this.getLocation().y);
        g.setLineWidth(1);
        g.drawRectangle(this.getLocation().x + this.getBounds().width - this.resizeBoxSize, this.getLocation().y + this.getBounds().height - this.resizeBoxSize, this.resizeBoxSize - 1, this.resizeBoxSize - 1);
    }

    public void resize(int incrementWidth, int incrementHeight) {
        this.setSize(Math.max(this.minBound, this.getBounds().width + incrementWidth), this.getBounds().height);
    }
}

