/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessMonitor {
    Log log = LogFactory.getLog(ProcessMonitor.class);
    Process process;
    boolean monitor;
    ProcessPrinter printer;
    private boolean monitorInput = true;
    private boolean monitorError = true;
    InputStream inputReader;
    InputStream errorReader;

    public ProcessMonitor(Process process, ProcessPrinter printer) {
        this.process = process;
        this.printer = printer;
    }

    public void startMonitor() {
        this.monitor = true;
        if (this.monitorError) {
            new ErrorMonitor().start();
        }
        if (this.monitorInput) {
            new InputMonitor().start();
        }
    }

    public void stop() {
        try {
            this.inputReader.close();
            this.errorReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isMonitorInput() {
        return this.monitorInput;
    }

    public void setMonitorInput(boolean monitorInput) {
        this.monitorInput = monitorInput;
    }

    public boolean isMonitorError() {
        return this.monitorError;
    }

    public void setMonitorError(boolean monitorError) {
        this.monitorError = monitorError;
    }

    public class ErrorMonitor
    extends Thread {
        public void run() {
            ProcessMonitor.this.errorReader = ProcessMonitor.this.process.getErrorStream();
            StringBuffer buffer = new StringBuffer();
            try {
                int b;
                while ((b = ProcessMonitor.this.errorReader.read()) != -1) {
                    if ((char)b == '\n') {
                        ProcessMonitor.this.printer.printError(String.valueOf(buffer.toString()) + "\n");
                        buffer = new StringBuffer();
                        continue;
                    }
                    if ((char)b == '\r') {
                        ProcessMonitor.this.printer.printError(String.valueOf(buffer.toString()) + "\n");
                        buffer = new StringBuffer();
                        continue;
                    }
                    buffer.append((char)b);
                }
                ProcessMonitor.this.errorReader.close();
                if (buffer.length() > 0) {
                    ProcessMonitor.this.printer.printError(String.valueOf(buffer.toString()) + "\n");
                }
            }
            catch (IOException e) {
                try {
                    ProcessMonitor.this.errorReader.close();
                    ProcessMonitor.this.inputReader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    public class InputMonitor
    extends Thread {
        public void run() {
            ProcessMonitor.this.inputReader = ProcessMonitor.this.process.getInputStream();
            StringBuffer buffer = new StringBuffer();
            try {
                int b;
                while ((b = ProcessMonitor.this.inputReader.read()) != -1) {
                    if ((char)b == '\n') {
                        ProcessMonitor.this.printer.printOutput(String.valueOf(buffer.toString()) + "\n");
                        buffer = new StringBuffer();
                        continue;
                    }
                    if ((char)b == '\r') {
                        ProcessMonitor.this.printer.printOutput(String.valueOf(buffer.toString()) + "\n");
                        buffer = new StringBuffer();
                        continue;
                    }
                    buffer.append((char)b);
                }
                ProcessMonitor.this.inputReader.close();
                if (buffer.length() > 0) {
                    ProcessMonitor.this.printer.printOutput(String.valueOf(buffer.toString()) + "\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

