/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.muxsubtitle;

import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingView;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVFileEffector;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.videotools.muxsubtitle.SubtitleFLVFileEffector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class MuxSubtitleView
extends ViewPart {
    public static Log log = LogFactory.getLog(MuxSubtitleView.class);
    public static final String ID = MuxSubtitleView.class.getName();
    Composite composite;
    private FileDirChoicer inputFileChooser;
    private FileDirChoicer srtFileChooser;
    private FileDirChoicer outputFileChooser;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.inputFileChooser = new FileDirChoicer(parent, 2048, 0, "Input File");
        this.inputFileChooser.setLayoutData(new GridData(768));
        this.srtFileChooser = new FileDirChoicer(parent, 2048, 0, "Srt File");
        this.srtFileChooser.setLayoutData(new GridData(768));
        this.outputFileChooser = new FileDirChoicer(parent, 2048, 2, "output File");
        this.outputFileChooser.setLayoutData(new GridData(768));
        this.inputFileChooser.setFilePath("c:\\tmp\\happy.flv");
        this.outputFileChooser.setFilePath("c:\\tmp\\output.flv");
        Button exec = new Button(parent, 0);
        exec.setText("exec");
        exec.addSelectionListener((SelectionListener)new MuxSrt());
    }

    public void muxSubtitle() {
        String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
        SubtitleFLVFileEffector effector = new SubtitleFLVFileEffector(ffmpegPath, this.inputFileChooser.getFile(), this.outputFileChooser.getFile());
        effector.setInputImageType(0);
        effector.setOutputImageType(0);
        effector.start();
        long starttime = System.currentTimeMillis();
        while (!effector.isDoneRead() || !effector.isDoneWrite()) {
            try {
                Thread.sleep(3000L);
                this.setStatusValue(String.valueOf(FFMpegFLVFileEffector.doneFrames) + "frames done.it's about " + FFMpegFLVFileEffector.doneFrames / 30L + "second");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("***finally finished***");
        long end = System.currentTimeMillis() - starttime;
        String min = "" + end / 1000L / 60L;
        log.info((Object)("time:" + min + " min"));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setStatusValue(String value) {
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new SetMessage(value));
    }

    public void setFocus() {
    }

    public class SetMessage
    implements Runnable {
        String message;

        SetMessage(String message) {
            this.message = message;
        }

        public void run() {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)DropsomethingView.viewSite.getWorkbenchWindow();
            WWinActionBars actionBars = workbenchWindow.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(this.message);
        }
    }

    public class MuxSrt
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MuxSubtitleView.this.muxSubtitle();
        }
    }
}

