/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.youtubedl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class YoutubeUtils {
    public static String toWWWUrl(String url) {
        Pattern titlePattern = Pattern.compile("(.*)(\\.youtube.com/watch?.*$)");
        Matcher match = titlePattern.matcher(url);
        if (match.matches()) {
            return "http://www" + match.group(2);
        }
        return url;
    }

    public static String getId(URL url) {
        String id = null;
        String q = url.getQuery();
        String[] values = q.split("&");
        int i = 0;
        while (i < values.length) {
            if (values[i].startsWith("v=")) {
                id = values[i].substring(2);
                break;
            }
            ++i;
        }
        return id;
    }

    public static String getTitle(String key) {
        String base = "http://www.youtube.com/watch?v=" + key;
        try {
            return YoutubeUtils.getTitle(new URL(base));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTitle(URL url) {
        try {
            int b;
            InputStreamReader input = new InputStreamReader(url.openStream(), "UTF-8");
            int readed = 0;
            StringBuffer buffer = new StringBuffer();
            while ((b = input.read()) != -1) {
                buffer.append((char)b);
                if (++readed > 400 && buffer.toString().indexOf("</title>") != -1) break;
            }
            input.close();
            String html = buffer.toString().replaceAll("\n", "");
            Pattern titlePattern = Pattern.compile(".*<title>YouTube\\s*-\\s*(.*)</title>.*");
            Matcher match = titlePattern.matcher(html);
            if (match.matches()) {
                return match.group(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String toFileName(String title) {
        if ((title = title.substring(0, Math.min(251, title.length()))).startsWith(".")) {
            title = "\u3002" + title.substring(1);
        }
        String shoudreplace = "/:;,*?\"<>|?";
        String replace = "\u30fb\uff1a\uff1b\u3001\uff0a\uff1f\uffe5\u201d\uff1c\uff1e\uff5c\uff1f";
        String ret = title;
        ret = StringUtils.replaceChars((String)ret, (String)shoudreplace, (String)replace);
        return ret;
    }

    public static boolean isYoutubeURL(String url) {
        if (url == null) {
            return false;
        }
        if (url.length() < "http://youtube.com/watch?v=".length()) {
            return false;
        }
        if (!url.startsWith("http://")) {
            return false;
        }
        try {
            String key;
            URL u = new URL(url);
            if (u.getHost().toLowerCase().endsWith("youtube.com") && (key = YoutubeUtils.getId(u)) != null) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

