/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public class BuildAction
extends WorkspaceAction {
    public static final String ID_BUILD = "org.eclipse.ui.BuildAction";
    public static final String ID_REBUILD_ALL = "org.eclipse.ui.RebuildAllAction";
    private int buildType;
    private List projectsToBuild = null;

    public BuildAction(Shell shell, int type) {
        super(shell, "");
        if (type == 10) {
            this.setText(IDEWorkbenchMessages.BuildAction_text);
            this.setToolTipText(IDEWorkbenchMessages.BuildAction_toolTip);
            this.setId(ID_BUILD);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.incremental_build_action_context");
        } else {
            this.setText(IDEWorkbenchMessages.RebuildAction_text);
            this.setToolTipText(IDEWorkbenchMessages.RebuildAction_tooltip);
            this.setId(ID_REBUILD_ALL);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.full_build_action_context");
        }
        this.buildType = type;
    }

    private void addAllProjects(IProject project, HashSet projects) {
        if (project == null || !project.isAccessible() || projects.contains(project)) {
            return;
        }
        projects.add(project);
        try {
            IProject[] preReqs = project.getReferencedProjects();
            int i = 0;
            while (i < preReqs.length) {
                this.addAllProjects(preReqs[i], projects);
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected List getActionResources() {
        return this.getProjectsToBuild();
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.BuildAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.BuildAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.BuildAction_problemTitle;
    }

    List getProjectsToBuild() {
        if (this.projectsToBuild == null) {
            this.projectsToBuild = new ArrayList(3);
            Iterator i = this.getSelectedResources().iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                IProject project = resource.getProject();
                if (project == null || this.projectsToBuild.contains(project) || !this.hasBuilder(project)) continue;
                this.projectsToBuild.add(project);
            }
        }
        return this.projectsToBuild;
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).build(this.buildType, monitor);
    }

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object[])BuildUtilities.findSelectedProjects(window)));
        }
        return super.isEnabled();
    }

    public static boolean isSaveAllSet() {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("SAVE_ALL_BEFORE_BUILD");
    }

    List pruneResources(List resourceCollection) {
        HashSet toBuild = new HashSet();
        Iterator it = resourceCollection.iterator();
        while (it.hasNext()) {
            this.addAllProjects((IProject)it.next(), toBuild);
        }
        if (toBuild.size() < 2) {
            return resourceCollection;
        }
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            ArrayList<Object> orderedProjects = new ArrayList<Object>(toBuild.size());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < orderedNames.length) {
                IProject handle = root.getProject(orderedNames[i]);
                if (toBuild.contains(handle)) {
                    orderedProjects.add(handle);
                    toBuild.remove(handle);
                }
                ++i;
            }
            orderedProjects.addAll(toBuild);
            return orderedProjects;
        }
        IProject[] projects = new IProject[toBuild.size()];
        projects = toBuild.toArray(projects);
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        ArrayList<IProject> orderedProjects = new ArrayList<IProject>();
        orderedProjects.addAll(Arrays.asList(po.projects));
        return orderedProjects;
    }

    public void run() {
        List projects = this.getProjectsToBuild();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        BuildUtilities.saveEditors(projects);
        this.runInBackground(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule(), ResourcesPlugin.FAMILY_MANUAL_BUILD);
    }

    protected boolean shouldPerformResourcePruning() {
        return true;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        this.projectsToBuild = null;
        IProject[] projects = this.getProjectsToBuild().toArray(new IProject[0]);
        return BuildUtilities.isEnabled(projects, 10);
    }
}

