/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.akjrcp.util.image.ImageUtils;

public class JpegPipeWriter {
    OutputStream outputStream;
    private float quality = 1.0f;

    public JpegPipeWriter(OutputStream output) {
        this.outputStream = output;
    }

    public void writeJpeg(BufferedImage image) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageUtils.writeJpegWithQuality(image, bout, this.quality);
        bout.close();
        byte[] jpegbyte = bout.toByteArray();
        this.outputStream.write(jpegbyte);
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    public void writeJpeg(InputStream input) throws IOException {
        int b;
        while ((b = input.read()) != -1) {
            this.outputStream.write(b);
        }
        input.close();
    }
}

