/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.imageedit;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.imageedit.BufferImageCasher;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ImageButton
extends Canvas
implements PaintListener,
MouseListener {
    String imageName;
    int imageWidth;
    int imageHeight;
    private boolean selected;
    private List selectionListeners = new ArrayList();
    private BufferImageCasher bufferImageCasher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionListener(SelectionListener listener) {
        ImageButton imageButton = this;
        synchronized (imageButton) {
            this.selectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListener(SelectionListener listener) {
        ImageButton imageButton = this;
        synchronized (imageButton) {
            this.selectionListeners.remove(listener);
        }
    }

    public ImageButton(Composite arg0, int arg1, int width, int height) {
        super(arg0, arg1);
        this.addPaintListener(this);
        this.imageWidth = width;
        this.imageHeight = height;
        this.setSize(width, height);
        this.addMouseListener(this);
    }

    public void paintControl(PaintEvent e) {
        Image image = this.bufferImageCasher.getImage(this.imageName);
        if (image != null) {
            e.gc.drawImage(image, 0, 0);
            image.dispose();
        }
        e.gc.setForeground(new Color(null, 128, 128, 128));
        if (this.selected) {
            e.gc.setLineWidth(6);
        } else {
            e.gc.setLineWidth(1);
        }
        e.gc.drawRectangle(0, 0, this.getClientArea().width - 1, this.getClientArea().height - 1);
    }

    public Point computeSize(int whint, int hhint, boolean bool) {
        return new Point(this.imageWidth, this.imageHeight);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        for (SelectionListener listener : this.selectionListeners) {
            Event ev = new Event();
            ev.widget = this;
            SelectionEvent event = new SelectionEvent(ev);
            listener.widgetSelected(event);
        }
        this.setFocus();
    }

    public void mouseUp(MouseEvent e) {
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public BufferImageCasher getBufferImageCasher() {
        return this.bufferImageCasher;
    }

    public void setBufferImageCasher(BufferImageCasher bufferImageCasher) {
        this.bufferImageCasher = bufferImageCasher;
    }
}

